/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema;

import java.util.Objects;
import lombok.Generated;

public final class HashColumn {
    private final String name;
    private final String tableName;
    private final boolean caseSensitive;
    private final int hashCode;

    public HashColumn(String name, String tableName, boolean caseSensitive) {
        this.name = name;
        this.tableName = tableName;
        this.caseSensitive = caseSensitive;
        this.hashCode = Objects.hash(name.toUpperCase(), tableName.toUpperCase());
    }

    public boolean equals(Object obj) {
        if (obj instanceof HashColumn) {
            HashColumn column = (HashColumn)obj;
            return this.name.equalsIgnoreCase(column.name) && this.tableName.equalsIgnoreCase(column.tableName) && this.caseSensitive == column.caseSensitive;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Generated
    public int getHashCode() {
        return this.hashCode;
    }

    @Generated
    public String toString() {
        return "HashColumn(name=" + this.getName() + ", tableName=" + this.getTableName() + ", caseSensitive=" + this.isCaseSensitive() + ", hashCode=" + this.getHashCode() + ")";
    }
}

