/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.distsql.parser.core;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.distsql.parser.autogen.SingleDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.SingleDistSQLStatementParser;
import org.apache.shardingsphere.distsql.statement.type.rql.rule.database.CountRuleStatement;
import org.apache.shardingsphere.single.distsql.segment.SingleTableSegment;
import org.apache.shardingsphere.single.distsql.statement.rdl.LoadSingleTableStatement;
import org.apache.shardingsphere.single.distsql.statement.rdl.SetDefaultSingleTableStorageUnitStatement;
import org.apache.shardingsphere.single.distsql.statement.rdl.UnloadSingleTableStatement;
import org.apache.shardingsphere.single.distsql.statement.rql.ShowDefaultSingleTableStorageUnitStatement;
import org.apache.shardingsphere.single.distsql.statement.rql.ShowSingleTablesStatement;
import org.apache.shardingsphere.single.distsql.statement.rql.ShowUnloadedSingleTablesStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.FromDatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.IdentifierValueUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SingleDistSQLStatementVisitor
extends SingleDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitCountSingleTable(SingleDistSQLStatementParser.CountSingleTableContext ctx) {
        return new CountRuleStatement(null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())), "SINGLE");
    }

    @Override
    public ASTNode visitSetDefaultSingleTableStorageUnit(SingleDistSQLStatementParser.SetDefaultSingleTableStorageUnitContext ctx) {
        return new SetDefaultSingleTableStorageUnitStatement(null == ctx.storageUnitName() ? null : IdentifierValueUtils.getValue((ParseTree)ctx.storageUnitName()));
    }

    @Override
    public ASTNode visitShowDefaultSingleTableStorageUnit(SingleDistSQLStatementParser.ShowDefaultSingleTableStorageUnitContext ctx) {
        return new ShowDefaultSingleTableStorageUnitStatement(null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName())));
    }

    @Override
    public ASTNode visitShowSingleTables(SingleDistSQLStatementParser.ShowSingleTablesContext ctx) {
        FromDatabaseSegment fromDatabase = null == ctx.databaseName() ? null : new FromDatabaseSegment(ctx.FROM().getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
        return new ShowSingleTablesStatement(fromDatabase, null == ctx.showLike() ? null : IdentifierValueUtils.getValue((ParseTree)ctx.showLike().likePattern()));
    }

    @Override
    public ASTNode visitLoadSingleTable(SingleDistSQLStatementParser.LoadSingleTableContext ctx) {
        Collection tables = ctx.tableDefinition().tableIdentifier().stream().map(this::getSingleTableSegment).collect(Collectors.toSet());
        return new LoadSingleTableStatement(tables);
    }

    @Override
    public ASTNode visitUnloadSingleTable(SingleDistSQLStatementParser.UnloadSingleTableContext ctx) {
        if (null != ctx.ALL() || null != ctx.ASTERISK_()) {
            return new UnloadSingleTableStatement(true, Collections.emptyList());
        }
        return new UnloadSingleTableStatement(false, (Collection)ctx.tableNames().tableName().stream().map(IdentifierValueUtils::getValue).collect(Collectors.toSet()));
    }

    private SingleTableSegment getSingleTableSegment(SingleDistSQLStatementParser.TableIdentifierContext ctx) {
        if (ctx instanceof SingleDistSQLStatementParser.AllTablesFromStorageUnitContext) {
            return new SingleTableSegment(IdentifierValueUtils.getValue((ParseTree)((SingleDistSQLStatementParser.AllTablesFromStorageUnitContext)ctx).storageUnitName()), "*");
        }
        if (ctx instanceof SingleDistSQLStatementParser.AllTablesFromSchemaContext) {
            SingleDistSQLStatementParser.AllTablesFromSchemaContext tableContext = (SingleDistSQLStatementParser.AllTablesFromSchemaContext)ctx;
            return new SingleTableSegment(IdentifierValueUtils.getValue((ParseTree)tableContext.storageUnitName()), IdentifierValueUtils.getValue((ParseTree)tableContext.schemaName()), "*");
        }
        if (ctx instanceof SingleDistSQLStatementParser.TableFromStorageUnitContext) {
            SingleDistSQLStatementParser.TableFromStorageUnitContext tableContext = (SingleDistSQLStatementParser.TableFromStorageUnitContext)ctx;
            return new SingleTableSegment(IdentifierValueUtils.getValue((ParseTree)tableContext.storageUnitName()), IdentifierValueUtils.getValue((ParseTree)tableContext.tableName()));
        }
        if (ctx instanceof SingleDistSQLStatementParser.TableFromSchemaContext) {
            SingleDistSQLStatementParser.TableFromSchemaContext tableContext = (SingleDistSQLStatementParser.TableFromSchemaContext)ctx;
            return new SingleTableSegment(IdentifierValueUtils.getValue((ParseTree)tableContext.storageUnitName()), IdentifierValueUtils.getValue((ParseTree)tableContext.schemaName()), IdentifierValueUtils.getValue((ParseTree)tableContext.tableName()));
        }
        if (ctx instanceof SingleDistSQLStatementParser.AllTablesContext) {
            return new SingleTableSegment("*", "*");
        }
        if (ctx instanceof SingleDistSQLStatementParser.AllSchamesAndTablesFromStorageUnitContext) {
            return new SingleTableSegment(IdentifierValueUtils.getValue((ParseTree)((SingleDistSQLStatementParser.AllSchamesAndTablesFromStorageUnitContext)ctx).storageUnitName()), "*", "*");
        }
        return new SingleTableSegment("*", "*", "*");
    }

    @Override
    public ASTNode visitShowUnloadedSingleTables(SingleDistSQLStatementParser.ShowUnloadedSingleTablesContext ctx) {
        return null == ctx.fromClause() ? new ShowUnloadedSingleTablesStatement(null, null, null) : this.visitShowUnloadedSingleTablesWithFromClause(ctx.FROM(), ctx.fromClause());
    }

    private ASTNode visitShowUnloadedSingleTablesWithFromClause(TerminalNode fromCtx, SingleDistSQLStatementParser.FromClauseContext ctx) {
        FromDatabaseSegment fromDatabase = null == ctx.databaseName() ? null : new FromDatabaseSegment(fromCtx.getSymbol().getStartIndex(), (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
        return new ShowUnloadedSingleTablesStatement(fromDatabase, null == ctx.storageUnitName() ? null : IdentifierValueUtils.getValue((ParseTree)ctx.storageUnitName()), null == ctx.schemaName() ? null : IdentifierValueUtils.getValue((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitDatabaseName(SingleDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }
}

