/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.impl;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.sql.SQLBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Attachable;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Substitutable;

public abstract class AbstractSQLBuilder
implements SQLBuilder {
    private final String sql;
    private final List<SQLToken> sqlTokens;

    @Override
    public final String toSQL() {
        if (this.sqlTokens.isEmpty()) {
            return this.sql;
        }
        Collections.sort(this.sqlTokens);
        StringBuilder result = new StringBuilder(this.sql.length());
        result.append(this.sql, 0, this.sqlTokens.get(0).getStartIndex());
        Optional<SQLToken> previousToken = Optional.empty();
        for (SQLToken each : this.sqlTokens) {
            if (!this.isContainsAttachableToken(each, previousToken.orElse(null)) && each.getStartIndex() <= previousToken.map(SQLToken::getStopIndex).orElse(0)) continue;
            this.appendRewriteSQL(each, result);
            previousToken = Optional.of(each);
        }
        return result.toString();
    }

    private boolean isContainsAttachableToken(SQLToken sqlToken, SQLToken previousToken) {
        return sqlToken instanceof Attachable || previousToken instanceof Attachable;
    }

    private void appendRewriteSQL(SQLToken sqlToken, StringBuilder builder) {
        builder.append(this.getSQLTokenText(sqlToken));
        builder.append(this.getConjunctionText(sqlToken, this.sqlTokens, this.sql.length()));
    }

    protected abstract String getSQLTokenText(SQLToken var1);

    private String getConjunctionText(SQLToken sqlToken, List<SQLToken> sqlTokens, int sqlLength) {
        int startIndex = this.getStartIndex(sqlToken, sqlLength);
        int stopIndex = this.getStopIndex(sqlToken, sqlTokens, sqlLength, startIndex);
        return this.sql.substring(startIndex, stopIndex);
    }

    private int getStartIndex(SQLToken sqlToken, int sqlLength) {
        int startIndex = sqlToken instanceof Substitutable ? ((Substitutable)((Object)sqlToken)).getStopIndex() + 1 : sqlToken.getStartIndex();
        return Math.min(startIndex, sqlLength);
    }

    private int getStopIndex(SQLToken sqlToken, List<SQLToken> sqlTokens, int sqlLength, int startIndex) {
        Optional<SQLToken> nextSQLToken = this.getNextSQLToken(sqlToken, sqlTokens);
        if (!nextSQLToken.isPresent()) {
            return sqlLength;
        }
        int stopIndex = nextSQLToken.get().getStartIndex();
        return startIndex <= stopIndex ? stopIndex : this.getStopIndex(nextSQLToken.get(), sqlTokens, sqlLength, startIndex);
    }

    private Optional<SQLToken> getNextSQLToken(SQLToken sqlToken, List<SQLToken> sqlTokens) {
        int currentSQLTokenIndex = sqlTokens.indexOf(sqlToken);
        if (sqlTokens.size() - 1 == currentSQLTokenIndex) {
            return Optional.empty();
        }
        return Optional.ofNullable(sqlTokens.get(currentSQLTokenIndex + 1));
    }

    @Generated
    public AbstractSQLBuilder(String sql, List<SQLToken> sqlTokens) {
        this.sql = sql;
        this.sqlTokens = sqlTokens;
    }
}

