/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.engine;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;

public final class GeneratedKeyContextEngine {
    private final InsertStatement insertStatement;
    private final ShardingSphereSchema schema;

    public Optional<GeneratedKeyContext> createGenerateKeyContext(Map<String, Integer> insertColumnNamesAndIndexes, List<InsertValueContext> insertValueContexts, List<Object> params) {
        String tableName = this.insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        return this.findGenerateKeyColumn(tableName).map(optional -> this.containsGenerateKey(insertColumnNamesAndIndexes, (String)optional) ? this.findGeneratedKey(insertColumnNamesAndIndexes, insertValueContexts, params, (String)optional) : new GeneratedKeyContext((String)optional, true));
    }

    private Optional<String> findGenerateKeyColumn(String tableName) {
        if (!this.schema.containsTable(tableName)) {
            return Optional.empty();
        }
        for (ShardingSphereColumn each : this.schema.getTable(tableName).getAllColumns()) {
            if (!each.isGenerated()) continue;
            return Optional.of(each.getName());
        }
        return Optional.empty();
    }

    private boolean containsGenerateKey(Map<String, Integer> insertColumnNamesAndIndexes, String generateKeyColumnName) {
        String tableName = this.insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        return insertColumnNamesAndIndexes.isEmpty() ? this.schema.getVisibleColumnNames(tableName).size() == this.getValueCountForPerGroup() : insertColumnNamesAndIndexes.containsKey(generateKeyColumnName);
    }

    private int getValueCountForPerGroup() {
        if (!this.insertStatement.getValues().isEmpty()) {
            return ((InsertValuesSegment)this.insertStatement.getValues().iterator().next()).getValues().size();
        }
        Optional setAssignment = this.insertStatement.getSetAssignment();
        if (setAssignment.isPresent()) {
            return ((SetAssignmentSegment)setAssignment.get()).getAssignments().size();
        }
        if (this.insertStatement.getInsertSelect().isPresent()) {
            return ((SubquerySegment)this.insertStatement.getInsertSelect().get()).getSelect().getProjections().getProjections().size();
        }
        return 0;
    }

    private GeneratedKeyContext findGeneratedKey(Map<String, Integer> insertColumnNamesAndIndexes, List<InsertValueContext> insertValueContexts, List<Object> params, String generateKeyColumnName) {
        int generateKeyIndex = this.findGenerateKeyIndex(insertColumnNamesAndIndexes, generateKeyColumnName);
        boolean generated = false;
        LinkedList generatedValues = new LinkedList();
        for (InsertValueContext each : insertValueContexts) {
            ExpressionSegment expression = each.getValueExpressions().get(generateKeyIndex);
            this.getGeneratedValue(params, expression).ifPresent(generatedValues::add);
        }
        GeneratedKeyContext result = new GeneratedKeyContext(generateKeyColumnName, generated);
        result.getGeneratedValues().addAll(generatedValues);
        return result;
    }

    private int findGenerateKeyIndex(Map<String, Integer> insertColumnNamesAndIndexes, String generateKeyColumnName) {
        String tableName = this.insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        return insertColumnNamesAndIndexes.isEmpty() ? (Integer)this.schema.getVisibleColumnAndIndexMap(tableName).get(generateKeyColumnName) : insertColumnNamesAndIndexes.get(generateKeyColumnName);
    }

    private Optional<Comparable<?>> getGeneratedValue(List<Object> params, ExpressionSegment expression) {
        if (expression instanceof ParameterMarkerExpressionSegment) {
            if (params.size() > ((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex() && null != params.get(((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex())) {
                return Optional.of((Comparable)params.get(((ParameterMarkerExpressionSegment)expression).getParameterMarkerIndex()));
            }
            return Optional.empty();
        }
        if (expression instanceof LiteralExpressionSegment && null != ((LiteralExpressionSegment)expression).getLiterals()) {
            return Optional.of((Comparable)((LiteralExpressionSegment)expression).getLiterals());
        }
        return Optional.empty();
    }

    @Generated
    public GeneratedKeyContextEngine(InsertStatement insertStatement, ShardingSphereSchema schema) {
        this.insertStatement = insertStatement;
        this.schema = schema;
    }
}

