/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.pagination.DialectPaginationOption;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine.LimitPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine.RowNumberPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine.TopPaginationContextEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.engine.TopProjectionExtractor;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.pagination.top.TopProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class PaginationContextEngine {
    private final DialectPaginationOption option;

    public PaginationContext createPaginationContext(SelectStatement selectStatement, ProjectionsContext projectionsContext, List<Object> params, Collection<WhereSegment> whereSegments) {
        Optional<TopProjectionSegment> topProjectionSegment;
        Optional limitSegment = selectStatement.getLimit();
        if (limitSegment.isPresent()) {
            return new LimitPaginationContextEngine().createPaginationContext((LimitSegment)limitSegment.get(), params);
        }
        LinkedList<ExpressionSegment> expressions = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : whereSegments) {
            expressions.add(each.getExpr());
        }
        if (this.option.isContainsTop() && (topProjectionSegment = TopProjectionExtractor.findTopProjection(selectStatement)).isPresent()) {
            return new TopPaginationContextEngine().createPaginationContext(topProjectionSegment.get(), expressions, params);
        }
        if (!expressions.isEmpty() && this.option.isContainsRowNumber()) {
            return new RowNumberPaginationContextEngine(this.option).createPaginationContext(expressions, projectionsContext, params);
        }
        return new PaginationContext(null, null, params);
    }

    @Generated
    public PaginationContextEngine(DialectPaginationOption option) {
        this.option = option;
    }
}

