/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.statement.ddl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.type.SimpleTableSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinder;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementCopyUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;

public final class AlterViewStatementBinder
implements SQLStatementBinder<AlterViewStatement> {
    @Override
    public AlterViewStatement bind(AlterViewStatement sqlStatement, SQLStatementBinderContext binderContext) {
        LinkedHashMultimap tableBinderContexts = LinkedHashMultimap.create();
        SimpleTableSegment boundView = SimpleTableSegmentBinder.bind(sqlStatement.getView(), binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
        SelectStatement boundSelect = sqlStatement.getSelect().map(optional -> new SelectStatementBinder().bind((SelectStatement)optional, binderContext)).orElse(null);
        SimpleTableSegment boundRenameView = sqlStatement.getRenameView().map(arg_0 -> AlterViewStatementBinder.lambda$bind$1(binderContext, (Multimap)tableBinderContexts, arg_0)).orElse(null);
        return this.copy(sqlStatement, boundView, boundSelect, boundRenameView);
    }

    private AlterViewStatement copy(AlterViewStatement sqlStatement, SimpleTableSegment boundView, SelectStatement boundSelect, SimpleTableSegment boundRenameView) {
        AlterViewStatement result = new AlterViewStatement(sqlStatement.getDatabaseType());
        result.setView(boundView);
        result.setSelect(boundSelect);
        result.setRenameView(boundRenameView);
        sqlStatement.getViewDefinition().ifPresent(arg_0 -> ((AlterViewStatement)result).setViewDefinition(arg_0));
        sqlStatement.getConstraintDefinition().ifPresent(arg_0 -> ((AlterViewStatement)result).setConstraintDefinition(arg_0));
        SQLStatementCopyUtils.copyAttributes((SQLStatement)sqlStatement, (SQLStatement)result);
        return result;
    }

    private static /* synthetic */ SimpleTableSegment lambda$bind$1(SQLStatementBinderContext binderContext, Multimap tableBinderContexts, SimpleTableSegment optional) {
        return SimpleTableSegmentBinder.bind(optional, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)tableBinderContexts);
    }
}

