/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ScopeConfigurator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.ViewBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.MeterConfig;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.view.StringPredicates;

public final class SdkMeterProviderUtil {
    private SdkMeterProviderUtil() {
    }

    public static void setMeterConfigurator(SdkMeterProvider sdkMeterProvider, ScopeConfigurator<MeterConfig> scopeConfigurator) {
        try {
            Method method = SdkMeterProvider.class.getDeclaredMethod("setMeterConfigurator", ScopeConfigurator.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProvider, scopeConfigurator);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setMeterConfigurator on SdkMeterProvider", e);
        }
    }

    public static SdkMeterProviderBuilder setMeterConfigurator(SdkMeterProviderBuilder sdkMeterProviderBuilder, ScopeConfigurator<MeterConfig> meterConfigurator) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("setMeterConfigurator", ScopeConfigurator.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, meterConfigurator);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setMeterConfigurator on SdkMeterProviderBuilder", e);
        }
        return sdkMeterProviderBuilder;
    }

    public static SdkMeterProviderBuilder addMeterConfiguratorCondition(SdkMeterProviderBuilder sdkMeterProviderBuilder, Predicate<InstrumentationScopeInfo> scopeMatcher, MeterConfig meterConfig) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("addMeterConfiguratorCondition", Predicate.class, MeterConfig.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, scopeMatcher, meterConfig);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling addMeterConfiguratorCondition on SdkMeterProviderBuilder", e);
        }
        return sdkMeterProviderBuilder;
    }

    public static void appendFilteredBaggageAttributes(ViewBuilder viewBuilder, Predicate<String> keyFilter) {
        SdkMeterProviderUtil.addAttributesProcessor(viewBuilder, AttributesProcessor.appendBaggageByKeyName(keyFilter));
    }

    public static void appendAllBaggageAttributes(ViewBuilder viewBuilder) {
        SdkMeterProviderUtil.appendFilteredBaggageAttributes(viewBuilder, StringPredicates.ALL);
    }

    private static void addAttributesProcessor(ViewBuilder viewBuilder, AttributesProcessor attributesProcessor) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod("addAttributesProcessor", AttributesProcessor.class);
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, attributesProcessor);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error adding AttributesProcessor to ViewBuilder", e);
        }
    }

    public static void resetForTest(SdkMeterProvider sdkMeterProvider) {
        try {
            Method method = SdkMeterProvider.class.getDeclaredMethod("resetForTest", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProvider, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling resetForTest on SdkMeterProvider", e);
        }
    }
}

