/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.keygen.DialectGeneratedKeyOption;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.exception.core.SQLExceptionTransformEngine;
import org.apache.shardingsphere.driver.executor.engine.batch.preparedstatement.DriverExecuteBatchExecutor;
import org.apache.shardingsphere.driver.executor.engine.facade.DriverExecutorFacade;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractPreparedStatementAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.driver.jdbc.core.statement.GeneratedValueUtils;
import org.apache.shardingsphere.driver.jdbc.core.statement.StatementManager;
import org.apache.shardingsphere.driver.jdbc.core.statement.metadata.ShardingSphereParameterMetaData;
import org.apache.shardingsphere.infra.binder.context.aware.ParameterAware;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.EmptySQLException;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.JDBCDriverType;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintUtils;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.resoure.StorageConnectorReusableRuleAttribute;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ShardingSpherePreparedStatement
extends AbstractPreparedStatementAdapter {
    private final ShardingSphereConnection connection;
    private final ShardingSphereMetaData metaData;
    private final String sql;
    private final HintValueContext hintValueContext;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingSphereDatabase usedDatabase;
    private final StatementOption statementOption;
    private final StatementManager statementManager;
    private final ParameterMetaData parameterMetaData;
    private final DriverExecutorFacade driverExecutorFacade;
    private final DriverExecuteBatchExecutor executeBatchExecutor;
    private final List<PreparedStatement> statements = new ArrayList<PreparedStatement>();
    private final List<List<Object>> parameterSets = new ArrayList<List<Object>>();
    private final Collection<Comparable<?>> generatedValues = new LinkedList();
    private final boolean statementsCacheable;
    private Map<String, Integer> columnLabelAndIndexMap;
    private ResultSet currentResultSet;
    private ResultSet currentBatchGeneratedKeysResultSet;
    private QueryContext queryContext;

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql) throws SQLException {
        this(connection, sql, 1003, 1007, 1, false, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, 1, false, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this(connection, sql, 1003, 1007, 1, 1 == autoGeneratedKeys, null);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, String[] columns) throws SQLException {
        this(connection, sql, 1003, 1007, 1, true, columns);
    }

    public ShardingSpherePreparedStatement(ShardingSphereConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false, null);
    }

    private ShardingSpherePreparedStatement(ShardingSphereConnection connection, String originSQL, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys, String[] columns) throws SQLException {
        ShardingSpherePreconditions.checkNotEmpty((String)originSQL, () -> new EmptySQLException().toSQLException());
        this.connection = connection;
        this.metaData = connection.getContextManager().getMetaDataContexts().getMetaData();
        this.sql = SQLHintUtils.removeHint((String)originSQL);
        this.hintValueContext = SQLHintUtils.extractHint((String)originSQL);
        ShardingSphereDatabase currentDatabase = this.metaData.getDatabase(connection.getCurrentDatabaseName());
        SQLStatement sqlStatement = ((SQLParserRule)this.metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class)).getSQLParserEngine(currentDatabase.getProtocolType()).parse(this.sql, true);
        this.sqlStatementContext = new SQLBindEngine(this.metaData, connection.getCurrentDatabaseName(), this.hintValueContext).bind(sqlStatement);
        String usedDatabaseName = this.sqlStatementContext.getTablesContext().getDatabaseName().orElse(connection.getCurrentDatabaseName());
        connection.getDatabaseConnectionManager().getConnectionContext().setCurrentDatabaseName(connection.getCurrentDatabaseName());
        this.usedDatabase = this.metaData.getDatabase(usedDatabaseName);
        this.statementOption = returnGeneratedKeys ? new StatementOption(true, columns) : new StatementOption(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statementManager = new StatementManager();
        connection.getStatementManagers().add(this.statementManager);
        this.parameterMetaData = new ShardingSphereParameterMetaData(sqlStatement);
        this.driverExecutorFacade = new DriverExecutorFacade(connection, this.statementOption, this.statementManager, JDBCDriverType.PREPARED_STATEMENT, currentDatabase);
        this.executeBatchExecutor = new DriverExecuteBatchExecutor(connection, this.metaData, this.statementOption, this.statementManager, this.usedDatabase);
        this.statementsCacheable = this.isStatementsCacheable();
    }

    private boolean isStatementsCacheable() {
        return this.usedDatabase.getRuleMetaData().getAttributes(StorageConnectorReusableRuleAttribute.class).size() == this.usedDatabase.getRuleMetaData().getRules().size() && !HintManager.isInstantiated();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            QueryContext queryContext;
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                ResultSet resultSet = this.statements.iterator().next().executeQuery();
                return resultSet;
            }
            this.clearPrevious();
            this.queryContext = queryContext = this.createQueryContext();
            this.handleAutoCommitBeforeExecution(queryContext.getSqlStatementContext().getSqlStatement(), this.connection);
            this.findGeneratedKey().ifPresent(optional -> this.generatedValues.addAll(optional.getGeneratedValues()));
            this.currentResultSet = this.driverExecutorFacade.executeQuery(this.usedDatabase, this.metaData, queryContext, this, this.columnLabelAndIndexMap, this::addStatements, this::replay);
            if (this.currentResultSet instanceof ShardingSphereResultSet) {
                this.columnLabelAndIndexMap = ((ShardingSphereResultSet)this.currentResultSet).getColumnLabelAndIndexMap();
            }
            ResultSet resultSet = this.currentResultSet;
            return resultSet;
        }
        catch (RuntimeException | SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.usedDatabase.getProtocolType());
        }
        finally {
            this.executeBatchExecutor.clear();
            this.clearParameters();
        }
    }

    private void addStatements(Collection<PreparedStatement> statements, Collection<List<Object>> parameterSets) {
        this.statements.addAll(statements);
        this.parameterSets.addAll(parameterSets);
    }

    private void resetParameters() throws SQLException {
        this.replaySetParameter(this.statements, Collections.singletonList(this.getParameters()));
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            QueryContext queryContext;
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                int n = this.statements.iterator().next().executeUpdate();
                return n;
            }
            this.clearPrevious();
            this.queryContext = queryContext = this.createQueryContext();
            this.handleAutoCommitBeforeExecution(queryContext.getSqlStatementContext().getSqlStatement(), this.connection);
            int result = this.driverExecutorFacade.executeUpdate(this.usedDatabase, this.metaData, queryContext, (sql, statement) -> ((PreparedStatement)statement).executeUpdate(), this::addStatements, this::replay);
            this.findGeneratedKey().ifPresent(optional -> this.generatedValues.addAll(optional.getGeneratedValues()));
            int n = result;
            return n;
        }
        catch (RuntimeException | SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.usedDatabase.getProtocolType());
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            QueryContext queryContext;
            if (this.statementsCacheable && !this.statements.isEmpty()) {
                this.resetParameters();
                boolean bl = this.statements.iterator().next().execute();
                return bl;
            }
            this.clearPrevious();
            this.queryContext = queryContext = this.createQueryContext();
            this.handleAutoCommitBeforeExecution(queryContext.getSqlStatementContext().getSqlStatement(), this.connection);
            boolean result = this.driverExecutorFacade.execute(this.usedDatabase, this.metaData, queryContext, (sql, statement) -> ((PreparedStatement)statement).execute(), this::addStatements, this::replay);
            this.findGeneratedKey().ifPresent(optional -> this.generatedValues.addAll(optional.getGeneratedValues()));
            boolean bl = result;
            return bl;
        }
        catch (RuntimeException | SQLException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.usedDatabase.getProtocolType());
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        this.driverExecutorFacade.getResultSet(this.usedDatabase, this.queryContext, this, this.statements).ifPresent(optional -> {
            this.currentResultSet = optional;
        });
        if (null == this.columnLabelAndIndexMap && this.currentResultSet instanceof ShardingSphereResultSet) {
            this.columnLabelAndIndexMap = ((ShardingSphereResultSet)this.currentResultSet).getColumnLabelAndIndexMap();
        }
        return this.currentResultSet;
    }

    private QueryContext createQueryContext() {
        ArrayList<Object> params = new ArrayList<Object>(this.getParameters());
        if (this.sqlStatementContext instanceof ParameterAware) {
            ((ParameterAware)this.sqlStatementContext).bindParameters(params);
        }
        return new QueryContext(this.sqlStatementContext, this.sql, params, this.hintValueContext, this.connection.getDatabaseConnectionManager().getConnectionContext(), this.metaData, true);
    }

    private void replay() throws SQLException {
        this.replaySetParameter(this.statements, this.parameterSets);
        for (Statement statement : this.statements) {
            this.getMethodInvocationRecorder().replay(statement);
        }
    }

    private void replaySetParameter(List<PreparedStatement> statements, List<List<Object>> parameterSets) throws SQLException {
        for (int i = 0; i < statements.size(); ++i) {
            this.replaySetParameter(statements.get(i), parameterSets.get(i));
        }
    }

    private void clearPrevious() {
        this.currentResultSet = null;
        this.statements.clear();
        this.parameterSets.clear();
        this.generatedValues.clear();
    }

    private Optional<GeneratedKeyContext> findGeneratedKey() {
        return this.sqlStatementContext instanceof InsertStatementContext ? ((InsertStatementContext)this.sqlStatementContext).getGeneratedKeyContext() : Optional.empty();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (null != this.currentBatchGeneratedKeysResultSet) {
            return this.currentBatchGeneratedKeysResultSet;
        }
        Optional<GeneratedKeyContext> generatedKey = this.findGeneratedKey();
        if (generatedKey.isPresent() && this.statementOption.isReturnGeneratedKeys() && !this.generatedValues.isEmpty()) {
            return new GeneratedKeysResultSet(this.getGeneratedKeysColumnName(generatedKey.get().getColumnName()), this.generatedValues.iterator(), this);
        }
        String columnName = generatedKey.map(GeneratedKeyContext::getColumnName).orElse(null);
        String generatedKeysColumnName = this.getGeneratedKeysColumnName(columnName);
        for (PreparedStatement each : this.statements) {
            ResultSet resultSet = each.getGeneratedKeys();
            while (resultSet.next()) {
                this.generatedValues.add(GeneratedValueUtils.getGeneratedValue(resultSet, generatedKeysColumnName, columnName));
            }
        }
        return new GeneratedKeysResultSet(generatedKeysColumnName, this.generatedValues.iterator(), this);
    }

    private String getGeneratedKeysColumnName(String columnName) {
        Optional generatedKeyOption = new DatabaseTypeRegistry(this.usedDatabase.getProtocolType()).getDialectDatabaseMetaData().getGeneratedKeyOption();
        return generatedKeyOption.isPresent() ? ((DialectGeneratedKeyOption)generatedKeyOption.get()).getColumnName() : columnName;
    }

    @Override
    public void addBatch() {
        QueryContext queryContext;
        this.currentResultSet = null;
        this.queryContext = queryContext = this.createQueryContext();
        this.executeBatchExecutor.addBatch(queryContext, this.usedDatabase);
        this.findGeneratedKey().ifPresent(optional -> this.generatedValues.addAll(optional.getGeneratedValues()));
        this.clearParameters();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] nArray = this.executeBatchExecutor.executeBatch(this.usedDatabase, this.sqlStatementContext, this.generatedValues, this.statementOption, (statements, parameterSets) -> this.statements.addAll(statements), (x$0, x$1) -> this.replaySetParameter(x$0, x$1), () -> {
                this.currentBatchGeneratedKeysResultSet = this.getGeneratedKeys();
                this.statements.clear();
            });
            return nArray;
        }
        catch (RuntimeException ex) {
            this.handleExceptionInTransaction(this.connection, this.metaData);
            throw SQLExceptionTransformEngine.toSQLException((Exception)ex, (DatabaseType)this.usedDatabase.getProtocolType());
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public void clearBatch() {
        this.currentResultSet = null;
        this.closeCurrentBatchGeneratedKeysResultSet();
        this.executeBatchExecutor.clear();
        this.clearParameters();
    }

    private void closeCurrentBatchGeneratedKeysResultSet() {
        if (null != this.currentBatchGeneratedKeysResultSet) {
            try {
                this.currentBatchGeneratedKeysResultSet.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.currentBatchGeneratedKeysResultSet = null;
            }
        }
    }

    @Override
    public int getResultSetType() {
        return this.statementOption.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementOption.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementOption.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        for (DataNodeRuleAttribute each : this.usedDatabase.getRuleMetaData().getAttributes(DataNodeRuleAttribute.class)) {
            if (!each.isNeedAccumulate(this.sqlStatementContext.getTablesContext().getTableNames())) continue;
            return true;
        }
        return false;
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.statements;
    }

    @Override
    protected void closeExecutor() throws SQLException {
        this.driverExecutorFacade.close();
    }

    @Override
    @Generated
    public ShardingSphereConnection getConnection() {
        return this.connection;
    }

    @Override
    @Generated
    protected StatementManager getStatementManager() {
        return this.statementManager;
    }

    @Override
    @Generated
    public ParameterMetaData getParameterMetaData() {
        return this.parameterMetaData;
    }
}

