/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.executors;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdBlobRegistry;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdGetBlobSegmentCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.blob.FirebirdGetBlobSegmentResponsePacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;

public final class FirebirdGetBlobSegmentCommandExecutor
implements CommandExecutor {
    private final FirebirdGetBlobSegmentCommandPacket packet;

    public Collection<DatabasePacket> execute() {
        byte[] payloadSegment;
        byte[] segment = FirebirdBlobRegistry.getSegment();
        int segmentLength = segment == null ? 0 : Math.min(this.packet.getSegmentLength(), segment.length);
        byte[] byArray = payloadSegment = segmentLength == 0 ? new byte[]{} : Arrays.copyOf(segment, segmentLength);
        if (segment != null && segmentLength > 0) {
            if (segmentLength >= segment.length) {
                FirebirdBlobRegistry.clearSegment();
            } else {
                FirebirdBlobRegistry.setSegment((byte[])Arrays.copyOfRange(segment, segmentLength, segment.length));
            }
        }
        FirebirdGetBlobSegmentResponsePacket responsePacket = new FirebirdGetBlobSegmentResponsePacket(payloadSegment);
        return Collections.singleton(new FirebirdGenericResponsePacket().setHandle(this.packet.getBlobHandle()).setData((FirebirdPacket)responsePacket));
    }

    @Generated
    public FirebirdGetBlobSegmentCommandExecutor(FirebirdGetBlobSegmentCommandPacket packet) {
        this.packet = packet;
    }
}

