/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.upload;

import java.io.ByteArrayOutputStream;
import java.util.Objects;
import lombok.Generated;

public final class FirebirdBlobUpload {
    private final int blobHandle;
    private final long blobId;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private boolean closed;

    public FirebirdBlobUpload(int blobHandle, long blobId) {
        this.blobHandle = blobHandle;
        this.blobId = blobId;
    }

    public void append(byte[] segment) {
        Objects.requireNonNull(segment, "BLOB segment must not be null");
        this.buffer.write(segment, 0, segment.length);
    }

    public int getSize() {
        return this.buffer.size();
    }

    public byte[] getBytes() {
        return this.buffer.toByteArray();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void markClosed() {
        this.closed = true;
    }

    @Generated
    public int getBlobHandle() {
        return this.blobHandle;
    }

    @Generated
    public long getBlobId() {
        return this.blobId;
    }

    @Generated
    public ByteArrayOutputStream getBuffer() {
        return this.buffer;
    }
}

