/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.prepare;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.database.connector.firebird.metadata.data.FirebirdNonFixedLengthColumnSizeRegistry;
import org.apache.shardingsphere.database.protocol.firebird.exception.FirebirdProtocolException;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.info.type.sql.FirebirdSQLInfoReturnValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare.FirebirdPrepareStatementPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare.FirebirdPrepareStatementReturnPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.prepare.FirebirdReturnColumnPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdGenericResponsePacket;
import org.apache.shardingsphere.database.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.binder.context.available.WhereContextAvailable;
import org.apache.shardingsphere.infra.binder.context.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.engine.ProjectionEngine;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ExpressionProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.SubqueryProjection;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.UpdateStatementContext;
import org.apache.shardingsphere.infra.binder.engine.SQLBindEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.session.ServerPreparedStatement;
import org.apache.shardingsphere.proxy.frontend.command.executor.CommandExecutor;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.FirebirdServerPreparedStatement;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.metadata.FirebirdBlobColumnMetaData;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.blob.metadata.FirebirdBlobColumnMetaDataResolver;
import org.apache.shardingsphere.proxy.frontend.firebird.command.query.statement.FirebirdStatementIdGenerator;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.ReturningSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.BeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class FirebirdPrepareStatementCommandExecutor
implements CommandExecutor {
    private final FirebirdPrepareStatementPacket packet;
    private final ConnectionSession connectionSession;
    private ReturningSegment returningSegment;

    public Collection<DatabasePacket> execute() {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLParserRule sqlParserRule = (SQLParserRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"Firebird");
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine(databaseType).parse(this.packet.getSQL(), true);
        SQLStatementContext sqlStatementContext = new SQLBindEngine(metaDataContexts.getMetaData(), this.connectionSession.getCurrentDatabaseName(), this.packet.getHintValueContext()).bind(sqlStatement);
        FirebirdServerPreparedStatement serverPreparedStatement = new FirebirdServerPreparedStatement(this.packet.getSQL(), sqlStatementContext, this.packet.getHintValueContext());
        this.connectionSession.getServerPreparedStatementRegistry().addPreparedStatement((Object)this.getStatementId(), (ServerPreparedStatement)serverPreparedStatement);
        return this.createResponse(sqlStatementContext, metaDataContexts);
    }

    private int getStatementId() {
        return this.packet.isValidStatementHandle() ? this.packet.getStatementId() : FirebirdStatementIdGenerator.getInstance().getStatementId(this.connectionSession.getConnectionId());
    }

    private Collection<DatabasePacket> createResponse(SQLStatementContext sqlStatementContext, MetaDataContexts metaDataContexts) {
        FirebirdSQLInfoReturnValue statementType = this.getFirebirdStatementType(sqlStatementContext.getSqlStatement());
        FirebirdPrepareStatementReturnPacket returnPacket = new FirebirdPrepareStatementReturnPacket();
        block5: while (this.packet.nextItem()) {
            switch (this.packet.getCurrentItem()) {
                case STMT_TYPE: {
                    returnPacket.setType(statementType);
                    continue block5;
                }
                case SELECT: {
                    if (statementType.isSelectDescribable()) {
                        this.processDescribe(sqlStatementContext, metaDataContexts, returnPacket.getDescribeSelect(), true);
                        continue block5;
                    }
                    this.skipDescribe();
                    continue block5;
                }
                case BIND: {
                    if (statementType.isBindDescribable()) {
                        this.processDescribe(sqlStatementContext, metaDataContexts, returnPacket.getDescribeBind(), false);
                        continue block5;
                    }
                    this.skipDescribe();
                    continue block5;
                }
            }
            throw new FirebirdProtocolException("Unknown statement info request type %d", new Object[]{this.packet.getCurrentItem()});
        }
        return Collections.singleton(new FirebirdGenericResponsePacket().setData((FirebirdPacket)returnPacket));
    }

    private FirebirdSQLInfoReturnValue getFirebirdStatementType(SQLStatement statement) {
        if (statement instanceof SelectStatement) {
            return FirebirdSQLInfoReturnValue.SELECT;
        }
        if (statement instanceof InsertStatement) {
            if (((InsertStatement)statement).getReturning().isPresent()) {
                this.returningSegment = ((InsertStatement)statement).getReturning().orElse(null);
                return FirebirdSQLInfoReturnValue.EXEC_PROCEDURE;
            }
            return FirebirdSQLInfoReturnValue.INSERT;
        }
        if (statement instanceof UpdateStatement) {
            if (((UpdateStatement)statement).getReturning().isPresent()) {
                this.returningSegment = ((UpdateStatement)statement).getReturning().orElse(null);
                return FirebirdSQLInfoReturnValue.EXEC_PROCEDURE;
            }
            return FirebirdSQLInfoReturnValue.UPDATE;
        }
        if (statement instanceof DeleteStatement) {
            if (((DeleteStatement)statement).getReturning().isPresent()) {
                this.returningSegment = ((DeleteStatement)statement).getReturning().orElse(null);
                return FirebirdSQLInfoReturnValue.EXEC_PROCEDURE;
            }
            return FirebirdSQLInfoReturnValue.DELETE;
        }
        if (statement instanceof DDLStatement) {
            return FirebirdSQLInfoReturnValue.DDL;
        }
        if (statement instanceof BeginTransactionStatement) {
            return FirebirdSQLInfoReturnValue.START_TRANS;
        }
        if (statement instanceof CommitStatement) {
            return FirebirdSQLInfoReturnValue.COMMIT;
        }
        if (statement instanceof RollbackStatement) {
            return FirebirdSQLInfoReturnValue.ROLLBACK;
        }
        if (statement instanceof SavepointStatement) {
            return FirebirdSQLInfoReturnValue.SAVEPOINT;
        }
        return null;
    }

    private void skipDescribe() {
        while (this.packet.getCurrentItem() != FirebirdSQLInfoPacketType.DESCRIBE_END) {
            this.packet.nextItem();
        }
    }

    private void processDescribe(SQLStatementContext sqlStatementContext, MetaDataContexts metaDataContexts, Collection<FirebirdReturnColumnPacket> describeColumns, boolean returnAll) {
        this.packet.nextItem();
        LinkedList<FirebirdSQLInfoPacketType> requestedItems = new LinkedList<FirebirdSQLInfoPacketType>();
        while (this.packet.nextItem()) {
            requestedItems.add(this.packet.getCurrentItem());
            if (this.packet.getCurrentItem() != FirebirdSQLInfoPacketType.DESCRIBE_END) continue;
            if (returnAll) {
                this.processReturnValues(sqlStatementContext, metaDataContexts, describeColumns, requestedItems);
            } else {
                this.processParameters(sqlStatementContext, metaDataContexts, describeColumns, requestedItems);
            }
            return;
        }
    }

    private void processReturnValues(SQLStatementContext sqlStatementContext, MetaDataContexts metaDataContexts, Collection<FirebirdReturnColumnPacket> describeColumns, Collection<FirebirdSQLInfoPacketType> requestedItems) {
        String databaseName = this.connectionSession.getCurrentDatabaseName();
        String schemaName = new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(databaseName);
        ShardingSphereSchema schema = metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName);
        Collection<Projection> projections = this.getProjections(sqlStatementContext, schema);
        int columnCount = 0;
        for (Projection each : projections) {
            if (each instanceof ColumnProjection) {
                String tableName = ((ColumnProjection)each).getOriginalTable().getValue();
                ShardingSphereTable table = schema.getTable(tableName.isEmpty() ? this.getTableNames(sqlStatementContext).iterator().next() : tableName);
                if (table == null) {
                    table = metaDataContexts.getMetaData().getDatabase(databaseName).getSchema("system_tables").getTable(tableName.isEmpty() ? this.getTableNames(sqlStatementContext).iterator().next() : tableName);
                }
                ShardingSphereColumn column = table.getColumn(((ColumnProjection)each).getOriginalColumn().getValue());
                this.processColumn(describeColumns, requestedItems, table, column, ((ColumnProjection)each).getOwner().orElse(null), each.getAlias().orElse(null), ++columnCount);
                continue;
            }
            if (each instanceof ExpressionProjection) {
                this.processExpressionProjection((ExpressionProjection)each, describeColumns, requestedItems, ++columnCount);
                continue;
            }
            if (each instanceof AggregationProjection) {
                String functionName = ((AggregationProjection)each).getType().name();
                this.processCustomColumn(null, functionName, each.getAlias().orElse(null), this.getFunctionType(functionName), describeColumns, requestedItems, ++columnCount);
                continue;
            }
            if (!(each instanceof SubqueryProjection)) continue;
            SubqueryProjection subquery = (SubqueryProjection)each;
            this.processCustomColumn(null, subquery.getColumnName(), subquery.getAlias().orElse(null), 4, describeColumns, requestedItems, ++columnCount);
        }
    }

    private Collection<Projection> getProjections(SQLStatementContext sqlStatementContext, ShardingSphereSchema schema) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            SelectStatementContext selectStatement = (SelectStatementContext)sqlStatementContext;
            List expandProjections = selectStatement.getProjectionsContext().getExpandProjections();
            Map subquery = selectStatement.getSubqueryContexts();
            if (subquery.isEmpty()) {
                return expandProjections;
            }
            TableSegment from = ((SelectStatement)sqlStatementContext.getSqlStatement()).getFrom().orElse(null);
            if (!(from instanceof SubqueryTableSegment)) {
                return expandProjections;
            }
            LinkedList<Projection> subqueryProjections = new LinkedList<Projection>();
            for (SelectStatementContext value : subquery.values()) {
                subqueryProjections.addAll(value.getProjectionsContext().getExpandProjections());
            }
            return subqueryProjections;
        }
        if (this.returningSegment == null) {
            return Collections.emptyList();
        }
        ProjectionEngine projectionEngine = new ProjectionEngine(sqlStatementContext.getSqlStatement().getDatabaseType());
        LinkedList<Projection> result = new LinkedList<Projection>();
        List projections = this.returningSegment.getProjections().getProjections();
        for (ProjectionSegment each : projections) {
            Projection projection = projectionEngine.createProjection(each).orElse(null);
            if (projection instanceof ShorthandProjection) {
                result.addAll(this.processShorthandProjection(sqlStatementContext, schema, (ShorthandProjection)projection));
                continue;
            }
            if (projection instanceof DerivedProjection || null == projection) continue;
            result.add(projection);
        }
        return result;
    }

    private Collection<Projection> processShorthandProjection(SQLStatementContext sqlStatementContext, ShardingSphereSchema schema, ShorthandProjection projection) {
        if (!projection.getActualColumns().isEmpty()) {
            return projection.getActualColumns();
        }
        LinkedList<Projection> result = new LinkedList<Projection>();
        TablesContext tablesContext = sqlStatementContext.getTablesContext();
        if (null != tablesContext) {
            for (String tableName : tablesContext.getTableNames()) {
                ShardingSphereTable table = schema.getTable(tableName);
                table.getAllColumns().forEach(each -> {
                    ColumnSegmentBoundInfo info = new ColumnSegmentBoundInfo(null, new IdentifierValue(table.getName()), new IdentifierValue(each.getName()), TableSourceType.PHYSICAL_TABLE);
                    result.add((Projection)new ColumnProjection(null, new IdentifierValue(each.getName()), null, sqlStatementContext.getSqlStatement().getDatabaseType(), null, null, info));
                });
            }
        }
        return result;
    }

    private void processParameters(SQLStatementContext sqlStatementContext, MetaDataContexts metaDataContexts, Collection<FirebirdReturnColumnPacket> describeColumns, Collection<FirebirdSQLInfoPacketType> requestedItems) {
        if (sqlStatementContext instanceof InsertStatementContext) {
            this.processInsertStatement((InsertStatementContext)sqlStatementContext, metaDataContexts, describeColumns, requestedItems);
            return;
        }
        Collection<ColumnSegment> affectedColumns = this.findAffectedColumns(sqlStatementContext);
        int parametersCount = sqlStatementContext.getSqlStatement().getParameterMarkers().size();
        String databaseName = this.connectionSession.getCurrentDatabaseName();
        String schemaName = new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(databaseName);
        int columnCount = 0;
        for (ColumnSegment columnSegment : affectedColumns) {
            ShardingSphereTable table = metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName).getTable(columnSegment.getColumnBoundInfo().getOriginalTable().getValue());
            ShardingSphereColumn column = table.getColumn(columnSegment.getColumnBoundInfo().getOriginalColumn().getValue());
            this.processColumn(describeColumns, requestedItems, table, column, columnSegment.getOwner().map(OwnerSegment::getIdentifier).orElse(null), columnSegment.getIdentifier(), ++columnCount);
        }
        for (int i = 0; i < parametersCount - affectedColumns.size(); ++i) {
            this.processCustomColumn(null, null, null, 12, describeColumns, requestedItems, ++columnCount);
        }
    }

    private void processInsertStatement(InsertStatementContext sqlStatementContext, MetaDataContexts metaDataContexts, Collection<FirebirdReturnColumnPacket> describeColumns, Collection<FirebirdSQLInfoPacketType> requestedItems) {
        Collection<String> tableNames = this.getTableNames((SQLStatementContext)sqlStatementContext);
        LinkedList<String> affectedColumns = new LinkedList<String>();
        for (InsertValueContext context : sqlStatementContext.getInsertValueContexts()) {
            affectedColumns.addAll(this.processInsertValueContext(sqlStatementContext, context));
        }
        String databaseName = this.connectionSession.getCurrentDatabaseName();
        String schemaName = new DatabaseTypeRegistry(sqlStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(databaseName);
        int columnCount = 0;
        for (String tableName : tableNames) {
            ShardingSphereTable table = metaDataContexts.getMetaData().getDatabase(databaseName).getSchema(schemaName).getTable(tableName);
            for (String columnName : affectedColumns) {
                ShardingSphereColumn column = table.getColumn(columnName);
                this.processColumn(describeColumns, requestedItems, table, column, null, null, ++columnCount);
            }
        }
    }

    private Collection<String> processInsertValueContext(InsertStatementContext context, InsertValueContext valueContext) {
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < valueContext.getValueExpressions().size(); ++i) {
            ExpressionSegment expression = (ExpressionSegment)valueContext.getValueExpressions().get(i);
            if (!(expression instanceof ParameterMarkerExpressionSegment)) continue;
            result.add((String)context.getColumnNames().get(i));
        }
        return result;
    }

    private Collection<String> getTableNames(SQLStatementContext sqlStatementContext) {
        TablesContext tablesContext = sqlStatementContext.getTablesContext();
        return null == tablesContext ? Collections.emptyList() : tablesContext.getTableNames();
    }

    private Collection<ColumnSegment> findAffectedColumns(SQLStatementContext sqlStatementContext) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        if (sqlStatementContext instanceof UpdateStatementContext) {
            for (ColumnAssignmentSegment segment : ((UpdateStatementContext)sqlStatementContext).getSqlStatement().getSetAssignment().getAssignments()) {
                if (!(segment.getValue() instanceof ParameterMarkerExpressionSegment)) continue;
                result.add((ColumnSegment)segment.getColumns().get(0));
            }
        }
        if (sqlStatementContext instanceof WhereContextAvailable) {
            Collection whereSegments = ((WhereContextAvailable)sqlStatementContext).getWhereSegments();
            for (WhereSegment each : whereSegments) {
                this.processExpr(each.getExpr(), result);
            }
        }
        return result;
    }

    private boolean processExpr(ExpressionSegment expr, Collection<ColumnSegment> affectedColumns) {
        if (!(expr instanceof BinaryOperationExpression)) {
            return expr instanceof ParameterMarkerExpressionSegment;
        }
        BinaryOperationExpression binary = (BinaryOperationExpression)expr;
        this.processExpr(binary.getLeft(), affectedColumns);
        boolean rightIsParam = this.processExpr(binary.getRight(), affectedColumns);
        if (rightIsParam && binary.getLeft() instanceof ColumnSegment) {
            affectedColumns.add((ColumnSegment)binary.getLeft());
        }
        return false;
    }

    private void processExpressionProjection(ExpressionProjection expr, Collection<FirebirdReturnColumnPacket> describeColumns, Collection<FirebirdSQLInfoPacketType> requestedItems, int columnCount) {
        ExpressionSegment exprSegment = expr.getExpressionSegment().getExpr();
        if (exprSegment instanceof FunctionSegment) {
            String functionName = ((FunctionSegment)exprSegment).getFunctionName();
            this.processCustomColumn(null, functionName, expr.getAlias().orElse(null), this.getFunctionType(functionName), describeColumns, requestedItems, columnCount);
        } else if (exprSegment instanceof BinaryOperationExpression) {
            String operationName = this.getOperationName(((BinaryOperationExpression)exprSegment).getOperator());
            int operationType = this.getOperationType(((BinaryOperationExpression)exprSegment).getOperator());
            this.processCustomColumn(null, operationName, expr.getAlias().orElse(null), operationType, describeColumns, requestedItems, columnCount);
        } else if (exprSegment instanceof LiteralExpressionSegment) {
            Object value = ((LiteralExpressionSegment)exprSegment).getLiterals();
            int type = 0;
            if (value instanceof String) {
                type = 12;
            } else if (value instanceof Integer) {
                type = 4;
            } else if (value instanceof Long) {
                type = -5;
            } else if (value instanceof Number) {
                type = 2;
            }
            this.processCustomColumn(null, null, expr.getAlias().orElse(null), type, describeColumns, requestedItems, columnCount);
        }
    }

    private int getFunctionType(String functionName) {
        switch (functionName.toLowerCase(Locale.ENGLISH)) {
            case "substring": 
            case "current_role": 
            case "current_user": 
            case "coalesce": {
                return 12;
            }
            case "gen_id": 
            case "count": {
                return -5;
            }
            case "current_timestamp": {
                return 93;
            }
        }
        return 4;
    }

    private String getOperationName(String operationType) {
        switch (operationType) {
            case "||": {
                return "CONCATENATION";
            }
        }
        return operationType;
    }

    private int getOperationType(String operationType) {
        switch (operationType) {
            case "||": {
                return 12;
            }
        }
        return 4;
    }

    private void processCustomColumn(String tableName, String columnName, IdentifierValue columnAlias, int dataType, Collection<FirebirdReturnColumnPacket> describeColumns, Collection<FirebirdSQLInfoPacketType> requestedItems, int columnCount) {
        ShardingSphereTable table = new ShardingSphereTable(tableName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        ShardingSphereColumn column = new ShardingSphereColumn(columnName, dataType, false, false, true, true, false, false);
        this.processColumn(describeColumns, requestedItems, table, column, null, columnAlias, columnCount);
    }

    private void processColumn(Collection<FirebirdReturnColumnPacket> describeColumns, Collection<FirebirdSQLInfoPacketType> requestedItems, ShardingSphereTable table, ShardingSphereColumn column, IdentifierValue tableAlias, IdentifierValue columnAlias, int idx) {
        String tableAliasString = null == tableAlias ? table.getName() : tableAlias.getValue();
        String columnAliasString = null == columnAlias ? column.getName() : columnAlias.getValue();
        String owner = this.connectionSession.getConnectionContext().getGrantee().getUsername();
        FirebirdBlobColumnMetaDataResolver blobResolver = new FirebirdBlobColumnMetaDataResolver(this.connectionSession.getCurrentDatabaseName());
        FirebirdBlobColumnMetaData blobMetaData = blobResolver.resolve(table, column);
        Integer columnLength = blobMetaData.isBlobColumn() ? null : this.resolveColumnLength(table, column);
        describeColumns.add(new FirebirdReturnColumnPacket(requestedItems, idx, table, column, tableAliasString, columnAliasString, owner, columnLength, blobMetaData.isBlobColumn(), blobMetaData.getBlobSubtype()));
    }

    private Integer resolveColumnLength(ShardingSphereTable table, ShardingSphereColumn column) {
        if (null == table || null == column || !this.isDynamicLengthType(column.getDataType())) {
            return null;
        }
        OptionalInt columnSize = FirebirdNonFixedLengthColumnSizeRegistry.findColumnSize((String)this.connectionSession.getCurrentDatabaseName(), (String)table.getName(), (String)column.getName());
        return columnSize.isPresent() ? Integer.valueOf(columnSize.getAsInt()) : null;
    }

    private boolean isDynamicLengthType(int dataType) {
        switch (dataType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Generated
    public FirebirdPrepareStatementCommandExecutor(FirebirdPrepareStatementPacket packet, ConnectionSession connectionSession) {
        this.packet = packet;
        this.connectionSession = connectionSession;
    }
}

