/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.postgresql.authentication;

import com.google.common.base.Strings;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Optional;
import org.apache.shardingsphere.authentication.Authenticator;
import org.apache.shardingsphere.authentication.AuthenticatorFactory;
import org.apache.shardingsphere.authentication.result.AuthenticationResult;
import org.apache.shardingsphere.authentication.result.AuthenticationResultBuilder;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.database.exception.postgresql.exception.authority.EmptyUsernameException;
import org.apache.shardingsphere.database.exception.postgresql.exception.authority.InvalidPasswordException;
import org.apache.shardingsphere.database.exception.postgresql.exception.authority.PrivilegeNotGrantedException;
import org.apache.shardingsphere.database.exception.postgresql.exception.authority.UnknownUsernameException;
import org.apache.shardingsphere.database.exception.postgresql.exception.protocol.ProtocolViolationException;
import org.apache.shardingsphere.database.protocol.constant.CommonConstants;
import org.apache.shardingsphere.database.protocol.constant.DatabaseProtocolServerInfo;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;
import org.apache.shardingsphere.database.protocol.postgresql.constant.PostgreSQLAuthenticationMethod;
import org.apache.shardingsphere.database.protocol.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.PostgreSQLAuthenticationOKPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.PostgreSQLComStartupPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.PostgreSQLParameterStatusPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.PostgreSQLPasswordMessagePacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.PostgreSQLRandomGenerator;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.PostgreSQLSSLUnwillingPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.PostgreSQLSSLWillingPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.authentication.PostgreSQLMD5PasswordAuthenticationPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.handshake.authentication.PostgreSQLPasswordAuthenticationPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.variable.charset.PostgreSQLCharacterSets;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.connection.ConnectionIdGenerator;
import org.apache.shardingsphere.proxy.frontend.postgresql.authentication.authenticator.PostgreSQLAuthenticatorType;
import org.apache.shardingsphere.proxy.frontend.ssl.ProxySSLContext;

public final class PostgreSQLAuthenticationEngine
implements AuthenticationEngine {
    private static final int SSL_REQUEST_PAYLOAD_LENGTH = 8;
    private static final int SSL_REQUEST_CODE = 80877103;
    private boolean startupMessageReceived;
    private String clientEncoding;
    private byte[] md5Salt;
    private AuthenticationResult currentAuthResult;

    public int handshake(ChannelHandlerContext context) {
        return ConnectionIdGenerator.getInstance().nextId();
    }

    public AuthenticationResult authenticate(ChannelHandlerContext context, PacketPayload payload) {
        if (8 == payload.getByteBuf().markReaderIndex().readInt() && 80877103 == payload.getByteBuf().readInt()) {
            if (ProxySSLContext.getInstance().isSSLEnabled()) {
                SslHandler sslHandler = new SslHandler(ProxySSLContext.getInstance().newSSLEngine(context.alloc()), true);
                context.pipeline().addFirst(SslHandler.class.getSimpleName(), (ChannelHandler)sslHandler);
                context.writeAndFlush((Object)new PostgreSQLSSLWillingPacket());
            } else {
                context.writeAndFlush((Object)new PostgreSQLSSLUnwillingPacket());
            }
            return AuthenticationResultBuilder.continued();
        }
        payload.getByteBuf().resetReaderIndex();
        AuthorityRule rule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        return this.startupMessageReceived ? this.processPasswordMessage(context, (PostgreSQLPacketPayload)payload, rule) : this.processStartupMessage(context, (PostgreSQLPacketPayload)payload, rule);
    }

    private AuthenticationResult processPasswordMessage(ChannelHandlerContext context, PostgreSQLPacketPayload payload, AuthorityRule rule) {
        char messageType = (char)payload.readInt1();
        ShardingSpherePreconditions.checkState((PostgreSQLMessagePacketType.PASSWORD_MESSAGE.getValue() == messageType ? 1 : 0) != 0, () -> new ProtocolViolationException("password", Character.toString(messageType)));
        PostgreSQLPasswordMessagePacket passwordMessagePacket = new PostgreSQLPasswordMessagePacket(payload);
        this.login(this.currentAuthResult.getDatabase(), this.currentAuthResult.getUsername(), this.md5Salt, passwordMessagePacket.getDigest(), rule);
        context.write((Object)new PostgreSQLAuthenticationOKPacket());
        context.write((Object)new PostgreSQLParameterStatusPacket("server_version", DatabaseProtocolServerInfo.getProtocolVersion((String)this.currentAuthResult.getDatabase(), (DatabaseType)((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"PostgreSQL")))));
        context.write((Object)new PostgreSQLParameterStatusPacket("client_encoding", this.clientEncoding));
        context.write((Object)new PostgreSQLParameterStatusPacket("server_encoding", "UTF8"));
        context.write((Object)new PostgreSQLParameterStatusPacket("integer_datetimes", "on"));
        context.write((Object)new PostgreSQLParameterStatusPacket("standard_conforming_strings", "on"));
        context.writeAndFlush((Object)PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION);
        return AuthenticationResultBuilder.finished((String)this.currentAuthResult.getUsername(), (String)"", (String)this.currentAuthResult.getDatabase());
    }

    private void login(String databaseName, String username, byte[] md5Salt, String digest, AuthorityRule rule) {
        ShardingSpherePreconditions.checkState((Strings.isNullOrEmpty((String)databaseName) || ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().containsDatabase(databaseName) ? 1 : 0) != 0, () -> new UnknownDatabaseException(databaseName));
        Grantee grantee = new Grantee(username);
        ShardingSphereUser user = (ShardingSphereUser)rule.findUser(grantee).orElseThrow(() -> new UnknownUsernameException(username));
        ShardingSpherePreconditions.checkState((boolean)new AuthenticatorFactory(PostgreSQLAuthenticatorType.class, rule).newInstance(user).authenticate(user, new Object[]{digest, md5Salt}), () -> new InvalidPasswordException(username));
        ShardingSpherePreconditions.checkState((null == databaseName || new AuthorityChecker(rule, grantee).isAuthorized(databaseName) ? 1 : 0) != 0, () -> new PrivilegeNotGrantedException(username, databaseName));
    }

    private AuthenticationResult processStartupMessage(ChannelHandlerContext context, PostgreSQLPacketPayload payload, AuthorityRule rule) {
        this.startupMessageReceived = true;
        PostgreSQLComStartupPacket startupPacket = new PostgreSQLComStartupPacket(payload);
        this.clientEncoding = startupPacket.getClientEncoding();
        context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)PostgreSQLCharacterSets.findCharacterSet((String)this.clientEncoding));
        String username = startupPacket.getUsername();
        ShardingSpherePreconditions.checkNotEmpty((String)username, EmptyUsernameException::new);
        context.writeAndFlush((Object)this.getIdentifierPacket(username, rule));
        this.currentAuthResult = AuthenticationResultBuilder.continued((String)username, (String)"", (String)startupPacket.getDatabase());
        return this.currentAuthResult;
    }

    private PostgreSQLIdentifierPacket getIdentifierPacket(String username, AuthorityRule rule) {
        Optional<Authenticator> authenticator = rule.findUser(new Grantee(username)).map(optional -> new AuthenticatorFactory(PostgreSQLAuthenticatorType.class, rule).newInstance(optional));
        if (authenticator.isPresent() && PostgreSQLAuthenticationMethod.PASSWORD.getMethodName().equals(authenticator.get().getAuthenticationMethodName())) {
            return new PostgreSQLPasswordAuthenticationPacket();
        }
        this.md5Salt = PostgreSQLRandomGenerator.getInstance().generateRandomBytes(4);
        return new PostgreSQLMD5PasswordAuthenticationPacket(this.md5Salt);
    }
}

