/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.parser.core;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.data.pipeline.distsql.statement.updatable.AlterTransmissionRuleStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.segment.MigrationSourceTargetSegment;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.queryable.ShowMigrationCheckStatusStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.queryable.ShowMigrationListStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.queryable.ShowMigrationRuleStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.queryable.ShowMigrationSourceStorageUnitsStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.queryable.ShowMigrationStatusStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.CheckMigrationStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.CommitMigrationStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.DropMigrationCheckStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.MigrateTableStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.RegisterMigrationSourceStorageUnitStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.RollbackMigrationStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.StartMigrationCheckStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.StartMigrationStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.StopMigrationCheckStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.StopMigrationStatement;
import org.apache.shardingsphere.data.pipeline.scenario.migration.distsql.statement.updatable.UnregisterMigrationSourceStorageUnitStatement;
import org.apache.shardingsphere.database.connector.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.distsql.parser.autogen.MigrationDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.MigrationDistSQLStatementParser;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.segment.ReadOrWriteSegment;
import org.apache.shardingsphere.distsql.segment.TransmissionRuleSegment;
import org.apache.shardingsphere.distsql.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.statement.type.ral.queryable.show.ShowPluginsStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class MigrationDistSQLStatementVisitor
extends MigrationDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitShowMigrationRule(MigrationDistSQLStatementParser.ShowMigrationRuleContext ctx) {
        return new ShowMigrationRuleStatement();
    }

    @Override
    public ASTNode visitAlterMigrationRule(MigrationDistSQLStatementParser.AlterMigrationRuleContext ctx) {
        return new AlterTransmissionRuleStatement("MIGRATION", (TransmissionRuleSegment)this.visit((ParseTree)ctx.transmissionRule()));
    }

    @Override
    public ASTNode visitTransmissionRule(MigrationDistSQLStatementParser.TransmissionRuleContext ctx) {
        TransmissionRuleSegment result = new TransmissionRuleSegment();
        if (null != ctx.readDefinition()) {
            result.setReadSegment((ReadOrWriteSegment)this.visit((ParseTree)ctx.readDefinition()));
        }
        if (null != ctx.writeDefinition()) {
            result.setWriteSegment((ReadOrWriteSegment)this.visit((ParseTree)ctx.writeDefinition()));
        }
        if (null != ctx.streamChannel()) {
            result.setStreamChannel((AlgorithmSegment)this.visit((ParseTree)ctx.streamChannel()));
        }
        return result;
    }

    @Override
    public ASTNode visitReadDefinition(MigrationDistSQLStatementParser.ReadDefinitionContext ctx) {
        return new ReadOrWriteSegment(this.getWorkerThread(ctx.workerThread()), this.getBatchSize(ctx.batchSize()), this.getShardingSize(ctx.shardingSize()), this.getAlgorithmSegment(ctx.rateLimiter()));
    }

    @Override
    public ASTNode visitWriteDefinition(MigrationDistSQLStatementParser.WriteDefinitionContext ctx) {
        return new ReadOrWriteSegment(this.getWorkerThread(ctx.workerThread()), this.getBatchSize(ctx.batchSize()), this.getAlgorithmSegment(ctx.rateLimiter()));
    }

    private AlgorithmSegment getAlgorithmSegment(MigrationDistSQLStatementParser.RateLimiterContext ctx) {
        return null == ctx ? null : (AlgorithmSegment)this.visit((ParseTree)ctx);
    }

    @Override
    public ASTNode visitRateLimiter(MigrationDistSQLStatementParser.RateLimiterContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    @Override
    public ASTNode visitStreamChannel(MigrationDistSQLStatementParser.StreamChannelContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.algorithmDefinition());
    }

    private Integer getWorkerThread(MigrationDistSQLStatementParser.WorkerThreadContext ctx) {
        return null == ctx ? null : Integer.valueOf(Integer.parseInt(ctx.intValue().getText()));
    }

    private Integer getBatchSize(MigrationDistSQLStatementParser.BatchSizeContext ctx) {
        return null == ctx ? null : Integer.valueOf(Integer.parseInt(ctx.intValue().getText()));
    }

    private Integer getShardingSize(MigrationDistSQLStatementParser.ShardingSizeContext ctx) {
        return null == ctx ? null : Integer.valueOf(Integer.parseInt(ctx.intValue().getText()));
    }

    @Override
    public ASTNode visitMigrateTable(MigrationDistSQLStatementParser.MigrateTableContext ctx) {
        String targetDatabaseName = this.getTargetDatabaseName(ctx.targetTableName());
        MigrationSourceTargetSegment migrationSourceTargetSegment = this.getMigrationSourceTargetSegment(ctx.sourceTableName(), ctx.targetTableName());
        return new MigrateTableStatement(targetDatabaseName, Collections.singleton(migrationSourceTargetSegment));
    }

    private String getTargetDatabaseName(MigrationDistSQLStatementParser.TargetTableNameContext targetContext) {
        List targetDatabaseNames = Splitter.on((char)'.').splitToList((CharSequence)this.getRequiredIdentifierValue((ParseTree)targetContext));
        return targetDatabaseNames.size() > 1 ? (String)targetDatabaseNames.get(0) : null;
    }

    private MigrationSourceTargetSegment getMigrationSourceTargetSegment(MigrationDistSQLStatementParser.SourceTableNameContext sourceContext, MigrationDistSQLStatementParser.TargetTableNameContext targetContext) {
        List source = Splitter.on((char)'.').splitToList((CharSequence)this.getRequiredIdentifierValue((ParseTree)sourceContext));
        List target = Splitter.on((char)'.').splitToList((CharSequence)this.getRequiredIdentifierValue((ParseTree)targetContext));
        String sourceDatabaseName = (String)source.get(0);
        String sourceSchemaName = 3 == source.size() ? (String)source.get(1) : null;
        String sourceTableName = (String)source.get(source.size() - 1);
        String targetTableName = (String)target.get(target.size() - 1);
        return new MigrationSourceTargetSegment(sourceDatabaseName, sourceSchemaName, sourceTableName, targetTableName);
    }

    private String getRequiredIdentifierValue(ParseTree context) {
        return new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitShowMigrationList(MigrationDistSQLStatementParser.ShowMigrationListContext ctx) {
        return new ShowMigrationListStatement();
    }

    @Override
    public ASTNode visitShowMigrationStatus(MigrationDistSQLStatementParser.ShowMigrationStatusContext ctx) {
        return new ShowMigrationStatusStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitStartMigration(MigrationDistSQLStatementParser.StartMigrationContext ctx) {
        return new StartMigrationStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitStopMigration(MigrationDistSQLStatementParser.StopMigrationContext ctx) {
        return new StopMigrationStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitRollbackMigration(MigrationDistSQLStatementParser.RollbackMigrationContext ctx) {
        return new RollbackMigrationStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitCommitMigration(MigrationDistSQLStatementParser.CommitMigrationContext ctx) {
        return new CommitMigrationStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitCheckMigration(MigrationDistSQLStatementParser.CheckMigrationContext ctx) {
        return new CheckMigrationStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()), null == ctx.algorithmDefinition() ? null : (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitShowMigrationCheckAlgorithms(MigrationDistSQLStatementParser.ShowMigrationCheckAlgorithmsContext ctx) {
        return new ShowPluginsStatement("MIGRATION_CHECK");
    }

    @Override
    public ASTNode visitAlgorithmDefinition(MigrationDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
    }

    private String getIdentifierValue(ParseTree context) {
        return new IdentifierValue(context.getText()).getValue();
    }

    @Override
    public ASTNode visitStorageUnitDefinition(MigrationDistSQLStatementParser.StorageUnitDefinitionContext ctx) {
        String user = this.getIdentifierValue((ParseTree)ctx.user());
        String password = null == ctx.password() ? "" : this.getPassword(ctx.password());
        Properties props = this.getProperties(ctx.propertiesDefinition());
        return null == ctx.urlSource() ? new HostnameAndPortBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), this.getIdentifierValue((ParseTree)ctx.simpleSource().hostname()), ctx.simpleSource().port().getText(), this.getIdentifierValue((ParseTree)ctx.simpleSource().dbName()), user, password, props) : new URLBasedDataSourceSegment(this.getIdentifierValue((ParseTree)ctx.storageUnitName()), this.getIdentifierValue((ParseTree)ctx.urlSource().url()), user, password, props);
    }

    private String getPassword(MigrationDistSQLStatementParser.PasswordContext ctx) {
        return this.getIdentifierValue((ParseTree)ctx);
    }

    private Properties getProperties(MigrationDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (MigrationDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(QuoteCharacter.unwrapAndTrimText((String)each.key.getText()), QuoteCharacter.unwrapAndTrimText((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitRegisterMigrationSourceStorageUnit(MigrationDistSQLStatementParser.RegisterMigrationSourceStorageUnitContext ctx) {
        LinkedList<DataSourceSegment> dataSources = new LinkedList<DataSourceSegment>();
        for (MigrationDistSQLStatementParser.StorageUnitDefinitionContext each : ctx.storageUnitDefinition()) {
            dataSources.add((DataSourceSegment)this.visit((ParseTree)each));
        }
        return new RegisterMigrationSourceStorageUnitStatement(dataSources);
    }

    @Override
    public ASTNode visitUnregisterMigrationSourceStorageUnit(MigrationDistSQLStatementParser.UnregisterMigrationSourceStorageUnitContext ctx) {
        return new UnregisterMigrationSourceStorageUnitStatement((Collection)ctx.storageUnitName().stream().map(ParseTree::getText).map(each -> new IdentifierValue(each).getValue()).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowMigrationSourceStorageUnits(MigrationDistSQLStatementParser.ShowMigrationSourceStorageUnitsContext ctx) {
        return new ShowMigrationSourceStorageUnitsStatement();
    }

    @Override
    public ASTNode visitShowMigrationCheckStatus(MigrationDistSQLStatementParser.ShowMigrationCheckStatusContext ctx) {
        return new ShowMigrationCheckStatusStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitStartMigrationCheck(MigrationDistSQLStatementParser.StartMigrationCheckContext ctx) {
        return new StartMigrationCheckStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitStopMigrationCheck(MigrationDistSQLStatementParser.StopMigrationCheckContext ctx) {
        return new StopMigrationCheckStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }

    @Override
    public ASTNode visitDropMigrationCheck(MigrationDistSQLStatementParser.DropMigrationCheckContext ctx) {
        return new DropMigrationCheckStatement(this.getRequiredIdentifierValue((ParseTree)ctx.jobId()));
    }
}

