/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;

final class UniversalConversions {
    private UniversalConversions() {
    }

    static String toString(Object from, Converter converter) {
        if (from == null) {
            return null;
        }
        return from.toString();
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("_v", from);
        return target;
    }

    static Map<String, Object> bigIntegerToMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("_v", ((BigInteger)from).toString(10));
        return target;
    }

    static Map<String, Object> bigDecimalToMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("_v", ((BigDecimal)from).toPlainString());
        return target;
    }

    static Map<String, Object> atomicBooleanToMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("_v", ((AtomicBoolean)from).get());
        return target;
    }

    static Map<String, Object> atomicIntegerToMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("_v", ((AtomicInteger)from).get());
        return target;
    }

    static Map<String, Object> atomicLongToMap(Object from, Converter converter) {
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("_v", ((AtomicLong)from).get());
        return target;
    }

    static String stringBuilderToString(Object from, Converter converter) {
        StringBuilder sb = (StringBuilder)from;
        return sb.toString();
    }

    static String stringBufferToString(Object from, Converter converter) {
        StringBuffer sb = (StringBuffer)from;
        return sb.toString();
    }

    static String charSequenceToString(Object from, Converter converter) {
        CharSequence cs = (CharSequence)from;
        return cs.toString();
    }

    static int atomicIntegerToInt(Object from, Converter converter) {
        AtomicInteger atomic = (AtomicInteger)from;
        return atomic.get();
    }

    static long atomicLongToLong(Object from, Converter converter) {
        AtomicLong atomic = (AtomicLong)from;
        return atomic.get();
    }

    static boolean atomicBooleanToBoolean(Object from, Converter converter) {
        AtomicBoolean atomic = (AtomicBoolean)from;
        return atomic.get();
    }

    static AtomicInteger integerToAtomicInteger(Object from, Converter converter) {
        Integer value = (Integer)from;
        return value == null ? null : new AtomicInteger(value);
    }

    static AtomicLong longToAtomicLong(Object from, Converter converter) {
        Long value = (Long)from;
        return value == null ? null : new AtomicLong(value);
    }

    static AtomicBoolean booleanToAtomicBoolean(Object from, Converter converter) {
        Boolean value = (Boolean)from;
        return value == null ? null : new AtomicBoolean(value);
    }

    static StringBuilder stringToStringBuilder(Object from, Converter converter) {
        String value = (String)from;
        return new StringBuilder(value);
    }

    static StringBuffer stringToStringBuffer(Object from, Converter converter) {
        String value = (String)from;
        return new StringBuffer(value);
    }

    static CharSequence stringToCharSequence(Object from, Converter converter) {
        String value = (String)from;
        return value;
    }

    static char[] characterArrayToCharArray(Object from, Converter converter) {
        Character[] chars = (Character[])from;
        char[] result = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = chars[i] != null ? chars[i].charValue() : (char)'\u0000';
        }
        return result;
    }

    static Character[] charArrayToCharacterArray(Object from, Converter converter) {
        char[] chars = (char[])from;
        Character[] result = new Character[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = Character.valueOf(chars[i]);
        }
        return result;
    }

    static Object primitiveToWrapper(Object from, Converter converter) {
        return from;
    }

    static Object wrapperToPrimitive(Object from, Converter converter) {
        return from;
    }

    static byte[] byteArrayToByteArray(Object from, Converter converter) {
        if (from instanceof Byte[]) {
            Byte[] array = (Byte[])from;
            byte[] result = new byte[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != null ? array[i] : (byte)0;
            }
            return result;
        }
        byte[] array = (byte[])from;
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static boolean[] booleanArrayToBooleanArray(Object from, Converter converter) {
        if (from instanceof Boolean[]) {
            Boolean[] array = (Boolean[])from;
            boolean[] result = new boolean[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != null ? array[i] : false;
            }
            return result;
        }
        boolean[] array = (boolean[])from;
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static short[] shortArrayToShortArray(Object from, Converter converter) {
        if (from instanceof Short[]) {
            Short[] array = (Short[])from;
            short[] result = new short[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != null ? array[i] : (short)0;
            }
            return result;
        }
        short[] array = (short[])from;
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static int[] integerArrayToIntArray(Object from, Converter converter) {
        if (from instanceof Integer[]) {
            Integer[] array = (Integer[])from;
            int[] result = new int[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != null ? array[i] : 0;
            }
            return result;
        }
        int[] array = (int[])from;
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static long[] longArrayToLongArray(Object from, Converter converter) {
        if (from instanceof Long[]) {
            Long[] array = (Long[])from;
            long[] result = new long[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != null ? array[i] : 0L;
            }
            return result;
        }
        long[] array = (long[])from;
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static float[] floatArrayToFloatArray(Object from, Converter converter) {
        if (from instanceof Float[]) {
            Float[] array = (Float[])from;
            float[] result = new float[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != null ? array[i].floatValue() : 0.0f;
            }
            return result;
        }
        float[] array = (float[])from;
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    static double[] doubleArrayToDoubleArray(Object from, Converter converter) {
        if (from instanceof Double[]) {
            Double[] array = (Double[])from;
            double[] result = new double[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = array[i] != null ? array[i] : 0.0;
            }
            return result;
        }
        double[] array = (double[])from;
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static Integer[] intArrayToIntegerArray(Object from, Converter converter) {
        int[] array = (int[])from;
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static Short[] shortArrayToShortArrayWrapper(Object from, Converter converter) {
        short[] array = (short[])from;
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static Boolean[] booleanArrayToBooleanArrayWrapper(Object from, Converter converter) {
        boolean[] array = (boolean[])from;
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static Long[] longArrayToLongArrayWrapper(Object from, Converter converter) {
        long[] array = (long[])from;
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static Float[] floatArrayToFloatArrayWrapper(Object from, Converter converter) {
        float[] array = (float[])from;
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    static Double[] doubleArrayToDoubleArrayWrapper(Object from, Converter converter) {
        double[] array = (double[])from;
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static int[] atomicIntegerArrayToIntArray(Object from, Converter converter) {
        AtomicIntegerArray atomicArray = (AtomicIntegerArray)from;
        int length = atomicArray.length();
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = atomicArray.get(i);
        }
        return result;
    }

    static AtomicIntegerArray intArrayToAtomicIntegerArray(Object from, Converter converter) {
        int[] array = (int[])from;
        AtomicIntegerArray result = new AtomicIntegerArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    static long[] atomicLongArrayToLongArray(Object from, Converter converter) {
        AtomicLongArray atomicArray = (AtomicLongArray)from;
        int length = atomicArray.length();
        long[] result = new long[length];
        for (int i = 0; i < length; ++i) {
            result[i] = atomicArray.get(i);
        }
        return result;
    }

    static AtomicLongArray longArrayToAtomicLongArray(Object from, Converter converter) {
        long[] array = (long[])from;
        AtomicLongArray result = new AtomicLongArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    static Object[] atomicReferenceArrayToObjectArray(Object from, Converter converter) {
        AtomicReferenceArray atomicArray = (AtomicReferenceArray)from;
        int length = atomicArray.length();
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = atomicArray.get(i);
        }
        return result;
    }

    static AtomicReferenceArray<Object> objectArrayToAtomicReferenceArray(Object from, Converter converter) {
        Object[] array = (Object[])from;
        AtomicReferenceArray<Object> result = new AtomicReferenceArray<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    static String[] atomicReferenceArrayToStringArray(Object from, Converter converter) {
        AtomicReferenceArray atomicArray = (AtomicReferenceArray)from;
        int length = atomicArray.length();
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            Object element = atomicArray.get(i);
            result[i] = element != null ? element.toString() : null;
        }
        return result;
    }

    static AtomicReferenceArray<String> stringArrayToAtomicReferenceArray(Object from, Converter converter) {
        String[] array = (String[])from;
        AtomicReferenceArray<String> result = new AtomicReferenceArray<String>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    static int[] intBufferToIntArray(Object from, Converter converter) {
        IntBuffer buffer = (IntBuffer)from;
        int[] result = new int[buffer.remaining()];
        buffer.mark();
        buffer.get(result);
        buffer.reset();
        return result;
    }

    static IntBuffer intArrayToIntBuffer(Object from, Converter converter) {
        int[] array = (int[])from;
        return IntBuffer.wrap(array);
    }

    static long[] longBufferToLongArray(Object from, Converter converter) {
        LongBuffer buffer = (LongBuffer)from;
        long[] result = new long[buffer.remaining()];
        buffer.mark();
        buffer.get(result);
        buffer.reset();
        return result;
    }

    static LongBuffer longArrayToLongBuffer(Object from, Converter converter) {
        long[] array = (long[])from;
        return LongBuffer.wrap(array);
    }

    static float[] floatBufferToFloatArray(Object from, Converter converter) {
        FloatBuffer buffer = (FloatBuffer)from;
        float[] result = new float[buffer.remaining()];
        buffer.mark();
        buffer.get(result);
        buffer.reset();
        return result;
    }

    static FloatBuffer floatArrayToFloatBuffer(Object from, Converter converter) {
        float[] array = (float[])from;
        return FloatBuffer.wrap(array);
    }

    static double[] doubleBufferToDoubleArray(Object from, Converter converter) {
        DoubleBuffer buffer = (DoubleBuffer)from;
        double[] result = new double[buffer.remaining()];
        buffer.mark();
        buffer.get(result);
        buffer.reset();
        return result;
    }

    static DoubleBuffer doubleArrayToDoubleBuffer(Object from, Converter converter) {
        double[] array = (double[])from;
        return DoubleBuffer.wrap(array);
    }

    static short[] shortBufferToShortArray(Object from, Converter converter) {
        ShortBuffer buffer = (ShortBuffer)from;
        short[] result = new short[buffer.remaining()];
        buffer.mark();
        buffer.get(result);
        buffer.reset();
        return result;
    }

    static ShortBuffer shortArrayToShortBuffer(Object from, Converter converter) {
        short[] array = (short[])from;
        return ShortBuffer.wrap(array);
    }

    static boolean[] bitSetToBooleanArray(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        boolean[] result = new boolean[bitSet.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bitSet.get(i);
        }
        return result;
    }

    static BitSet booleanArrayToBitSet(Object from, Converter converter) {
        boolean[] array = (boolean[])from;
        BitSet result = new BitSet(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    static int[] bitSetToIntArray(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        return bitSet.stream().toArray();
    }

    static BitSet intArrayToBitSet(Object from, Converter converter) {
        int[] array = (int[])from;
        BitSet result = new BitSet();
        for (int bitIndex : array) {
            result.set(bitIndex);
        }
        return result;
    }

    static byte[] bitSetToByteArray(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        return bitSet.toByteArray();
    }

    static BitSet byteArrayToBitSet(Object from, Converter converter) {
        byte[] array = (byte[])from;
        return BitSet.valueOf(array);
    }

    static long bitSetToLong(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        long[] longs = bitSet.toLongArray();
        return longs.length == 0 ? 0L : longs[0];
    }

    static BitSet longToBitSet(Object from, Converter converter) {
        long value = ((Number)from).longValue();
        return BitSet.valueOf(new long[]{value});
    }

    static BigInteger bitSetToBigInteger(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        byte[] bytes = bitSet.toByteArray();
        if (bytes.length == 0) {
            return BigInteger.ZERO;
        }
        byte[] reversed = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            reversed[i] = bytes[bytes.length - 1 - i];
        }
        return new BigInteger(1, reversed);
    }

    static BitSet bigIntegerToBitSet(Object from, Converter converter) {
        BigInteger value = (BigInteger)from;
        if (value.signum() < 0) {
            throw new IllegalArgumentException("Cannot convert negative BigInteger to BitSet");
        }
        if (value.equals(BigInteger.ZERO)) {
            return new BitSet();
        }
        byte[] bytes = value.toByteArray();
        int start = bytes[0] == 0 ? 1 : 0;
        byte[] reversed = new byte[bytes.length - start];
        for (int i = start; i < bytes.length; ++i) {
            reversed[bytes.length - 1 - i] = bytes[i];
        }
        return BitSet.valueOf(reversed);
    }

    static int bitSetToInt(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        long[] longs = bitSet.toLongArray();
        return longs.length == 0 ? 0 : (int)longs[0];
    }

    static BitSet intToBitSet(Object from, Converter converter) {
        int value = ((Number)from).intValue();
        return BitSet.valueOf(new long[]{(long)value & 0xFFFFFFFFL});
    }

    static short bitSetToShort(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        long[] longs = bitSet.toLongArray();
        return longs.length == 0 ? (short)0 : (short)longs[0];
    }

    static BitSet shortToBitSet(Object from, Converter converter) {
        short value = ((Number)from).shortValue();
        return BitSet.valueOf(new long[]{(long)value & 0xFFFFL});
    }

    static byte bitSetToByte(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        long[] longs = bitSet.toLongArray();
        return longs.length == 0 ? (byte)0 : (byte)longs[0];
    }

    static BitSet byteToBitSet(Object from, Converter converter) {
        byte value = ((Number)from).byteValue();
        return BitSet.valueOf(new long[]{(long)value & 0xFFL});
    }

    static AtomicInteger bitSetToAtomicInteger(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        long[] longs = bitSet.toLongArray();
        return new AtomicInteger(longs.length == 0 ? 0 : (int)longs[0]);
    }

    static BitSet atomicIntegerToBitSet(Object from, Converter converter) {
        int value = ((AtomicInteger)from).get();
        return BitSet.valueOf(new long[]{(long)value & 0xFFFFFFFFL});
    }

    static BigDecimal bitSetToBigDecimal(Object from, Converter converter) {
        BigInteger bigInt = UniversalConversions.bitSetToBigInteger(from, converter);
        return new BigDecimal(bigInt);
    }

    static BitSet bigDecimalToBitSet(Object from, Converter converter) {
        BigDecimal value = (BigDecimal)from;
        return UniversalConversions.bigIntegerToBitSet(value.toBigInteger(), converter);
    }

    static AtomicBoolean bitSetToAtomicBoolean(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        return new AtomicBoolean(!bitSet.isEmpty());
    }

    static BitSet atomicBooleanToBitSet(Object from, Converter converter) {
        AtomicBoolean value = (AtomicBoolean)from;
        BitSet bitSet = new BitSet();
        if (value.get()) {
            bitSet.set(0);
        }
        return bitSet;
    }

    static Boolean bitSetToBoolean(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        return !bitSet.isEmpty();
    }

    static BitSet booleanToBitSet(Object from, Converter converter) {
        Boolean value = (Boolean)from;
        BitSet bitSet = new BitSet();
        if (value.booleanValue()) {
            bitSet.set(0);
        }
        return bitSet;
    }

    static String bitSetToString(Object from, Converter converter) {
        BitSet bitSet = (BitSet)from;
        int length = bitSet.length();
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = length - 1; i >= 0; --i) {
            sb.append(bitSet.get(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }

    static BitSet stringToBitSet(Object from, Converter converter) {
        String binaryStr = ((String)from).trim();
        BitSet bitSet = new BitSet();
        int len = binaryStr.length();
        for (int i = 0; i < len; ++i) {
            char ch = binaryStr.charAt(i);
            if (ch != '1') continue;
            bitSet.set(len - 1 - i);
        }
        return bitSet;
    }

    static IntStream intArrayToIntStream(Object from, Converter converter) {
        int[] array = (int[])from;
        return IntStream.of(array);
    }

    static LongStream longArrayToLongStream(Object from, Converter converter) {
        long[] array = (long[])from;
        return LongStream.of(array);
    }

    static DoubleStream doubleArrayToDoubleStream(Object from, Converter converter) {
        double[] array = (double[])from;
        return DoubleStream.of(array);
    }
}

