/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.checker.config;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.encrypt.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.exception.metadata.MissingRequiredEncryptColumnException;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.config.rule.checker.DatabaseRuleConfigurationChecker;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class EncryptRuleConfigurationChecker
implements DatabaseRuleConfigurationChecker<EncryptRuleConfiguration> {
    public void check(String databaseName, EncryptRuleConfiguration ruleConfig, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        this.checkEncryptors(ruleConfig.getEncryptors());
        this.checkTables(databaseName, ruleConfig.getTables(), ruleConfig.getEncryptors());
    }

    private void checkEncryptors(Map<String, AlgorithmConfiguration> encryptors) {
        encryptors.values().forEach(each -> TypedSPILoader.checkService(EncryptAlgorithm.class, (Object)each.getType(), (Properties)each.getProps()));
    }

    private void checkTables(String databaseName, Collection<EncryptTableRuleConfiguration> tableRuleConfigs, Map<String, AlgorithmConfiguration> encryptors) {
        tableRuleConfigs.forEach(each -> this.checkColumns(databaseName, (EncryptTableRuleConfiguration)each, encryptors));
    }

    private void checkColumns(String databaseName, EncryptTableRuleConfiguration tableRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        tableRuleConfig.getColumns().forEach(each -> this.checkColumn(databaseName, tableRuleConfig.getName(), (EncryptColumnRuleConfiguration)each, encryptors));
    }

    private void checkColumn(String databaseName, String tableName, EncryptColumnRuleConfiguration columnRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        this.checkEncryptColumnItem(databaseName, tableName, columnRuleConfig.getName(), columnRuleConfig.getCipher(), encryptors, "Cipher");
        columnRuleConfig.getAssistedQuery().ifPresent(optional -> this.checkEncryptColumnItem(databaseName, tableName, columnRuleConfig.getName(), (EncryptColumnItemRuleConfiguration)optional, encryptors, "Assist Query"));
        columnRuleConfig.getLikeQuery().ifPresent(optional -> this.checkEncryptColumnItem(databaseName, tableName, columnRuleConfig.getName(), (EncryptColumnItemRuleConfiguration)optional, encryptors, "Like Query"));
    }

    private void checkEncryptColumnItem(String databaseName, String tableName, String logicColumnName, EncryptColumnItemRuleConfiguration columnItem, Map<String, AlgorithmConfiguration> encryptors, String itemType) {
        ShardingSpherePreconditions.checkNotEmpty((String)columnItem.getName(), () -> new MissingRequiredEncryptColumnException(itemType, new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
        ShardingSpherePreconditions.checkNotEmpty((String)columnItem.getEncryptorName(), () -> new MissingRequiredAlgorithmException(itemType + " encrypt", new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
        ShardingSpherePreconditions.checkContainsKey(encryptors, (Object)columnItem.getEncryptorName(), () -> new UnregisteredAlgorithmException(itemType + " encrypt", columnItem.getEncryptorName(), new SQLExceptionIdentifier(databaseName, tableName, logicColumnName)));
    }

    public Collection<String> getTableNames(EncryptRuleConfiguration ruleConfig) {
        return ruleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toList());
    }

    public int getOrder() {
        return 10;
    }

    public Class<EncryptRuleConfiguration> getTypeClass() {
        return EncryptRuleConfiguration.class;
    }
}

