/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dql;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.encrypt.exception.data.DecryptFailedException;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.decorator.DecoratorMergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;

public final class EncryptMergedResult
extends DecoratorMergedResult {
    private final ShardingSphereDatabase database;
    private final ShardingSphereMetaData metaData;
    private final SelectStatementContext selectStatementContext;

    public EncryptMergedResult(ShardingSphereDatabase database, ShardingSphereMetaData metaData, SelectStatementContext selectStatementContext, MergedResult mergedResult) {
        super(mergedResult);
        this.database = database;
        this.metaData = metaData;
        this.selectStatementContext = selectStatementContext;
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Optional columnSegmentBoundInfo = this.selectStatementContext.findColumnBoundInfo(columnIndex);
        if (!columnSegmentBoundInfo.isPresent()) {
            return this.getMergedResult().getValue(columnIndex, type);
        }
        String originalTableName = ((ColumnSegmentBoundInfo)columnSegmentBoundInfo.get()).getOriginalTable().getValue();
        String originalColumnName = ((ColumnSegmentBoundInfo)columnSegmentBoundInfo.get()).getOriginalColumn().getValue();
        ShardingSphereDatabase database = this.metaData.containsDatabase(((ColumnSegmentBoundInfo)columnSegmentBoundInfo.get()).getOriginalDatabase().getValue()) ? this.metaData.getDatabase(((ColumnSegmentBoundInfo)columnSegmentBoundInfo.get()).getOriginalDatabase().getValue()) : this.database;
        Optional rule = database.getRuleMetaData().findSingleRule(EncryptRule.class);
        if (!rule.isPresent() || !((EncryptRule)rule.get()).findEncryptTable(originalTableName).map(optional -> optional.isEncryptColumn(originalColumnName)).orElse(false).booleanValue()) {
            return this.getMergedResult().getValue(columnIndex, type);
        }
        Object cipherValue = this.getMergedResult().getValue(columnIndex, Object.class);
        EncryptColumn encryptColumn = ((EncryptRule)rule.get()).getEncryptTable(originalTableName).getEncryptColumn(originalColumnName);
        String schemaName = this.selectStatementContext.getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(this.selectStatementContext.getSqlStatement().getDatabaseType()).getDefaultSchemaName(database.getName()));
        try {
            return encryptColumn.getCipher().decrypt(database.getName(), schemaName, originalTableName, originalColumnName, cipherValue);
        }
        catch (Exception ex) {
            throw new DecryptFailedException(String.valueOf(cipherValue), new SQLExceptionIdentifier(database.getName(), originalTableName, originalColumnName), ex);
        }
    }
}

