/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.database.type;

import lombok.Generated;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.DatabaseCreateExistsException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;

public final class CreateDatabaseProxyBackendHandler
implements ProxyBackendHandler {
    private final CreateDatabaseStatement sqlStatement;
    private final ContextManager contextManager;

    @Override
    public ResponseHeader execute() {
        ShardingSpherePreconditions.checkState((this.sqlStatement.isIfNotExists() || !this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(this.sqlStatement.getDatabaseName()) ? 1 : 0) != 0, () -> new DatabaseCreateExistsException(this.sqlStatement.getDatabaseName()));
        this.contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService().createDatabase(this.sqlStatement.getDatabaseName());
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    @Generated
    public CreateDatabaseProxyBackendHandler(CreateDatabaseStatement sqlStatement, ContextManager contextManager) {
        this.sqlStatement = sqlStatement;
        this.contextManager = contextManager;
    }
}

