/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecuteEngine;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class DistSQLQueryProxyBackendHandler
implements DistSQLProxyBackendHandler {
    private final DistSQLQueryExecuteEngine engine;
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;

    public DistSQLQueryProxyBackendHandler(DistSQLStatement sqlStatement, QueryContext queryContext, ConnectionSession connectionSession, ContextManager contextManager) {
        DistSQLConnectionContext distsqlConnectionContext = new DistSQLConnectionContext(queryContext, connectionSession.getDatabaseConnectionManager().getConnectionSize(), connectionSession.getProtocolType(), (DatabaseConnectionManager)connectionSession.getDatabaseConnectionManager(), connectionSession.getStatementManager());
        this.engine = new DistSQLQueryExecuteEngine(sqlStatement, connectionSession.getUsedDatabaseName(), contextManager, distsqlConnectionContext);
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        this.engine.executeQuery();
        this.queryHeaders = this.createQueryHeader(this.engine.getColumnNames());
        this.mergedResult = new LocalDataMergedResult(this.engine.getRows());
        return new QueryResponseHeader(this.queryHeaders);
    }

    private List<QueryHeader> createQueryHeader(Collection<String> columnNames) {
        return columnNames.stream().map(each -> new QueryHeader("", "", (String)each, (String)each, 1, "CHAR", 255, 0, false, false, false, false)).collect(Collectors.toList());
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(this.queryHeaders.size());
        for (int i = 0; i < this.queryHeaders.size(); ++i) {
            cells.add(new QueryResponseCell(this.queryHeaders.get(i).getColumnType(), this.mergedResult.getValue(i + 1, Object.class)));
        }
        return new QueryResponseRow(cells);
    }
}

