/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable.variable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorConnectionContextAware;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.type.ral.queryable.show.ShowDistVariableStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.UnsupportedVariableException;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.DistSQLVariable;

public final class ShowDistVariableExecutor
implements DistSQLQueryExecutor<ShowDistVariableStatement>,
DistSQLExecutorConnectionContextAware {
    private DistSQLConnectionContext connectionContext;

    public Collection<String> getColumnNames(ShowDistVariableStatement sqlStatement) {
        return Arrays.asList("variable_name", "variable_value");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowDistVariableStatement sqlStatement, ContextManager contextManager) {
        ShardingSphereMetaData metaData = contextManager.getMetaDataContexts().getMetaData();
        String variableName = sqlStatement.getName();
        if (this.isConfigurationKey(variableName)) {
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{variableName.toLowerCase(), this.getConfigurationValue(metaData, variableName)}));
        }
        if (this.isTemporaryConfigurationKey(variableName)) {
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{variableName.toLowerCase(), this.getTemporaryConfigurationValue(metaData, variableName)}));
        }
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{variableName.toLowerCase(), this.getConnectionSize(variableName)}));
    }

    private boolean isConfigurationKey(String variableName) {
        return ConfigurationPropertyKey.getKeyNames().contains(variableName);
    }

    private String getConfigurationValue(ShardingSphereMetaData metaData, String variableName) {
        return this.getStringResult(metaData.getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)variableName)));
    }

    private boolean isTemporaryConfigurationKey(String variableName) {
        return TemporaryConfigurationPropertyKey.getKeyNames().contains(variableName);
    }

    private String getTemporaryConfigurationValue(ShardingSphereMetaData metaData, String variableName) {
        return this.getStringResult(metaData.getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.valueOf((String)variableName)));
    }

    private String getConnectionSize(String variableName) {
        this.checkVariableName(variableName);
        return String.valueOf(this.connectionContext.getConnectionSize());
    }

    private void checkVariableName(String variableName) {
        DistSQLVariable distSQLVariable;
        try {
            distSQLVariable = DistSQLVariable.valueOf(variableName.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            throw new UnsupportedVariableException(variableName);
        }
        ShardingSpherePreconditions.checkState((DistSQLVariable.CACHED_CONNECTIONS == distSQLVariable ? 1 : 0) != 0, () -> new UnsupportedVariableException(variableName));
    }

    private String getStringResult(Object value) {
        if (null == value) {
            return "";
        }
        return value instanceof TypedSPI ? ((TypedSPI)value).getType().toString() : value.toString();
    }

    public Class<ShowDistVariableStatement> getType() {
        return ShowDistVariableStatement.class;
    }

    @Generated
    public void setConnectionContext(DistSQLConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

