/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.rul;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorConnectionContextAware;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.type.rul.sql.ParseStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ParseDistSQLExecutor
implements DistSQLQueryExecutor<ParseStatement>,
DistSQLExecutorConnectionContextAware {
    private DistSQLConnectionContext connectionContext;

    public Collection<String> getColumnNames(ParseStatement sqlStatement) {
        return Arrays.asList("parsed_statement", "parsed_statement_detail");
    }

    public Collection<LocalDataQueryResultRow> getRows(ParseStatement sqlStatement, ContextManager contextManager) {
        SQLStatement parsedSqlStatement = this.parseSQL(contextManager.getMetaDataContexts().getMetaData(), sqlStatement);
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{parsedSqlStatement.getClass().getSimpleName(), JsonUtils.toJsonString((Object)parsedSqlStatement)}));
    }

    private SQLStatement parseSQL(ShardingSphereMetaData metaData, ParseStatement sqlStatement) {
        SQLParserRule sqlParserRule = (SQLParserRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        return sqlParserRule.getSQLParserEngine(this.connectionContext.getProtocolType()).parse(sqlStatement.getSql(), false);
    }

    public Class<ParseStatement> getType() {
        return ParseStatement.class;
    }

    @Generated
    public void setConnectionContext(DistSQLConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

