/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing.rdb.storage.repository;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.kernel.tracing.exception.TracingStorageUnavailableException;
import org.apache.shardingsphere.elasticjob.spi.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.spi.tracing.event.JobStatusTraceEvent;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.sql.RDBStorageSQLMapper;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.sql.SQLPropertiesFactory;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.type.TracingStorageDatabaseType;
import org.apache.shardingsphere.elasticjob.tracing.rdb.storage.type.impl.DefaultTracingStorageDatabaseType;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDBJobEventRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RDBJobEventRepository.class);
    private static final String TABLE_JOB_EXECUTION_LOG = "JOB_EXECUTION_LOG";
    private static final String TABLE_JOB_STATUS_TRACE_LOG = "JOB_STATUS_TRACE_LOG";
    private static final String TASK_ID_STATE_INDEX = "TASK_ID_STATE_INDEX";
    private static final Map<DataSource, RDBJobEventRepository> STORAGE_MAP = new ConcurrentHashMap<DataSource, RDBJobEventRepository>();
    private final DataSource dataSource;
    private final TracingStorageDatabaseType tracingStorageDatabaseType;
    private final RDBStorageSQLMapper sqlMapper;

    private RDBJobEventRepository(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        this.tracingStorageDatabaseType = this.getTracingStorageDatabaseType(dataSource);
        this.sqlMapper = new RDBStorageSQLMapper(SQLPropertiesFactory.getProperties(this.tracingStorageDatabaseType));
        this.initTablesAndIndexes();
    }

    public static RDBJobEventRepository getInstance(DataSource dataSource) throws SQLException {
        return RDBJobEventRepository.getInstance(() -> STORAGE_MAP.computeIfAbsent(dataSource, ds -> {
            try {
                return new RDBJobEventRepository((DataSource)ds);
            }
            catch (SQLException ex) {
                throw new TracingStorageUnavailableException((Throwable)ex);
            }
        }));
    }

    private static RDBJobEventRepository getInstance(Supplier<RDBJobEventRepository> supplier) throws SQLException {
        try {
            return supplier.get();
        }
        catch (TracingStorageUnavailableException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw new SQLException(ex.getCause());
            }
            throw ex;
        }
    }

    private TracingStorageDatabaseType getTracingStorageDatabaseType(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            String databaseProductName = connection.getMetaData().getDatabaseProductName();
            for (TracingStorageDatabaseType each : ShardingSphereServiceLoader.getServiceInstances(TracingStorageDatabaseType.class)) {
                if (!each.getDatabaseProductName().equals(databaseProductName)) continue;
                TracingStorageDatabaseType tracingStorageDatabaseType = each;
                return tracingStorageDatabaseType;
            }
        }
        return new DefaultTracingStorageDatabaseType();
    }

    private void initTablesAndIndexes() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            this.createJobExecutionTableAndIndexIfNeeded(connection);
            this.createJobStatusTraceTableAndIndexIfNeeded(connection);
        }
    }

    private void createJobExecutionTableAndIndexIfNeeded(Connection connection) throws SQLException {
        if (this.existsTable(connection, TABLE_JOB_EXECUTION_LOG) || this.existsTable(connection, TABLE_JOB_EXECUTION_LOG.toLowerCase())) {
            return;
        }
        this.createJobExecutionTable(connection);
    }

    private void createJobStatusTraceTableAndIndexIfNeeded(Connection connection) throws SQLException {
        if (this.existsTable(connection, TABLE_JOB_STATUS_TRACE_LOG) || this.existsTable(connection, TABLE_JOB_STATUS_TRACE_LOG.toLowerCase())) {
            return;
        }
        this.createJobStatusTraceTable(connection);
        this.createTaskIdIndexIfNeeded(connection);
    }

    private boolean existsTable(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        try (ResultSet resultSet = dbMetaData.getTables(connection.getCatalog(), null, tableName, new String[]{"TABLE"});){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private void createTaskIdIndexIfNeeded(Connection connection) throws SQLException {
        if (this.existsIndex(connection, TABLE_JOB_STATUS_TRACE_LOG, TASK_ID_STATE_INDEX) || this.existsIndex(connection, TABLE_JOB_STATUS_TRACE_LOG.toLowerCase(), TASK_ID_STATE_INDEX.toLowerCase())) {
            return;
        }
        this.createTaskIdAndStateIndex(connection);
    }

    private boolean existsIndex(Connection connection, String tableName, String indexName) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        try (ResultSet resultSet = dbMetaData.getIndexInfo(connection.getCatalog(), null, tableName, false, false);){
            while (resultSet.next()) {
                if (!indexName.equals(resultSet.getString("INDEX_NAME"))) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void createJobExecutionTable(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getCreateTableForJobExecutionLog());){
            preparedStatement.execute();
        }
    }

    private void createJobStatusTraceTable(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getCreateTableForJobStatusTraceLog());){
            preparedStatement.execute();
        }
    }

    private void createTaskIdAndStateIndex(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getCreateIndexForTaskIdStateIndex());){
            preparedStatement.execute();
        }
    }

    public boolean addJobExecutionEvent(JobExecutionEvent event) {
        if (null == event.getCompleteTime()) {
            return this.insertJobExecutionEvent(event);
        }
        if (event.isSuccess()) {
            return this.updateJobExecutionEventWhenSuccess(event);
        }
        return this.updateJobExecutionEventFailure(event);
    }

    private boolean insertJobExecutionEvent(JobExecutionEvent event) {
        boolean result;
        block14: {
            result = false;
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getInsertForJobExecutionLog());){
                preparedStatement.setString(1, event.getId());
                preparedStatement.setString(2, event.getJobName());
                preparedStatement.setString(3, event.getTaskId());
                preparedStatement.setString(4, event.getHostname());
                preparedStatement.setString(5, event.getIp());
                preparedStatement.setInt(6, event.getShardingItem());
                preparedStatement.setString(7, event.getSource().toString());
                preparedStatement.setBoolean(8, event.isSuccess());
                preparedStatement.setTimestamp(9, new Timestamp(event.getStartTime().getTime()));
                preparedStatement.execute();
                result = true;
            }
            catch (SQLException ex) {
                if (this.isDuplicateRecord(ex)) break block14;
                log.error(ex.getMessage());
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateJobExecutionEventWhenSuccess(JobExecutionEvent event) {
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getUpdateForJobExecutionLog());){
            preparedStatement.setBoolean(1, event.isSuccess());
            preparedStatement.setTimestamp(2, new Timestamp(event.getCompleteTime().getTime()));
            preparedStatement.setString(3, event.getId());
            if (0 == preparedStatement.executeUpdate()) {
                boolean bl = this.insertJobExecutionEventWhenSuccess(event);
                return bl;
            }
            result = true;
            return result;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    private boolean insertJobExecutionEventWhenSuccess(JobExecutionEvent event) {
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getInsertForJobExecutionLogForComplete());){
            preparedStatement.setString(1, event.getId());
            preparedStatement.setString(2, event.getJobName());
            preparedStatement.setString(3, event.getTaskId());
            preparedStatement.setString(4, event.getHostname());
            preparedStatement.setString(5, event.getIp());
            preparedStatement.setInt(6, event.getShardingItem());
            preparedStatement.setString(7, event.getSource().toString());
            preparedStatement.setBoolean(8, event.isSuccess());
            preparedStatement.setTimestamp(9, new Timestamp(event.getStartTime().getTime()));
            preparedStatement.setTimestamp(10, new Timestamp(event.getCompleteTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            if (this.isDuplicateRecord(ex)) {
                return this.updateJobExecutionEventWhenSuccess(event);
            }
            log.error(ex.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateJobExecutionEventFailure(JobExecutionEvent event) {
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getUpdateForJobExecutionLogForFailure());){
            preparedStatement.setBoolean(1, event.isSuccess());
            preparedStatement.setTimestamp(2, new Timestamp(event.getCompleteTime().getTime()));
            preparedStatement.setString(3, this.truncateString(event.getFailureCause()));
            preparedStatement.setString(4, event.getId());
            if (0 == preparedStatement.executeUpdate()) {
                boolean bl = this.insertJobExecutionEventWhenFailure(event);
                return bl;
            }
            result = true;
            return result;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    private boolean insertJobExecutionEventWhenFailure(JobExecutionEvent event) {
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getInsertForJobExecutionLogForFailure());){
            preparedStatement.setString(1, event.getId());
            preparedStatement.setString(2, event.getJobName());
            preparedStatement.setString(3, event.getTaskId());
            preparedStatement.setString(4, event.getHostname());
            preparedStatement.setString(5, event.getIp());
            preparedStatement.setInt(6, event.getShardingItem());
            preparedStatement.setString(7, event.getSource().toString());
            preparedStatement.setString(8, this.truncateString(event.getFailureCause()));
            preparedStatement.setBoolean(9, event.isSuccess());
            preparedStatement.setTimestamp(10, new Timestamp(event.getStartTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            if (this.isDuplicateRecord(ex)) {
                return this.updateJobExecutionEventFailure(event);
            }
            log.error(ex.getMessage());
        }
        return result;
    }

    private boolean isDuplicateRecord(SQLException ex) {
        return null != this.tracingStorageDatabaseType && this.tracingStorageDatabaseType.getDuplicateRecordErrorCode() == ex.getErrorCode();
    }

    public boolean addJobStatusTraceEvent(JobStatusTraceEvent event) {
        String originalTaskId = event.getOriginalTaskId();
        if (JobStatusTraceEvent.State.TASK_STAGING != event.getState()) {
            originalTaskId = this.getOriginalTaskId(event.getTaskId());
        }
        boolean result = false;
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getInsertForJobStatusTraceLog());){
            preparedStatement.setString(1, UUID.randomUUID().toString());
            preparedStatement.setString(2, event.getJobName());
            preparedStatement.setString(3, originalTaskId);
            preparedStatement.setString(4, event.getTaskId());
            preparedStatement.setString(5, event.getSlaveId());
            preparedStatement.setString(6, event.getExecutionType().name());
            preparedStatement.setString(7, event.getShardingItems());
            preparedStatement.setString(8, event.getState().toString());
            preparedStatement.setString(9, this.truncateString(event.getMessage()));
            preparedStatement.setTimestamp(10, new Timestamp(event.getCreationTime().getTime()));
            preparedStatement.execute();
            result = true;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOriginalTaskId(String taskId) {
        String result = "";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.sqlMapper.getSelectOriginalTaskIdForJobStatusTraceLog());){
            preparedStatement.setString(1, taskId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return result;
                String string = resultSet.getString("original_task_id");
                return string;
            }
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    private String truncateString(String str) {
        return !Strings.isNullOrEmpty((String)str) && str.length() > 4000 ? str.substring(0, 4000) : str;
    }
}

