/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.guarantee;

import org.apache.shardingsphere.elasticjob.kernel.internal.storage.JobNodePath;

public final class GuaranteeNode {
    private static final String ROOT = "guarantee";
    static final String STARTED_ROOT = "guarantee/started";
    static final String COMPLETED_ROOT = "guarantee/completed";
    static final String STARTED_LATCH_ROOT = "guarantee/started-latch";
    static final String COMPLETED_LATCH_ROOT = "guarantee/completed-latch";
    private final JobNodePath jobNodePath;

    GuaranteeNode(String jobName) {
        this.jobNodePath = new JobNodePath(jobName);
    }

    static String getStartedNode(int shardingItem) {
        return String.join((CharSequence)"/", STARTED_ROOT, String.valueOf(shardingItem));
    }

    static String getCompletedNode(int shardingItem) {
        return String.join((CharSequence)"/", COMPLETED_ROOT, String.valueOf(shardingItem));
    }

    boolean isStartedRootNode(String path) {
        return this.jobNodePath.getFullPath(STARTED_ROOT).equals(path);
    }

    boolean isCompletedRootNode(String path) {
        return this.jobNodePath.getFullPath(COMPLETED_ROOT).equals(path);
    }
}

