/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.ref.Cleaner;
import java.net.URI;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.gdal.Driver;
import org.apache.sis.storage.gdal.ErrorHandler;
import org.apache.sis.storage.gdal.FeatureLayer;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStoreProvider;
import org.apache.sis.storage.gdal.Opener;
import org.apache.sis.storage.gdal.Subdataset;
import org.apache.sis.storage.gdal.SubdatasetList;
import org.apache.sis.storage.gdal.TiledResource;
import org.apache.sis.system.Cleaners;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.Metadata;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

public class GDALStore
extends DataStore
implements Aggregate {
    private final URI location;
    private final Path path;
    final GeometryLibrary library;
    final NameFactory factory;
    NameSpace namespace;
    private final Opener opener;
    private final Cleaner.Cleanable closer;
    String description;
    private Metadata metadata;
    private List<? extends Resource> components;
    private WKTFormat wktFormat;

    public GDALStore(GDALStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super((DataStoreProvider)Objects.requireNonNull(provider), connector);
        this.library = (GeometryLibrary)connector.getOption(OptionKey.GEOMETRY_LIBRARY);
        this.factory = DefaultNameFactory.provider();
        String[] drivers = (String[])connector.getOption(GDALStoreProvider.DRIVERS_OPTION_KEY);
        this.location = (URI)connector.getStorageAs(URI.class);
        this.path = (Path)connector.getStorageAs(Path.class);
        String url = (String)connector.commit(String.class, "GDAL");
        if (this.location != null) {
            url = Opener.toURL(this.location, this.path, true);
        }
        String filename = IOUtilities.filenameWithoutExtension((String)url);
        this.namespace = this.factory.createNameSpace((GenericName)this.factory.createLocalName(null, (CharSequence)filename), null);
        this.opener = new Opener(provider, url, drivers);
        this.closer = Cleaners.SHARED.register((Object)this, this.opener);
    }

    GDALStore(GDALStore parent, String url, String driver) throws DataStoreException {
        super((DataStore)parent, (DataStoreProvider)parent.getProvider(), new StorageConnector((Object)url), false);
        this.path = parent.path;
        this.location = parent.location;
        this.factory = parent.factory;
        this.library = parent.library;
        this.opener = new Opener(this.getProvider(), url, driver);
        this.closer = Cleaners.SHARED.register((Object)this, this.opener);
    }

    final MemorySegment handle() throws DataStoreClosedException {
        assert (Thread.holdsLock((Object)this));
        MemorySegment handle = this.opener.handle;
        if (handle.scope().isAlive()) {
            return handle;
        }
        throw new DataStoreClosedException(this.getLocale(), "GDAL", new OpenOption[0]);
    }

    public final GDALStoreProvider getProvider() {
        return (GDALStoreProvider)super.getProvider();
    }

    public synchronized Driver getDriver() throws DataStoreException {
        MemorySegment driver;
        GDAL gdal = this.getProvider().GDAL();
        try {
            driver = gdal.getDatasetDriver.invokeExact(this.handle());
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        finally {
            ErrorHandler.throwOnFailure(this, "getDriver");
        }
        return GDAL.isNull(driver) ? null : new Driver(this.getProvider(), driver);
    }

    final String getDriverName(GDAL gdal) {
        try {
            MemorySegment result = gdal.getDatasetDriver.invokeExact(this.handle());
            if (!GDAL.isNull(result)) {
                result = gdal.getIdentifier.invokeExact(result);
                return GDAL.toString(result);
            }
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        return null;
    }

    public Optional<ParameterValueGroup> getOpenParameters() {
        Parameters param = Parameters.castOrWrap((ParameterValueGroup)URIDataStore.parameters((DataStoreProvider)this.provider, (URI)this.location));
        if (param != null) {
            try {
                param.getOrCreate(GDALStoreProvider.DRIVERS_PARAM).setValue((Object)new String[]{this.getDriver().getIdentifier()});
            }
            catch (DataStoreException e) {
                this.listeners.warning((Exception)((Object)e));
            }
        }
        return Optional.ofNullable(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Optional<Resource.FileSet> getFileSet() throws DataStoreException {
        Resource.FileSet fs;
        List<String> files;
        GDAL gdal = this.getProvider().GDAL();
        try {
            MemorySegment list = gdal.getFileList.invokeExact(this.handle());
            try {
                files = GDAL.fromNullTerminatedStrings(list);
            }
            finally {
                gdal.destroy.invokeExact(list);
            }
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        if (files != null && !files.isEmpty()) {
            Path[] paths = new Path[files.size()];
            for (int i = 0; i < paths.length; ++i) {
                Path item = Path.of(files.get(i), new String[0]);
                if (this.path != null) {
                    item = this.path.resolveSibling(item);
                }
                paths[i] = item;
            }
            Driver driver = this.getDriver();
            Objects.requireNonNull(driver);
            fs = driver.new Driver.FileList(paths, this.path, this.location);
        } else if (this.path != null) {
            fs = new Resource.FileSet(this.path);
        } else {
            return Optional.empty();
        }
        return Optional.of(fs);
    }

    public final Optional<GenericName> getIdentifier() throws DataStoreException {
        return this.namespace != null ? Optional.of(this.namespace.name()) : Optional.empty();
    }

    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder builder = new MetadataBuilder();
            builder.addTitle((CharSequence)this.description);
            builder.addIdentifier((GenericName)this.getIdentifier().orElse(null), MetadataBuilder.Scope.RESOURCE);
            this.addFormatInfo(builder);
            return builder.buildAndFreeze();
        }
        return this.metadata;
    }

    final void addFormatInfo(MetadataBuilder builder) throws DataStoreException {
        Driver driver = this.getDriver();
        if (driver != null) {
            builder.addFormatName((CharSequence)driver.getName());
            String id = driver.getIdentifier();
            if (id != null) {
                builder.addFormatReader((CharSequence)Citations.GDAL.getTitle(), (Version)this.getProvider().getVersion().orElse(null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<? extends Resource> components() throws DataStoreException {
        if (this.components == null) {
            try {
                GDAL gdal = this.getProvider().GDAL();
                List<Subdataset> subdatasets = this.groupBySubset(gdal);
                if (subdatasets != null && !subdatasets.isEmpty()) {
                    this.components = subdatasets;
                } else {
                    Object[] merged;
                    TiledResource[] rasters = TiledResource.groupBySizeAndType(this, gdal);
                    FeatureLayer[] vectors = FeatureLayer.listLayers(this, gdal);
                    if (vectors.length == 0) {
                        merged = rasters;
                    } else if (rasters.length == 0) {
                        merged = vectors;
                    } else {
                        merged = (AbstractResource[])Arrays.copyOf(rasters, rasters.length + vectors.length, AbstractResource[].class);
                        System.arraycopy(vectors, 0, merged, rasters.length, vectors.length);
                    }
                    this.components = Containers.viewAsUnmodifiableList((Object[])merged);
                }
            }
            finally {
                ErrorHandler.throwOnFailure(this, "components");
            }
        }
        return this.components;
    }

    List<Subdataset> groupBySubset(GDAL gdal) throws DataStoreException {
        String driver;
        MemorySegment result;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment domain = arena.allocateFrom("SUBDATASETS");
            result = gdal.getMetadata.invokeExact(this.handle(), domain);
        }
        catch (Throwable e) {
            throw GDAL.propagate(e);
        }
        List<String> all = GDAL.fromNullTerminatedStrings(result);
        if (all != null && (driver = this.getDriverName(gdal)) != null) {
            return new SubdatasetList(gdal, this, driver, all);
        }
        return null;
    }

    final WKTFormat wktFormat() {
        if (this.wktFormat == null) {
            this.wktFormat = new WKTFormat();
            this.wktFormat.setConvention(Convention.WKT1_COMMON_UNITS);
        }
        return this.wktFormat;
    }

    final void warning(String caller, String message, Throwable cause) {
        LogRecord record = new LogRecord(Level.WARNING, message);
        record.setThrown(cause);
        this.warning(GDALStore.class, caller, record);
    }

    final void warning(Class<?> classe, String caller, LogRecord record) {
        record.setLoggerName(GDALStoreProvider.LOGGER.getName());
        record.setSourceClassName(classe.getCanonicalName());
        record.setSourceMethodName(caller);
        this.listeners.warning(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Arena changeArena(Arena oldArena, boolean create) {
        int i;
        assert (Thread.holdsLock((Object)this));
        Arena[] arenasToClose = this.opener.arenasToClose;
        if (oldArena != null) {
            try {
                oldArena.close();
            }
            catch (Throwable throwable) {
                for (int i2 = 0; i2 < arenasToClose.length; ++i2) {
                    if (arenasToClose[i2] != oldArena) continue;
                    arenasToClose[i2] = null;
                    break;
                }
                throw throwable;
            }
            for (i = 0; i < arenasToClose.length; ++i) {
                if (arenasToClose[i] != oldArena) continue;
                arenasToClose[i] = null;
                break;
            }
        }
        if (create) {
            i = 0;
            while (arenasToClose[i] != null) {
                if (++i < arenasToClose.length) continue;
                this.opener.arenasToClose = arenasToClose = Arrays.copyOf(arenasToClose, i * 2);
                break;
            }
            arenasToClose[i] = Arena.ofConfined();
            return arenasToClose[i];
        }
        return null;
    }

    public void close() throws DataStoreException {
        final class Flush
        implements AutoCloseable {
            Flush() {
            }

            @Override
            public void close() throws DataStoreException {
                ErrorHandler.throwOnFailure(GDALStore.this, "close");
            }
        }
        try (Flush flush = new Flush();){
            this.closeRecursively();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void closeRecursively() {
        RuntimeException error;
        block46: {
            error = null;
            this.listeners.close();
            try {
                void var2_6;
                GDALStore gDALStore = this;
                // MONITORENTER : gDALStore
                List<? extends Resource> list = this.components;
                this.components = null;
                // MONITOREXIT : gDALStore
                if (list instanceof SubdatasetList) {
                    SubdatasetList delayed = (SubdatasetList)list;
                    List<Subdataset> list2 = delayed.getOpenedComponents();
                }
                if (var2_6 != null) {
                    for (Resource resource : var2_6) {
                        try {
                            if (!(resource instanceof GDALStore)) continue;
                            GDALStore subdataset = (GDALStore)resource;
                            subdataset.closeRecursively();
                        }
                        catch (RuntimeException e) {
                            if (error == null) {
                                error = e;
                                continue;
                            }
                            error.addSuppressed(e);
                        }
                    }
                }
                GDALStore gDALStore2 = this;
            }
            catch (Throwable throwable) {
                GDALStore gDALStore = this;
                // MONITORENTER : gDALStore
                this.closer.clean();
                // MONITOREXIT : gDALStore
                throw throwable;
            }
            this.closer.clean();
            // MONITOREXIT : gDALStore2
            break block46;
            catch (RuntimeException runtimeException) {
                error = runtimeException;
                try {
                    void var2_11;
                    Object delayed = this;
                    // MONITORENTER : delayed
                    List<? extends Resource> list = this.components;
                    this.components = null;
                    // MONITOREXIT : delayed
                    if (list instanceof SubdatasetList) {
                        delayed = (SubdatasetList)list;
                        List<Subdataset> list3 = ((SubdatasetList)delayed).getOpenedComponents();
                    }
                    if (var2_11 != null) {
                        for (Resource resource : var2_11) {
                            try {
                                if (!(resource instanceof GDALStore)) continue;
                                GDALStore subdataset = (GDALStore)resource;
                                subdataset.closeRecursively();
                            }
                            catch (RuntimeException e) {
                                if (error == null) {
                                    error = e;
                                    continue;
                                }
                                error.addSuppressed(e);
                            }
                        }
                    }
                    GDALStore gDALStore = this;
                }
                catch (Throwable throwable) {
                    GDALStore gDALStore = this;
                    // MONITORENTER : gDALStore
                    this.closer.clean();
                    // MONITOREXIT : gDALStore
                    throw throwable;
                }
                this.closer.clean();
                // MONITOREXIT : gDALStore
                catch (Throwable throwable) {
                    try {
                        void var16_27;
                        GDALStore gDALStore = this;
                        // MONITORENTER : gDALStore
                        List<? extends Resource> list = this.components;
                        this.components = null;
                        // MONITOREXIT : gDALStore
                        if (list instanceof SubdatasetList) {
                            SubdatasetList delayed = (SubdatasetList)list;
                            List<Subdataset> list4 = delayed.getOpenedComponents();
                        }
                        if (var16_27 != null) {
                            for (Resource resource : var16_27) {
                                try {
                                    if (!(resource instanceof GDALStore)) continue;
                                    GDALStore subdataset = (GDALStore)resource;
                                    subdataset.closeRecursively();
                                }
                                catch (RuntimeException e) {
                                    if (error == null) {
                                        error = e;
                                        continue;
                                    }
                                    error.addSuppressed(e);
                                }
                            }
                        }
                        GDALStore gDALStore3 = this;
                    }
                    catch (Throwable throwable2) {
                        GDALStore gDALStore = this;
                        // MONITORENTER : gDALStore
                        this.closer.clean();
                        // MONITOREXIT : gDALStore
                        throw throwable2;
                    }
                    this.closer.clean();
                    // MONITOREXIT : gDALStore3
                    throw throwable;
                }
            }
        }
        if (error == null) return;
        throw error;
    }
}

