/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.SphericalCS;

@XmlType(name="SphericalCSType")
@XmlRootElement(name="SphericalCS")
public class DefaultSphericalCS
extends AbstractCS
implements SphericalCS {
    private static final long serialVersionUID = 196295996465774477L;

    public DefaultSphericalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) {
        super(properties, axis0, axis1, axis2);
    }

    public DefaultSphericalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) {
        super(properties, axis0, axis1);
    }

    private DefaultSphericalCS(DefaultSphericalCS original, String name, CoordinateSystemAxis[] axes) {
        super(original, name, axes);
    }

    protected DefaultSphericalCS(SphericalCS original) {
        super((CoordinateSystem)original);
    }

    public static DefaultSphericalCS castOrCopy(SphericalCS object) {
        return object == null || object instanceof DefaultSphericalCS ? (DefaultSphericalCS)object : new DefaultSphericalCS(object);
    }

    @Override
    final int validateAxis(AxisDirection direction, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(direction, false)) {
            return 1;
        }
        if (!Units.isAngular(unit) && !Units.isLinear(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends SphericalCS> getInterface() {
        return SphericalCS.class;
    }

    @Override
    public DefaultSphericalCS forConvention(AxesConvention convention) {
        return (DefaultSphericalCS)super.forConvention(convention);
    }

    @Override
    final AbstractCS createForAxes(String name, CoordinateSystemAxis[] axes) {
        switch (axes.length) {
            case 2: {
                Map<String, ?> properties = this.getPropertiesWithoutIdentifiers(name);
                if (Units.isLinear((Unit)axes[0].getUnit()) || Units.isLinear((Unit)axes[1].getUnit())) {
                    return new DefaultPolarCS(properties, axes[0], axes[1]);
                }
                return new DefaultSphericalCS(properties, axes[0], axes[1]);
            }
            case 3: {
                return new DefaultSphericalCS(this, name, axes);
            }
        }
        throw DefaultSphericalCS.unexpectedDimension(axes, 2, 3);
    }

    private DefaultSphericalCS() {
    }
}

