/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.IncommensurableException;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.factory.MissingFactoryResourceException;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.internal.DeferredCoordinateOperation;
import org.apache.sis.referencing.internal.ParameterizedTransformBuilder;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.internal.shared.EllipsoidalHeightCombiner;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.CoordinateOperationSorter;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.InverseOperationMethod;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.Affine;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class CoordinateOperationRegistry {
    static final Identifier IDENTITY = CoordinateOperationRegistry.createIdentifier((short)101);
    static final Identifier CONSTANTS = CoordinateOperationRegistry.createIdentifier((short)233);
    static final Identifier AXIS_CHANGES = CoordinateOperationRegistry.createIdentifier((short)12);
    static final Identifier UNSPECIFIED_DATUM_CHANGE = CoordinateOperationRegistry.createIdentifier((short)73);
    static final Identifier DATUM_SHIFT = CoordinateOperationRegistry.createIdentifier((short)54);
    static final Identifier SAME_DATUM_ENSEMBLE = CoordinateOperationRegistry.createIdentifier((short)279);
    static final Identifier GEOCENTRIC_CONVERSION = CoordinateOperationRegistry.createIdentifier((short)87);
    private static final Identifier INVERSE_OPERATION = CoordinateOperationRegistry.createIdentifier((short)108);
    private IdentifiedObjectFinder codeFinder;
    protected final CoordinateOperationAuthorityFactory registry;
    protected final CoordinateOperationFactory factory;
    final DefaultCoordinateOperationFactory factorySIS;
    protected final CoordinateOperationContext context;
    protected Extent areaOfInterest;
    protected double desiredAccuracy;
    boolean stopAtFirst;
    private final Map<CoordinateReferenceSystem, List<String>> authorityCodes;

    private static Identifier createIdentifier(short key) {
        return new NamedIdentifier(Citations.SIS, (CharSequence)Vocabulary.formatInternational((short)key));
    }

    static boolean isDatumChange(Identifier typeOfChange) {
        return typeOfChange == DATUM_SHIFT || typeOfChange == UNSPECIFIED_DATUM_CHANGE || typeOfChange == SAME_DATUM_ENSEMBLE;
    }

    CoordinateOperationRegistry(CoordinateOperationAuthorityFactory registry, CoordinateOperationFactory factory, CoordinateOperationContext context) throws FactoryException {
        this.registry = registry;
        this.factory = Objects.requireNonNull(factory);
        this.factorySIS = factory instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)factory : DefaultCoordinateOperationFactory.provider();
        Map authorityCodes = Collections.emptyMap();
        if (registry != null) {
            if (registry instanceof GeodeticAuthorityFactory) {
                this.codeFinder = ((GeodeticAuthorityFactory)registry).newIdentifiedObjectFinder();
            } else {
                try {
                    try {
                        this.codeFinder = IdentifiedObjects.newFinder(Citations.toCodeSpace((Citation)registry.getAuthority()));
                    }
                    catch (BackingStoreException e) {
                        throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
                    }
                }
                catch (NoSuchAuthorityFactoryException e) {
                    this.recoverableException("<init>", (Exception)((Object)e));
                }
            }
            if (this.codeFinder != null) {
                authorityCodes = new IdentityHashMap(5);
            }
        }
        this.authorityCodes = authorityCodes;
        this.context = context;
        if (context != null) {
            this.areaOfInterest = context.getAreaOfInterest();
            this.desiredAccuracy = context.getDesiredAccuracy();
        }
    }

    final <T extends IdentifiedObject> T toAuthorityDefinition(Class<T> type, T object) throws FactoryException {
        if (this.codeFinder != null) {
            this.codeFinder.setIgnoringAxes(false);
            this.codeFinder.setSearchDomain(IdentifiedObjectFinder.Domain.VALID_DATASET);
            IdentifiedObject candidate = this.codeFinder.findSingleton(object);
            if (Utilities.deepEquals(object, (Object)candidate, (ComparisonMode)ComparisonMode.COMPATIBILITY)) {
                return (T)((IdentifiedObject)type.cast(candidate));
            }
        }
        return object;
    }

    private List<String> findCode(CoordinateReferenceSystem crs) throws FactoryException {
        List<String> codes = this.authorityCodes.get(crs);
        if (codes == null) {
            if (this.codeFinder == null) {
                return Collections.emptyList();
            }
            codes = new ArrayList<String>();
            this.codeFinder.setIgnoringAxes(true);
            this.codeFinder.setSearchDomain(CoordinateOperationRegistry.isEasySearch(crs) ? IdentifiedObjectFinder.Domain.EXHAUSTIVE_VALID_DATASET : IdentifiedObjectFinder.Domain.VALID_DATASET);
            int matchCount = 0;
            try {
                Citation authority;
                try {
                    authority = this.registry.getAuthority();
                }
                catch (BackingStoreException e) {
                    throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
                }
                for (IdentifiedObject candidate : this.codeFinder.find((IdentifiedObject)crs)) {
                    Identifier identifier = IdentifiedObjects.getIdentifier(candidate, authority);
                    if (identifier == null) continue;
                    String code = identifier.getCode();
                    if (Utilities.deepEquals((Object)candidate, (Object)crs, (ComparisonMode)ComparisonMode.APPROXIMATE)) {
                        codes.add(matchCount++, code);
                        continue;
                    }
                    codes.add(code);
                }
            }
            catch (UnavailableFactoryException e) {
                this.log(null, (Exception)((Object)e));
                this.codeFinder = null;
            }
            catch (BackingStoreException e) {
                throw (FactoryException)((Object)e.unwrapOrRethrow(FactoryException.class));
            }
            this.authorityCodes.put(crs, codes);
        }
        return codes;
    }

    private static boolean isEasySearch(CoordinateReferenceSystem crs) {
        if (crs instanceof GeneralDerivedCRS) {
            return false;
        }
        if (crs instanceof CompoundCRS) {
            for (CoordinateReferenceSystem c : ((CompoundCRS)crs).getComponents()) {
                if (CoordinateOperationRegistry.isEasySearch(c)) continue;
                return false;
            }
        }
        return true;
    }

    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        SingleCRS source2D = null;
        SingleCRS target2D = null;
        boolean sourceCached = false;
        boolean targetCached = false;
        for (Decomposition decompose : Decomposition.values()) {
            CoordinateReferenceSystem source = sourceCRS;
            CoordinateReferenceSystem target = targetCRS;
            if (decompose.source) {
                if (!sourceCached) {
                    sourceCached = true;
                    source2D = Decomposition.horizontal(sourceCRS);
                }
                source = source2D;
            }
            if (decompose.target) {
                if (!targetCached) {
                    targetCached = true;
                    target2D = Decomposition.horizontal(targetCRS);
                }
                target = target2D;
            }
            if (source == null || target == null) continue;
            try {
                List<CoordinateOperation> operations = this.search(source, target);
                if (operations == null) continue;
                if (decompose.source | decompose.target) {
                    int i = operations.size();
                    while (--i >= 0) {
                        CoordinateOperation operation = operations.get(i);
                        if ((operation = this.propagateVertical(sourceCRS, targetCRS, operation, decompose)) != null) {
                            operation = this.complete(operation, sourceCRS, targetCRS);
                            operations.set(i, operation);
                            continue;
                        }
                        operations.remove(i);
                    }
                }
                if (operations.isEmpty()) continue;
                return operations;
            }
            catch (IllegalArgumentException | IncommensurableException | NoninvertibleTransformException e) {
                CRSPair key = new CRSPair(sourceCRS, targetCRS);
                Object message = this.resources().getString((short)5, (Object)key);
                String details = e.getLocalizedMessage();
                if (details != null) {
                    message = (String)message + " " + details;
                }
                throw new FactoryException((String)message, e);
            }
        }
        return Collections.emptyList();
    }

    private List<CoordinateOperation> search(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws IncommensurableException, NoninvertibleTransformException, FactoryException {
        List<String> sources = this.findCode(sourceCRS);
        if (sources.isEmpty()) {
            return null;
        }
        List<String> targets = this.findCode(targetCRS);
        if (targets.isEmpty()) {
            return null;
        }
        ArrayList<CoordinateOperation> operations = new ArrayList<CoordinateOperation>();
        boolean foundDirectOperations = false;
        boolean useDeprecatedOperations = false;
        for (String sourceID : sources) {
            block13: for (String targetID : targets) {
                if (sourceID.equals(targetID)) {
                    return null;
                }
                boolean needFlagReset = Semaphores.METADATA_ONLY.set();
                try {
                    Set authoritatives;
                    block31: {
                        authoritatives = this.registry.createFromCoordinateReferenceSystemCodes(sourceID, targetID);
                        boolean inverse = Containers.isNullOrEmpty((Collection)authoritatives);
                        if (inverse) {
                            if (foundDirectOperations || Containers.isNullOrEmpty((Collection)(authoritatives = this.registry.createFromCoordinateReferenceSystemCodes(targetID, sourceID)))) {
                                continue;
                            }
                        } else {
                            try {
                                if (foundDirectOperations) break block31;
                                foundDirectOperations = true;
                                operations.clear();
                            }
                            catch (MissingFactoryResourceException | NoSuchAuthorityCodeException e) {
                                this.log(null, (Exception)e);
                                continue;
                            }
                        }
                    }
                    for (CoordinateOperation candidate : authoritatives) {
                        if (candidate == null) continue;
                        if (candidate instanceof Deprecable && ((Deprecable)candidate).isDeprecated()) {
                            if (!useDeprecatedOperations && !operations.isEmpty()) continue block13;
                            useDeprecatedOperations = true;
                        } else if (useDeprecatedOperations) {
                            useDeprecatedOperations = false;
                            operations.clear();
                        }
                        operations.add(candidate);
                    }
                }
                catch (BackingStoreException exception) {
                    throw (FactoryException)((Object)exception.unwrapOrRethrow(FactoryException.class));
                }
                finally {
                    Semaphores.METADATA_ONLY.clearIfTrue(needFlagReset);
                }
            }
        }
        CoordinateOperationSorter.sort(operations, Extents.getGeographicBoundingBox((Extent)this.areaOfInterest));
        ListIterator<CoordinateOperation> it = operations.listIterator();
        while (it.hasNext()) {
            Predicate<CoordinateOperation> filter;
            CoordinateOperation operation;
            block32: {
                operation = (CoordinateOperation)it.next();
                try {
                    if (operation instanceof DeferredCoordinateOperation) {
                        operation = ((DeferredCoordinateOperation)operation).create();
                    }
                    if (operation instanceof SingleOperation && operation.getMathTransform() == null) {
                        operation = this.fromDefiningConversion((SingleOperation)operation, foundDirectOperations ? sourceCRS : targetCRS, foundDirectOperations ? targetCRS : sourceCRS);
                    }
                    if (!foundDirectOperations) {
                        operation = this.inverse(operation);
                    }
                    if (operation == null) {
                        it.remove();
                    }
                    break block32;
                }
                catch (MissingFactoryResourceException | NoninvertibleTransformException e) {
                    this.log(null, (Exception)e);
                    it.remove();
                }
                continue;
            }
            operation = this.complete(operation, sourceCRS, targetCRS);
            Predicate<CoordinateOperation> predicate = filter = this.context != null ? this.context.getOperationFilter() : null;
            if (filter == null || filter.test(operation)) {
                if (this.stopAtFirst) {
                    operations.clear();
                    operations.add(operation);
                    break;
                }
                it.set(operation);
                continue;
            }
            it.remove();
        }
        return operations;
    }

    final CoordinateOperation inverse(SingleOperation op) throws NoninvertibleTransformException, FactoryException {
        CoordinateOperation inverse = AbstractCoordinateOperation.getCachedInverse((CoordinateOperation)op);
        if (inverse != null) {
            return inverse;
        }
        CoordinateReferenceSystem sourceCRS = op.getSourceCRS();
        CoordinateReferenceSystem targetCRS = op.getTargetCRS();
        MathTransform transform = op.getMathTransform().inverse();
        OperationMethod method = InverseOperationMethod.create(op.getMethod(), this);
        Map<String, Object> properties = CoordinateOperationRegistry.properties(INVERSE_OPERATION);
        InverseOperationMethod.properties(op, properties);
        inverse = this.createFromMathTransform(properties, targetCRS, sourceCRS, transform, method, null, CoordinateOperationRegistry.typeOf((CoordinateOperation)op));
        AbstractCoordinateOperation.setCachedInverse((CoordinateOperation)op, inverse);
        return inverse;
    }

    private CoordinateOperation inverse(CoordinateOperation operation) throws NoninvertibleTransformException, FactoryException {
        if (AbstractCoordinateOperation.isSingleOperation(operation)) {
            return this.inverse((SingleOperation)operation);
        }
        CoordinateOperation inverse = AbstractCoordinateOperation.getCachedInverse(operation);
        if (inverse != null) {
            return inverse;
        }
        if (operation instanceof ConcatenatedOperation) {
            Object[] inverted = this.getSteps((ConcatenatedOperation)operation, true);
            ArraysExt.reverse((Object[])inverted);
            Map<String, Object> properties = CoordinateOperationRegistry.properties(INVERSE_OPERATION);
            MathTransform transform = operation.getMathTransform();
            if (transform != null) {
                properties.put("transform", transform.inverse());
            }
            inverse = this.factory.createConcatenatedOperation(properties, (CoordinateOperation[])inverted);
            AbstractCoordinateOperation.setCachedInverse(operation, inverse);
        }
        return inverse;
    }

    private CoordinateOperation[] getSteps(ConcatenatedOperation operation, boolean inverse) throws NoninvertibleTransformException, FactoryException {
        CoordinateOperation[] steps = (CoordinateOperation[])operation.getOperations().toArray(CoordinateOperation[]::new);
        CoordinateReferenceSystem previous = operation.getSourceCRS();
        for (int i = 0; i < steps.length; ++i) {
            CoordinateReferenceSystem target;
            CoordinateOperation step = steps[i];
            CoordinateReferenceSystem source = step.getSourceCRS();
            boolean r = DefaultConcatenatedOperation.verifyStepChaining(null, i, previous, source, target = step.getTargetCRS());
            if (r != inverse && (steps[i] = this.inverse(step)) == null) {
                throw new NoninvertibleTransformException(this.resources().getString((short)52, this.label((IdentifiedObject)step)));
            }
            previous = r ? source : target;
        }
        return steps;
    }

    private CoordinateOperation complete(CoordinateOperation operation, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws IncommensurableException, NoninvertibleTransformException, FactoryException {
        CoordinateReferenceSystem source = operation.getSourceCRS();
        CoordinateReferenceSystem target = operation.getTargetCRS();
        MathTransformFactory mtFactory = this.factorySIS.getMathTransformFactory();
        MathTransform prepend = CoordinateOperationRegistry.swapAndScaleAxes(sourceCRS, source, mtFactory);
        MathTransform append = CoordinateOperationRegistry.swapAndScaleAxes(target, targetCRS, mtFactory);
        if (prepend != null) {
            source = sourceCRS;
        }
        if (append != null) {
            target = targetCRS;
        }
        return this.transform(source, prepend, operation, append, target, mtFactory);
    }

    private static MathTransform swapAndScaleAxes(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransformFactory mtFactory) throws IncommensurableException, FactoryException {
        assert (CRS.getDimensionOrZero(sourceCRS) != CRS.getDimensionOrZero(targetCRS) || Utilities.deepEquals((Object)sourceCRS, (Object)targetCRS, (ComparisonMode)ComparisonMode.ALLOW_VARIANT));
        Matrix m = CoordinateSystems.swapAndScaleAxes(sourceCRS.getCoordinateSystem(), targetCRS.getCoordinateSystem());
        return m.isIdentity() ? null : mtFactory.createAffineTransform(m);
    }

    private CoordinateOperation transform(CoordinateReferenceSystem sourceCRS, MathTransform prepend, CoordinateOperation operation, MathTransform append, CoordinateReferenceSystem targetCRS, MathTransformFactory mtFactory) throws NoninvertibleTransformException, FactoryException {
        if ((prepend == null || prepend.isIdentity()) && (append == null || append.isIdentity())) {
            return operation;
        }
        if (operation instanceof ConcatenatedOperation) {
            CoordinateOperation[] steps = this.getSteps((ConcatenatedOperation)operation, false);
            switch (steps.length) {
                case 0: {
                    break;
                }
                case 1: {
                    operation = steps[0];
                    break;
                }
                default: {
                    int n = steps.length - 1;
                    CoordinateOperation first = steps[0];
                    CoordinateOperation last = steps[n];
                    steps[0] = this.transform(sourceCRS, prepend, first, null, first.getTargetCRS(), mtFactory);
                    steps[n] = this.transform(last.getSourceCRS(), null, last, append, targetCRS, mtFactory);
                    return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)operation), steps);
                }
            }
        }
        MathTransform transform = operation.getMathTransform();
        if (prepend != null) {
            transform = mtFactory.createConcatenatedTransform(prepend, transform);
        }
        if (append != null) {
            transform = mtFactory.createConcatenatedTransform(transform, append);
        }
        assert (!transform.equals((Object)operation.getMathTransform())) : transform;
        return this.recreate(operation, sourceCRS, targetCRS, transform, null);
    }

    private CoordinateOperation recreate(CoordinateOperation operation, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method) throws FactoryException {
        CoordinateReferenceSystem crs = operation.getSourceCRS();
        if (Utilities.equalsApproximately((Object)sourceCRS, (Object)crs)) {
            sourceCRS = crs;
        }
        if (Utilities.equalsApproximately((Object)targetCRS, (Object)(crs = operation.getTargetCRS()))) {
            targetCRS = crs;
        }
        HashMap properties = new HashMap(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)operation));
        properties.put("operationType", CoordinateOperationRegistry.typeOf(operation));
        if (AbstractCoordinateOperation.isSingleOperation(operation)) {
            SingleOperation single = (SingleOperation)operation;
            properties.put("parameters", single.getParameterValues());
            if (method == null && (method = single.getMethod()) instanceof AbstractProvider) {
                method = ((AbstractProvider)method).variantFor(transform);
            }
        }
        return this.factorySIS.createSingleOperation(properties, sourceCRS, targetCRS, AbstractCoordinateOperation.getInterpolationCRS(operation), method, transform);
    }

    private CoordinateOperation fromDefiningConversion(SingleOperation operation, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        ParameterValueGroup parameters = operation.getParameterValues();
        if (parameters != null) {
            CoordinateReferenceSystem crs = operation.getSourceCRS();
            if (Utilities.equalsApproximately((Object)sourceCRS, (Object)crs)) {
                sourceCRS = crs;
            }
            if (Utilities.equalsApproximately((Object)targetCRS, (Object)(crs = operation.getTargetCRS()))) {
                targetCRS = crs;
            }
            MathTransformBuilder builder = this.createTransformBuilder(parameters, sourceCRS, targetCRS);
            MathTransform mt = builder.create();
            return this.factorySIS.createSingleOperation(IdentifiedObjects.getProperties((IdentifiedObject)operation, new String[0]), sourceCRS, targetCRS, null, operation.getMethod(), mt);
        }
        this.log(this.resources().createLogRecord(Level.WARNING, (short)74, IdentifiedObjects.getIdentifierOrName((IdentifiedObject)operation)), null);
        return null;
    }

    private CoordinateOperation propagateVertical(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateOperation operation, Decomposition decompose) throws NoninvertibleTransformException, FactoryException {
        ArrayList<CoordinateOperation> operations = new ArrayList<CoordinateOperation>();
        if (operation instanceof ConcatenatedOperation) {
            operations.addAll(Arrays.asList(this.getSteps((ConcatenatedOperation)operation, false)));
        } else {
            operations.add(operation);
        }
        if (decompose.source && !this.propagateVertical(sourceCRS, targetCRS, operations.listIterator(), true) || decompose.target && !this.propagateVertical(sourceCRS, targetCRS, operations.listIterator(operations.size()), false)) {
            return null;
        }
        switch (operations.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (CoordinateOperation)operations.get(0);
            }
        }
        return this.factory.createConcatenatedOperation(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)operation), (CoordinateOperation[])operations.toArray(CoordinateOperation[]::new));
    }

    private boolean propagateVertical(CoordinateReferenceSystem source3D, CoordinateReferenceSystem target3D, ListIterator<CoordinateOperation> operations, boolean forward) throws FactoryException {
        CoordinateReferenceSystem targetCRS;
        CoordinateOperation op;
        CoordinateReferenceSystem sourceCRS;
        while ((forward ? operations.hasNext() : operations.hasPrevious()) && (sourceCRS = (op = forward ? operations.next() : operations.previous()).getSourceCRS()) instanceof GeodeticCRS && (targetCRS = op.getTargetCRS()) instanceof GeodeticCRS && sourceCRS.getCoordinateSystem() instanceof EllipsoidalCS && targetCRS.getCoordinateSystem() instanceof EllipsoidalCS) {
            boolean is2D;
            Matrix matrix = MathTransforms.getMatrix(op.getMathTransform());
            if (matrix == null) {
                MathTransform mt;
                MathTransformBuilder builder;
                if (!AbstractCoordinateOperation.isSingleOperation(op)) break;
                if (forward) {
                    sourceCRS = this.toGeodetic3D(sourceCRS, source3D);
                } else {
                    targetCRS = this.toGeodetic3D(targetCRS, target3D);
                }
                try {
                    ParameterValueGroup parameters = ((SingleOperation)op).getParameterValues();
                    builder = this.createTransformBuilder(parameters, sourceCRS, targetCRS);
                    mt = builder.create();
                }
                catch (InvalidGeodeticParameterException e) {
                    this.log(null, (Exception)((Object)e));
                    break;
                }
                operations.set(this.recreate(op, sourceCRS, targetCRS, mt, builder.getMethod().orElse(null)));
                return true;
            }
            int numRow = matrix.getNumRow();
            int numCol = matrix.getNumCol();
            boolean bl = is2D = numCol == 3 && numRow == 3;
            if (!is2D && !(forward ? numCol == 3 && numRow == 4 : numCol == 4 && numRow == 3)) break;
            if ((matrix = Matrices.resizeAffine(matrix, 4, 4)).isIdentity()) {
                operations.remove();
            } else {
                MathTransform mt = this.factorySIS.getMathTransformFactory().createAffineTransform(matrix);
                operations.set(this.recreate(op, this.toGeodetic3D(sourceCRS, source3D), this.toGeodetic3D(targetCRS, target3D), mt, null));
            }
            if (is2D) continue;
            return true;
        }
        return false;
    }

    private CoordinateReferenceSystem toGeodetic3D(CoordinateReferenceSystem crs, CoordinateReferenceSystem candidate) throws FactoryException {
        assert (crs instanceof GeodeticCRS && crs.getCoordinateSystem() instanceof EllipsoidalCS) : crs;
        if (crs.getCoordinateSystem().getDimension() != 2) {
            return crs;
        }
        if (crs.getClass() == candidate.getClass() && candidate.getCoordinateSystem().getDimension() == 3 && Utilities.equalsIgnoreMetadata((Object)DatumOrEnsemble.of((SingleCRS)candidate), (Object)DatumOrEnsemble.of((SingleCRS)crs))) {
            return candidate;
        }
        EllipsoidalHeightCombiner c = new EllipsoidalHeightCombiner(this.factorySIS.crsFactory, this.factorySIS.csFactory, this.factory);
        return this.toAuthorityDefinition(CoordinateReferenceSystem.class, c.createCompoundCRS(CoordinateOperationRegistry.derivedFrom((IdentifiedObject)crs), new CoordinateReferenceSystem[]{crs, CommonCRS.Vertical.ELLIPSOIDAL.crs()}));
    }

    private static Map<String, ?> derivedFrom(IdentifiedObject object) {
        return IdentifiedObjects.getProperties(object, "identifiers");
    }

    static Map<String, Object> properties(Identifier name) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", name);
        return properties;
    }

    private MathTransformBuilder createTransformBuilder(ParameterValueGroup parameters, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        ParameterizedTransformBuilder builder = new ParameterizedTransformBuilder(this.factorySIS.getMathTransformFactory(), null);
        builder.setParameters(parameters, true);
        builder.setSourceAxes(sourceCRS);
        builder.setTargetAxes(targetCRS);
        return builder;
    }

    final CoordinateOperation createFromMathTransform(Map<String, Object> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform, OperationMethod method, ParameterValueGroup parameters, Class<? extends CoordinateOperation> type) throws FactoryException {
        CoordinateOperation operation;
        if (transform instanceof CoordinateOperation && Objects.equals((operation = (CoordinateOperation)transform).getSourceCRS(), sourceCRS) && Objects.equals(operation.getTargetCRS(), targetCRS) && Objects.equals(operation.getMathTransform(), transform) && (method == null || !(operation instanceof SingleOperation) || Objects.equals(((SingleOperation)operation).getMethod(), method))) {
            return operation;
        }
        if (method == null) {
            Matrix matrix = MathTransforms.getMatrix(transform);
            if (matrix != null) {
                method = Affine.provider(transform.getSourceDimensions(), transform.getTargetDimensions(), Matrices.isAffine(matrix));
            } else {
                ParameterDescriptorGroup descriptor = AbstractCoordinateOperation.getParameterDescriptors(transform);
                if (descriptor != null) {
                    try {
                        method = CoordinateOperations.findMethod(this.factorySIS.getMathTransformFactory(), (IdentifiedObject)descriptor);
                    }
                    catch (NoSuchIdentifierException e) {
                        this.recoverableException("createFromMathTransform", (Exception)((Object)e));
                        method = this.factorySIS.createOperationMethod(properties, descriptor);
                    }
                }
            }
        }
        if (parameters != null) {
            properties.put("parameters", parameters);
        }
        if (type != null) {
            properties.put("operationType", type);
            if (Conversion.class.isAssignableFrom(type) && transform.isIdentity()) {
                properties.replace("name", AXIS_CHANGES, IDENTITY);
            }
        }
        return this.factorySIS.createSingleOperation(properties, sourceCRS, targetCRS, null, method, transform);
    }

    static Class<? extends CoordinateOperation> typeOf(CoordinateOperation op) {
        if (op instanceof Transformation) {
            return Transformation.class;
        }
        if (op instanceof Conversion) {
            return Conversion.class;
        }
        return null;
    }

    final Locale getLocale() {
        return this.context != null ? this.context.getLocale() : null;
    }

    final Resources resources() {
        return Resources.forLocale(this.getLocale());
    }

    final String label(IdentifiedObject object) {
        return CRSPair.label(object, this.getLocale());
    }

    final String datumChangeNotFound(IdentifiedObject source, IdentifiedObject target) {
        Locale locale = this.getLocale();
        return Resources.forLocale(locale).getString((short)106, IdentifiedObjects.getDisplayName(source, locale), IdentifiedObjects.getDisplayName(target, locale));
    }

    private void log(LogRecord record, Exception exception) {
        if (record == null) {
            record = new LogRecord(Level.WARNING, exception.getLocalizedMessage());
            if (exception instanceof NoninvertibleTransformException) {
                record.setThrown(exception);
            }
        }
        if (record.getSourceMethodName() == null) {
            record.setSourceMethodName("createOperations");
        }
        CoordinateOperationContext.log(this.context, CoordinateOperationFinder.class, AbstractCoordinateOperation.LOGGER, record);
    }

    final void recoverableException(String method, Exception exception) {
        LogRecord record = new LogRecord(Level.FINE, exception.getLocalizedMessage());
        record.setThrown(exception);
        record.setSourceMethodName(method);
        this.log(record, null);
    }

    private static enum Decomposition {
        NONE(false, false),
        HORIZONTAL_TARGET(false, true),
        HORIZONTAL(true, true),
        HORIZONTAL_SOURCE(true, false);

        final boolean source;
        final boolean target;

        private Decomposition(boolean source, boolean target) {
            this.source = source;
            this.target = target;
        }

        static SingleCRS horizontal(CoordinateReferenceSystem crs) {
            SingleCRS sep;
            if (crs instanceof SingleCRS && (sep = CRS.getHorizontalComponent(crs)) != crs) {
                return sep;
            }
            return null;
        }
    }
}

