/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.Collection;
import java.util.Collections;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.FinalLocationType;
import org.apache.sis.referencing.gazetteer.LocationFormat;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ModifiableLocationTypeAdapter;
import org.apache.sis.util.iso.Types;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.util.InternationalString;

public abstract class AbstractLocation {
    private AbstractLocationType type;
    private final CharSequence identifier;

    protected AbstractLocation(ModifiableLocationType type, CharSequence identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    AbstractLocation(AbstractLocationType type, CharSequence identifier) {
        this.type = type;
        this.identifier = identifier;
    }

    final void setTypeToChild() {
        this.type = ((FinalLocationType)this.type).children.get(0);
    }

    public InternationalString getGeographicIdentifier() {
        return Types.toInternationalString((CharSequence)this.identifier);
    }

    public Collection<? extends InternationalString> getAlternativeGeographicIdentifiers() {
        return Collections.emptySet();
    }

    public TemporalExtent getTemporalExtent() {
        return null;
    }

    public GeographicExtent getGeographicExtent() {
        return null;
    }

    public Envelope getEnvelope() {
        GeographicExtent extent = this.getGeographicExtent();
        return extent instanceof GeographicBoundingBox ? new Envelope2D((GeographicBoundingBox)extent) : null;
    }

    public DirectPosition getPosition() {
        Envelope envelope = this.getEnvelope();
        if (envelope == null) {
            return null;
        }
        int dimension = envelope.getDimension();
        GeneralDirectPosition pos = new GeneralDirectPosition(dimension);
        pos.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
        for (int i = 0; i < dimension; ++i) {
            pos.setCoordinate(i, envelope.getMedian(i));
        }
        return pos;
    }

    public final ModifiableLocationType getLocationType() {
        return ModifiableLocationTypeAdapter.copy(this.type);
    }

    final AbstractLocationType type() {
        return this.type;
    }

    public AbstractParty getAdministrator() {
        return this.type != null ? this.type.getOwner() : null;
    }

    public Collection<? extends AbstractLocation> getParents() {
        return Collections.emptyList();
    }

    public Collection<? extends AbstractLocation> getChildren() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LocationFormat locationFormat = LocationFormat.INSTANCE;
        synchronized (locationFormat) {
            return LocationFormat.INSTANCE.format(this);
        }
    }
}

