/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.base;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.GeometryFromFeature;
import org.apache.sis.filter.base.Node;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.util.ScopedName;

class GeometryConverter<R, G>
extends Node
implements Optimization.OnExpression<R, GeometryWrapper> {
    private static final long serialVersionUID = 1164523020740782044L;
    private static final ScopedName NAME = GeometryConverter.createName("GeometryConverter");
    final Geometries<G> library;
    final Expression<R, ?> expression;

    GeometryConverter(Geometries<G> library, Expression<R, ?> expression) {
        this.library = Objects.requireNonNull(library);
        this.expression = Objects.requireNonNull(expression);
    }

    public static <R, G> GeometryConverter<R, G> create(Geometries<G> library, Expression<R, ?> expression) {
        if (expression instanceof GeometryConverter) {
            GeometryConverter candidate = (GeometryConverter)expression;
            if (library.equals(candidate.library)) {
                return (GeometryConverter)expression;
            }
            throw new IllegalArgumentException(Resources.format((short)91, library.library, candidate.library.library));
        }
        GeometryFromFeature<G> candidate = GeometryFromFeature.tryCreate(library, expression);
        if (candidate == null) {
            return new GeometryConverter<R, G>(library, expression);
        }
        return candidate;
    }

    @Override
    public Expression<R, GeometryWrapper> recreate(Expression<R, ?>[] effective) {
        return GeometryConverter.create(this.library, effective[0]);
    }

    @Override
    public ScopedName getFunctionName() {
        return NAME;
    }

    @Override
    public Class<? super R> getResourceClass() {
        return this.expression.getResourceClass();
    }

    @Override
    public List<Expression<R, ?>> getParameters() {
        return List.of(this.expression);
    }

    @Override
    protected Collection<?> getChildren() {
        return this.getParameters();
    }

    @Override
    public GeometryWrapper apply(R input) {
        ImmutableEnvelope envelope;
        Object value = this.expression.apply(input);
        if (value instanceof GeographicBoundingBox) {
            envelope = new ImmutableEnvelope((GeographicBoundingBox)value);
        } else if (value instanceof Envelope) {
            envelope = (Envelope)value;
        } else {
            try {
                if (value instanceof DirectPosition) {
                    return this.library.createPoint((DirectPosition)value);
                }
                return this.library.castOrWrap(value);
            }
            catch (ClassCastException | MismatchedDimensionException e) {
                throw new IllegalArgumentException(Errors.format((short)64, this.library.rootClass, (Object)Classes.getClass(value)), e);
            }
        }
        return this.library.toGeometry2D((Envelope)envelope, WraparoundMethod.NONE);
    }

    @Override
    public <N> Expression<R, N> toValueType(Class<N> target) {
        if (target.isAssignableFrom(this.library.rootClass)) {
            return this.expression;
        }
        if (target.isAssignableFrom(GeometryWrapper.class)) {
            return this;
        }
        throw new ClassCastException(Errors.format((short)200, target));
    }
}

