/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diff;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.PublicApi;
import graphql.introspection.IntrospectionQuery;
import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.parser.Parser;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaPrinter;
import java.util.Map;

@PublicApi
public class SchemaDiffSet {
    private final Document oldSchemaDoc;
    private final Document newSchemaDoc;
    private final boolean supportsEnforcingDirectives;

    private SchemaDiffSet(Document oldSchemaDoc, Document newSchemaDoc, boolean supportsEnforcingDirectives) {
        this.oldSchemaDoc = oldSchemaDoc;
        this.newSchemaDoc = newSchemaDoc;
        this.supportsEnforcingDirectives = supportsEnforcingDirectives;
    }

    public Document getOldSchemaDefinitionDoc() {
        return this.oldSchemaDoc;
    }

    public Document getNewSchemaDefinitionDoc() {
        return this.newSchemaDoc;
    }

    public boolean supportsEnforcingDirectives() {
        return this.supportsEnforcingDirectives;
    }

    public static SchemaDiffSet diffSetFromIntrospection(Map<String, Object> introspectionOld, Map<String, Object> introspectionNew) {
        Document oldDoc = SchemaDiffSet.getDocumentFromIntrospection(introspectionOld);
        Document newDoc = SchemaDiffSet.getDocumentFromIntrospection(introspectionNew);
        return new SchemaDiffSet(oldDoc, newDoc, false);
    }

    public static SchemaDiffSet diffSetFromIntrospection(GraphQLSchema oldSchema, GraphQLSchema newSchema) {
        Map<String, Object> introspectionOld = SchemaDiffSet.introspect(oldSchema);
        Map<String, Object> introspectionNew = SchemaDiffSet.introspect(newSchema);
        return SchemaDiffSet.diffSetFromIntrospection(introspectionOld, introspectionNew);
    }

    public static SchemaDiffSet diffSetFromSdl(String oldSchemaSdl, String newSchemaSdl) {
        Document oldDoc = SchemaDiffSet.getDocumentFromSDLString(oldSchemaSdl);
        Document newDoc = SchemaDiffSet.getDocumentFromSDLString(newSchemaSdl);
        return new SchemaDiffSet(oldDoc, newDoc, true);
    }

    public static SchemaDiffSet diffSetFromSdl(GraphQLSchema oldSchema, GraphQLSchema newSchema) {
        String oldSchemaSdl = SchemaDiffSet.getSchemaSdl(oldSchema);
        String newSchemaSdl = SchemaDiffSet.getSchemaSdl(newSchema);
        return SchemaDiffSet.diffSetFromSdl(oldSchemaSdl, newSchemaSdl);
    }

    private static Document getDocumentFromIntrospection(Map<String, Object> introspectionResult) {
        return new IntrospectionResultToSchema().createSchemaDefinition(introspectionResult);
    }

    private static Document getDocumentFromSDLString(String sdlString) {
        return Parser.parse(sdlString);
    }

    private static String getSchemaSdl(GraphQLSchema schema) {
        SchemaPrinter schemaPrinter = new SchemaPrinter();
        return schemaPrinter.print(schema);
    }

    private static Map<String, Object> introspect(GraphQLSchema schema) {
        GraphQL gql = GraphQL.newGraphQL(schema).build();
        ExecutionResult result = gql.execute(IntrospectionQuery.INTROSPECTION_QUERY);
        Assert.assertTrue(result.getErrors().size() == 0, () -> "The schema has errors during Introspection");
        return (Map)result.getData();
    }
}

