/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.network.TransferableChannel;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.UnalignedRecords;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Utils;

public class UnalignedMemoryRecords
implements UnalignedRecords {
    private static final UnalignedMemoryRecords EMPTY = new UnalignedMemoryRecords(ByteBuffer.allocate(0));
    private final ByteBuffer buffer;

    public UnalignedMemoryRecords(ByteBuffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
    }

    public ByteBuffer buffer() {
        return this.buffer.duplicate();
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.remaining();
    }

    @Override
    public int writeTo(TransferableChannel channel, int position, int length) throws IOException {
        if ((long)position + (long)length > (long)this.buffer.limit()) {
            throw new IllegalArgumentException("position+length should not be greater than buffer.limit(), position: " + position + ", length: " + length + ", buffer.limit(): " + this.buffer.limit());
        }
        return Utils.tryWriteTo(channel, position, length, this.buffer);
    }

    public static UnalignedMemoryRecords empty() {
        return EMPTY;
    }
}

