/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals.MetricKeyable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals.MetricsEmitter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals.SinglePointMetric;

public class ClientTelemetryEmitter
implements MetricsEmitter {
    private final Predicate<? super MetricKeyable> selector;
    private final List<SinglePointMetric> emitted;
    private final boolean deltaMetrics;

    ClientTelemetryEmitter(Predicate<? super MetricKeyable> selector, boolean deltaMetrics) {
        this.selector = selector;
        this.emitted = new ArrayList<SinglePointMetric>();
        this.deltaMetrics = deltaMetrics;
    }

    @Override
    public boolean shouldEmitMetric(MetricKeyable metricKeyable) {
        return this.selector.test(metricKeyable);
    }

    @Override
    public boolean shouldEmitDeltaMetrics() {
        return this.deltaMetrics;
    }

    @Override
    public boolean emitMetric(SinglePointMetric metric) {
        if (!this.shouldEmitMetric(metric)) {
            return false;
        }
        this.emitted.add(metric);
        return true;
    }

    @Override
    public List<SinglePointMetric> emittedMetrics() {
        return Collections.unmodifiableList(this.emitted);
    }
}

