/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

public final class Status {
    public static final int _UNDEFINED_ = -1;
    public static final int INVALIDATED = 0;
    public static final int EXISTING = 1;
    public static final int EXISTING_MODIFIED = 2;
    public static final int EXISTING_REMOVED = 3;
    public static final int NEW = 4;
    public static final int STALE_MODIFIED = 5;
    public static final int STALE_DESTROYED = 6;
    public static final int MODIFIED = 7;
    public static final int REMOVED = 8;
    private static final String[] STATUS_NAMES = new String[]{"INVALIDATED", "EXISTING", "EXISTING_MODIFIED", "EXISTING_REMOVED", "NEW", "STALE_MODIFIED", "STALE_DESTROYED", "MODIFIED", "REMOVED"};

    private Status() {
    }

    public static boolean isTerminal(int status) {
        return status == 8 || status == 6;
    }

    public static boolean isValid(int status) {
        return status == 1 || status == 2 || status == 4;
    }

    public static boolean isStale(int status) {
        return status == 6 || status == 5;
    }

    public static boolean isTransient(int status) {
        return status == 2 || status == 3 || status == 4;
    }

    public static boolean isValidStatusChange(int oldStatus, int newStatus) {
        if (oldStatus == newStatus) {
            return true;
        }
        boolean isValid = false;
        switch (newStatus) {
            case 0: {
                isValid = oldStatus == 1;
                break;
            }
            case 1: {
                switch (oldStatus) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        isValid = true;
                    }
                }
                break;
            }
            case 2: {
                isValid = oldStatus == 1;
                break;
            }
            case 3: {
                isValid = oldStatus == 1 || oldStatus == 2;
                break;
            }
            case 5: 
            case 6: {
                isValid = oldStatus == 2 || oldStatus == 3 || oldStatus == 5;
                break;
            }
            case 8: {
                isValid = true;
                break;
            }
            case 7: {
                if (oldStatus == 4) break;
                isValid = true;
            }
        }
        return isValid;
    }

    public static int getNewStatus(int oldStatus, int newStatusHint) {
        int newStatus;
        switch (newStatusHint) {
            case 7: {
                if (oldStatus == 1 || oldStatus == 0) {
                    newStatus = 7;
                    break;
                }
                if (oldStatus == 2) {
                    newStatus = 5;
                    break;
                }
                newStatus = oldStatus;
                break;
            }
            case 8: {
                if (oldStatus == 2 || oldStatus == 5) {
                    newStatus = 6;
                    break;
                }
                newStatus = newStatusHint;
                break;
            }
            default: {
                newStatus = newStatusHint;
            }
        }
        return newStatus;
    }

    public static String getName(int status) {
        if (status == -1) {
            return "_UNDEFINED_";
        }
        if (status < 0 || status >= STATUS_NAMES.length) {
            throw new IllegalArgumentException("Invalid status " + status);
        }
        return STATUS_NAMES[status];
    }
}

