/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.junit;

import org.apache.sling.commons.testing.junit.Retry;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryRule
implements TestRule {
    public static final int DEFAULT_DEFAULT_TIMEOUT_MSEC = 5000;
    public static final int DEFAULT_DEFAULT_INTERVAL_MSEC = 500;
    private static final Logger log = LoggerFactory.getLogger(RetryRule.class);
    private final long defaultTimeout;
    private final long defaultInterval;

    public RetryRule() {
        this(5000L, 500L);
    }

    public RetryRule(long defaultTimeout, long defaultInterval) {
        this.defaultTimeout = defaultTimeout;
        this.defaultInterval = defaultInterval;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", default interval=" + this.defaultInterval + " msec, default timeout=" + this.defaultTimeout + " msec";
    }

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            private Throwable eval(Statement stmt) {
                try {
                    stmt.evaluate();
                }
                catch (Throwable t) {
                    return t;
                }
                return null;
            }

            public void evaluate() throws Throwable {
                Retry r;
                int retries = 0;
                Throwable t = this.eval(statement);
                if (t != null && (r = (Retry)description.getAnnotation(Retry.class)) != null) {
                    long timeout = System.currentTimeMillis() + RetryRule.this.getTimeout(r.timeoutMsec());
                    while (System.currentTimeMillis() < timeout) {
                        ++retries;
                        t = this.eval(statement);
                        if (t == null) break;
                        Thread.sleep(RetryRule.this.getInterval(r.intervalMsec()));
                    }
                }
                if (t != null) {
                    if (retries > 0) {
                        log.debug("{} fails after retrying {} time(s)", (Object)statement, (Object)retries);
                    }
                    throw t;
                }
                if (retries > 0) {
                    log.debug("{} succeeds after retrying {} time(s)", (Object)statement, (Object)retries);
                }
            }
        };
    }

    long getTimeout(long ruleTimeout) {
        return ruleTimeout > 0L ? ruleTimeout : this.defaultTimeout;
    }

    long getInterval(long ruleInterval) {
        return ruleInterval > 0L ? ruleInterval : this.defaultInterval;
    }
}

