/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.factory.PostConstructException;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.Result;
import org.apache.sling.models.testmodels.classes.FailingPostConstructModel;
import org.apache.sling.models.testmodels.classes.FalsePostConstructModel;
import org.apache.sling.models.testmodels.classes.SubClass;
import org.apache.sling.models.testmodels.classes.SubClassOverriddenPostConstruct;
import org.apache.sling.models.testmodels.classes.TruePostConstructModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PostConstructTest {
    @Mock
    private Resource resource;
    private ModelAdapterFactory factory;

    PostConstructTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{SubClass.class, SubClassOverriddenPostConstruct.class, FailingPostConstructModel.class, FalsePostConstructModel.class, TruePostConstructModel.class});
    }

    @Test
    void testClassOrder() {
        SubClass sc = (SubClass)this.factory.getAdapter((Object)this.resource, SubClass.class);
        Assertions.assertTrue((sc.getPostConstructCalledTimestampInSub() > sc.getPostConstructCalledTimestampInSuper() ? 1 : 0) != 0);
        Assertions.assertTrue((sc.getPostConstructCalledTimestampInSuper() > 0L ? 1 : 0) != 0);
    }

    @Test
    void testOverriddenPostConstruct() {
        SubClassOverriddenPostConstruct sc = (SubClassOverriddenPostConstruct)this.factory.getAdapter((Object)this.resource, SubClassOverriddenPostConstruct.class);
        Assertions.assertEquals((int)1, (int)sc.getPostConstructorCalledCounter(), (String)"Post construct not called exactly one time in sub class!");
        Assertions.assertEquals((long)0L, (long)sc.getPostConstructCalledTimestampInSuper(), (String)"Post construct was called on super class although overridden in sub class");
    }

    @Test
    void testPostConstructMethodWhichThrowsException() {
        FailingPostConstructModel model = (FailingPostConstructModel)this.factory.getAdapter((Object)this.resource, FailingPostConstructModel.class);
        Assertions.assertNull((Object)model);
    }

    @Test
    void testPostConstructMethodWhichReturnsFalse() {
        FalsePostConstructModel model = (FalsePostConstructModel)this.factory.getAdapter((Object)this.resource, FalsePostConstructModel.class);
        Assertions.assertNull((Object)model);
    }

    @Test
    void testPostConstructMethodWhichReturnsTrue() {
        TruePostConstructModel model = (TruePostConstructModel)this.factory.getAdapter((Object)this.resource, TruePostConstructModel.class);
        Assertions.assertNotNull((Object)model);
    }

    @Test
    void testPostConstructMethodWhichReturnsFalseCreateModel() {
        Assertions.assertThrows(PostConstructException.class, () -> this.factory.createModel((Object)this.resource, FalsePostConstructModel.class));
    }

    void testPostConstructMethodWhichReturnsFalseInternalCreateModel() {
        Assertions.assertSame((Object)Result.POST_CONSTRUCT_PREVENTED_MODEL_CONSTRUCTION, (Object)this.factory.internalCreateModel((Object)this.resource, FalsePostConstructModel.class));
    }

    @Test
    void testPostConstructMethodWhichReturnsTrueCreateModel() {
        TruePostConstructModel model = (TruePostConstructModel)this.factory.createModel((Object)this.resource, TruePostConstructModel.class);
        Assertions.assertNotNull((Object)model);
    }

    @Test
    void testPostConstructMethodWhichThrowsExceptionThrowingException() {
        boolean thrown = false;
        try {
            this.factory.createModel((Object)this.resource, FailingPostConstructModel.class);
        }
        catch (PostConstructException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Post-construct"));
            Assertions.assertEquals((Object)"FAIL", (Object)e.getCause().getMessage());
            thrown = true;
        }
        Assertions.assertTrue((boolean)thrown);
    }
}

