/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter.impl.node;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.resource.filter.impl.Visitor;

public class Node {
    public String text;
    public Node leftNode;
    public Node rightNode;
    public List<Node> children = Collections.emptyList();
    public int kind;

    public Node(int kind, String text) {
        this.kind = kind;
        this.text = text;
    }

    public Node(int kind, List<Node> children) {
        this.kind = kind;
        this.children = children;
    }

    public Node(int kind, String text, List<Node> children) {
        this.kind = kind;
        this.text = text;
        this.children = children;
    }

    public Node(int kind, String operator, Node leftValue, Node rightValue) {
        this.kind = kind;
        this.text = operator;
        this.leftNode = leftValue;
        this.rightNode = rightValue;
    }

    public String getText() {
        return this.text;
    }

    public Node getLeftNode() {
        return this.leftNode;
    }

    public Node getRightNode() {
        return this.rightNode;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public int getKind() {
        return this.kind;
    }

    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return this.text + this.children.stream().map(Node::toString).collect(Collectors.joining(this.text, "(", ")"));
    }

    public <R> List<R> visitChildren(Visitor<R> visitor) {
        return this.children.stream().map(child -> child.accept(visitor)).collect(Collectors.toList());
    }
}

