/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.xml.TextValue;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BufferedStringValue
implements TextValue {
    private static final Logger log = LoggerFactory.getLogger(BufferedStringValue.class);
    private static final int MAX_BUFFER_SIZE = 65536;
    private StringWriter buffer = new StringWriter();
    private long length = 0L;
    private File tmpFile = null;
    private Writer writer = null;
    private final NamePathMapper namePathMapper;
    private final ValueFactory valueFactory;
    private final boolean base64;

    protected BufferedStringValue(ValueFactory valueFactory, NamePathMapper namePathMapper, boolean base64) {
        this.namePathMapper = namePathMapper;
        this.valueFactory = valueFactory;
        this.base64 = base64;
    }

    public long length() throws IOException {
        return this.length;
    }

    @Override
    public String getString() {
        try {
            return this.retrieveString();
        }
        catch (IOException e) {
            log.error("could not retrieve string value", (Throwable)e);
            return "";
        }
    }

    private String retrieveString() throws IOException {
        String value = this.retrieve();
        if (this.base64) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Base64.decode(value, (OutputStream)out);
            value = new String(out.toByteArray(), "UTF-8");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieve() throws IOException {
        if (this.buffer != null) {
            return this.buffer.toString();
        }
        if (this.tmpFile != null) {
            this.writer.close();
            if (this.tmpFile.length() > Integer.MAX_VALUE) {
                throw new IOException("size of value is too big, use reader()");
            }
            StringBuilder sb = new StringBuilder((int)this.length);
            char[] chunk = new char[8192];
            try (Reader reader = this.openReader();){
                int read;
                while ((read = reader.read(chunk)) > -1) {
                    sb.append(chunk, 0, read);
                }
            }
            return sb.toString();
        }
        throw new IOException("this instance has already been disposed");
    }

    private Reader openReader() throws IOException {
        return new InputStreamReader(this.openStream(), "UTF-8");
    }

    private InputStream openStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.tmpFile));
    }

    private InputStream stream() throws IOException {
        if (this.base64) {
            return new Base64ReaderInputStream(this.reader());
        }
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.retrieve().getBytes("UTF-8"));
        }
        if (this.tmpFile != null) {
            this.writer.close();
            return this.openStream();
        }
        throw new IOException("this instance has already been disposed");
    }

    public Reader reader() throws IOException {
        if (this.buffer != null) {
            return new StringReader(this.retrieve());
        }
        if (this.tmpFile != null) {
            this.writer.close();
            return this.openReader();
        }
        throw new IOException("this instance has already been disposed");
    }

    public void append(char[] chars, int start, int len) throws IOException {
        if (this.buffer != null) {
            if (this.length + (long)len > 65536L) {
                TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                this.tmpFile = fileFactory.createTransientFile("txt", null, null);
                BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(this.tmpFile));
                this.writer = new OutputStreamWriter((OutputStream)fout, "UTF-8");
                this.writer.write(this.buffer.toString());
                this.writer.write(chars, start, len);
                this.buffer = null;
            } else {
                this.buffer.write(chars, start, len);
            }
        } else if (this.tmpFile != null) {
            this.writer.write(chars, start, len);
        } else {
            throw new IOException("this instance has already been disposed");
        }
        this.length += (long)len;
    }

    public void close() throws IOException {
        if (this.buffer == null) {
            if (this.tmpFile != null) {
                this.writer.close();
            } else {
                throw new IOException("this instance has already been disposed");
            }
        }
    }

    @Override
    public Value getValue(int targetType) throws RepositoryException {
        try {
            if (targetType == 2) {
                return this.valueFactory.createValue(this.stream());
            }
            String jcrValue = this.retrieveString();
            if (targetType == 7) {
                jcrValue = this.namePathMapper.getOakName(jcrValue);
            } else if (targetType == 8) {
                jcrValue = this.namePathMapper.getOakPath(jcrValue);
            }
            return this.valueFactory.createValue(jcrValue, targetType);
        }
        catch (IOException e) {
            throw new RepositoryException("failed to retrieve serialized value", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.buffer != null) {
            this.buffer = null;
        } else if (this.tmpFile != null) {
            try {
                this.writer.close();
                this.tmpFile.delete();
                this.tmpFile = null;
                this.writer = null;
            }
            catch (IOException e) {
                log.warn("Problem disposing property value", (Throwable)e);
            }
        } else {
            log.warn("this instance has already been disposed");
        }
    }

    private static class Base64ReaderInputStream
    extends InputStream {
        private static final int BUFFER_SIZE = 1024;
        private final char[] chars = new char[1024];
        private final ByteArrayOutputStream out;
        private final Reader reader;
        private int pos;
        private int remaining;
        private byte[] buffer;

        public Base64ReaderInputStream(Reader reader) {
            this.reader = reader;
            this.out = new ByteArrayOutputStream(1024);
        }

        private void fillBuffer() throws IOException {
            int len = this.reader.read(this.chars, 0, 1024);
            if (len < 0) {
                this.remaining = -1;
                return;
            }
            Base64.decode(this.chars, 0, len, this.out);
            this.buffer = this.out.toByteArray();
            this.pos = 0;
            this.remaining = this.buffer.length;
            this.out.reset();
        }

        @Override
        public int read() throws IOException {
            if (this.remaining == 0) {
                this.fillBuffer();
            }
            if (this.remaining < 0) {
                return -1;
            }
            --this.remaining;
            return this.buffer[this.pos++] & 0xFF;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

