/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.scheduler.cluster.k8s.PodTerminating;
import org.apache.spark.scheduler.cluster.k8s.PodUnknown;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ExecutorPodsSnapshot$
implements Logging,
Serializable {
    public static final ExecutorPodsSnapshot$ MODULE$ = new ExecutorPodsSnapshot$();
    private static boolean shouldCheckAllContainers;
    private static String sparkContainerName;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        sparkContainerName = Constants$.MODULE$.DEFAULT_EXECUTOR_CONTAINER_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean shouldCheckAllContainers() {
        return shouldCheckAllContainers;
    }

    private void shouldCheckAllContainers_$eq(boolean x$1) {
        shouldCheckAllContainers = x$1;
    }

    private String sparkContainerName() {
        return sparkContainerName;
    }

    private void sparkContainerName_$eq(String x$1) {
        sparkContainerName = x$1;
    }

    public ExecutorPodsSnapshot apply(Seq<Pod> executorPods, long fullSnapshotTs) {
        return new ExecutorPodsSnapshot(this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toStatesByExecutorId(executorPods), fullSnapshotTs);
    }

    public ExecutorPodsSnapshot apply() {
        return new ExecutorPodsSnapshot((Map<Object, ExecutorPodState>)Predef$.MODULE$.Map().empty(), 0L);
    }

    public void setShouldCheckAllContainers(boolean watchAllContainers) {
        this.shouldCheckAllContainers_$eq(watchAllContainers);
    }

    public void setSparkContainerName(String containerName) {
        this.sparkContainerName_$eq(containerName);
    }

    public Map<Object, ExecutorPodState> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsSnapshot$$toStatesByExecutorId(Seq<Pod> executorPods) {
        return ((IterableOnceOps)executorPods.flatMap((Function1 & Serializable)pod -> {
            None$ none$;
            block7: {
                String string;
                block6: {
                    string = (String)pod.getMetadata().getLabels().get(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL());
                    switch (string == null ? 0 : string.hashCode()) {
                        case 0: {
                            if (string == null) {
                                break;
                            }
                            break block6;
                        }
                        case 2058803564: {
                            if ("EXECID".equals(string)) {
                                break;
                            }
                            break block6;
                        }
                        default: {
                            break block6;
                        }
                    }
                    none$ = None$.MODULE$;
                    break block7;
                }
                none$ = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(string))), (Object)MODULE$.toState((Pod)pod)));
            }
            return none$;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ExecutorPodState toState(Pod pod) {
        Product product;
        block15: {
            Product product2;
            block16: {
                block14: {
                    if (!this.isDeleted(pod)) break block14;
                    product = new PodDeleted(pod);
                    break block15;
                }
                String phase = pod.getStatus().getPhase().toLowerCase(Locale.ROOT);
                String string = phase;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1918581026: {
                        if (!"terminating".equals(string)) break;
                        product2 = new PodTerminating(pod);
                        break block16;
                    }
                    case -1281977283: {
                        if (!"failed".equals(string)) break;
                        product2 = new PodFailed(pod);
                        break block16;
                    }
                    case -682587753: {
                        if (!"pending".equals(string)) break;
                        product2 = new PodPending(pod);
                        break block16;
                    }
                    case 945734241: {
                        if (!"succeeded".equals(string)) break;
                        product2 = new PodSucceeded(pod);
                        break block16;
                    }
                    case 1550783935: {
                        Product product3;
                        if (!"running".equals(string)) break;
                        if (this.shouldCheckAllContainers() && "Never".equals(pod.getSpec().getRestartPolicy()) && pod.getStatus().getContainerStatuses().stream().map(cs -> cs.getState().getTerminated()).anyMatch(t -> t != null && !BoxesRunTime.equalsNumObject((Number)t.getExitCode(), (Object)BoxesRunTime.boxToInteger((int)0)))) {
                            product3 = new PodFailed(pod);
                        } else {
                            Product product4;
                            Option sparkContainerExitCode = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsSnapshot$.$anonfun$toState$3(x$2))).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getState())).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getTerminated())).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getExitCode())).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$3)));
                            Option option = sparkContainerExitCode;
                            if (option instanceof Some) {
                                Product product5;
                                int t2;
                                Some some = (Some)option;
                                int n = t2 = BoxesRunTime.unboxToInt((Object)some.value());
                                switch (n) {
                                    case 0: {
                                        product5 = new PodSucceeded(pod);
                                        break;
                                    }
                                    default: {
                                        product5 = new PodFailed(pod);
                                        break;
                                    }
                                }
                                product4 = product5;
                            } else {
                                product4 = new PodRunning(pod);
                            }
                            product3 = product4;
                        }
                        product2 = product3;
                        break block16;
                    }
                }
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(50).append("Received unknown phase ").append(phase).append(" for executor pod with name").toString()).append(new StringBuilder(15).append(" ").append(pod.getMetadata().getName()).append(" in namespace ").append(pod.getMetadata().getNamespace()).toString()).toString());
                product2 = new PodUnknown(pod);
            }
            product = product2;
        }
        return product;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDeleted(Pod pod) {
        if (pod.getMetadata().getDeletionTimestamp() == null) return false;
        if (pod.getStatus() == null) return true;
        if (pod.getStatus().getPhase() == null) return true;
        String string = pod.getStatus().getPhase().toLowerCase(Locale.ROOT);
        String string2 = "terminating";
        if (string == null) {
            if (string2 == null) return false;
        } else if (string.equals(string2)) return false;
        String string3 = pod.getStatus().getPhase().toLowerCase(Locale.ROOT);
        String string4 = "running";
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    public ExecutorPodsSnapshot apply(Map<Object, ExecutorPodState> executorPods, long fullSnapshotTs) {
        return new ExecutorPodsSnapshot(executorPods, fullSnapshotTs);
    }

    public Option<Tuple2<Map<Object, ExecutorPodState>, Object>> unapply(ExecutorPodsSnapshot x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.executorPods(), (Object)BoxesRunTime.boxToLong((long)x$0.fullSnapshotTs())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExecutorPodsSnapshot$.class);
    }

    public static final /* synthetic */ boolean $anonfun$toState$3(ContainerStatus x$2) {
        String string = x$2.getName();
        String string2 = MODULE$.sparkContainerName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private ExecutorPodsSnapshot$() {
    }
}

