/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.columnar.ArrayColumnAccessor;
import org.apache.spark.sql.execution.columnar.BasicColumnAccessor;
import org.apache.spark.sql.execution.columnar.BinaryColumnAccessor;
import org.apache.spark.sql.execution.columnar.BooleanColumnAccessor;
import org.apache.spark.sql.execution.columnar.ByteColumnAccessor;
import org.apache.spark.sql.execution.columnar.ColumnAccessor;
import org.apache.spark.sql.execution.columnar.CompactDecimalColumnAccessor;
import org.apache.spark.sql.execution.columnar.DecimalColumnAccessor;
import org.apache.spark.sql.execution.columnar.DoubleColumnAccessor;
import org.apache.spark.sql.execution.columnar.FloatColumnAccessor;
import org.apache.spark.sql.execution.columnar.IntColumnAccessor;
import org.apache.spark.sql.execution.columnar.LongColumnAccessor;
import org.apache.spark.sql.execution.columnar.MapColumnAccessor;
import org.apache.spark.sql.execution.columnar.NativeColumnAccessor;
import org.apache.spark.sql.execution.columnar.NullColumnAccessor;
import org.apache.spark.sql.execution.columnar.ShortColumnAccessor;
import org.apache.spark.sql.execution.columnar.StringColumnAccessor;
import org.apache.spark.sql.execution.columnar.StructColumnAccessor;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.runtime.BoxedUnit;

public final class ColumnAccessor$ {
    public static final ColumnAccessor$ MODULE$ = new ColumnAccessor$();

    public ColumnAccessor apply(DataType dataType, ByteBuffer buffer) {
        BasicColumnAccessor basicColumnAccessor;
        block17: {
            DataType dataType2;
            while (true) {
                ByteBuffer buf = buffer.order(ByteOrder.nativeOrder());
                boolean bl = false;
                DecimalType decimalType = null;
                dataType2 = dataType;
                if (NullType$.MODULE$.equals(dataType2)) {
                    basicColumnAccessor = new NullColumnAccessor(buf);
                    break block17;
                }
                if (BooleanType$.MODULE$.equals(dataType2)) {
                    basicColumnAccessor = new BooleanColumnAccessor(buf);
                    break block17;
                }
                if (ByteType$.MODULE$.equals(dataType2)) {
                    basicColumnAccessor = new ByteColumnAccessor(buf);
                    break block17;
                }
                if (ShortType$.MODULE$.equals(dataType2)) {
                    basicColumnAccessor = new ShortColumnAccessor(buf);
                    break block17;
                }
                boolean bl2 = IntegerType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof YearMonthIntervalType);
                if (bl2) {
                    basicColumnAccessor = new IntColumnAccessor(buf);
                    break block17;
                }
                boolean bl3 = LongType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : (TimestampNTZType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof DayTimeIntervalType));
                if (bl3) {
                    basicColumnAccessor = new LongColumnAccessor(buf);
                    break block17;
                }
                if (FloatType$.MODULE$.equals(dataType2)) {
                    basicColumnAccessor = new FloatColumnAccessor(buf);
                    break block17;
                }
                if (DoubleType$.MODULE$.equals(dataType2)) {
                    basicColumnAccessor = new DoubleColumnAccessor(buf);
                    break block17;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    basicColumnAccessor = new StringColumnAccessor(buf);
                    break block17;
                }
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    basicColumnAccessor = new BinaryColumnAccessor(buf);
                    break block17;
                }
                if (dataType2 instanceof DecimalType) {
                    bl = true;
                    decimalType = (DecimalType)dataType2;
                    if (decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                        basicColumnAccessor = new CompactDecimalColumnAccessor(buf, decimalType);
                        break block17;
                    }
                }
                if (bl) {
                    basicColumnAccessor = new DecimalColumnAccessor(buf, decimalType);
                    break block17;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    basicColumnAccessor = new StructColumnAccessor(buf, structType);
                    break block17;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType2;
                    basicColumnAccessor = new ArrayColumnAccessor(buf, arrayType);
                    break block17;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    basicColumnAccessor = new MapColumnAccessor(buf, mapType);
                    break block17;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            throw QueryExecutionErrors$.MODULE$.notSupportTypeError(dataType2);
        }
        return basicColumnAccessor;
    }

    public void decompress(ColumnAccessor columnAccessor, WritableColumnVector columnVector, int numRows) {
        ColumnAccessor columnAccessor2 = columnAccessor;
        if (!(columnAccessor2 instanceof NativeColumnAccessor)) {
            throw QueryExecutionErrors$.MODULE$.notSupportNonPrimitiveTypeError();
        }
        NativeColumnAccessor nativeColumnAccessor = (NativeColumnAccessor)columnAccessor2;
        nativeColumnAccessor.decompress(columnVector, numRows);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void decompress(byte[] array, WritableColumnVector columnVector, DataType dataType, int numRows) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        ColumnAccessor columnAccessor = this.apply(dataType, byteBuffer);
        this.decompress(columnAccessor, columnVector, numRows);
    }

    private ColumnAccessor$() {
    }
}

