/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.QueryContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u0011Ug!B!C\u0003\u0003i\u0005\"\u00024\u0001\t\u00039\u0007\"\u00026\u0001\r\u0003Y\u0007\"B=\u0001\t\u0003Q\bbBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002|\u0001!\t!! \t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u00037\u0004A\u0011AAo\u0011\u001d\t9\u000f\u0001C\u0001\u0003SDq!a:\u0001\t\u0003\t\u0019\u0010C\u0005\u0003\u0004\u0001\t\n\u0011\"\u0001\u0003\u0006!9!\u0011\u0004\u0001\u0005\u0002\tm\u0001\u0002\u0003B\u0016\u0001\u0011E!I!\f\t\u000f\tU\u0002\u0001\"\u0001\u00038\u00199!1\t\u0001\u0001\u0005\n\u0015\u0003B\u00024\u0014\t\u0003\u00119\u0006C\u0004\u0003^M!\tBa\u0018\t\u000f\tE4\u0003\"\u0005\u0003t!9!qO\n\u0005B\te\u0004b\u0002BL'\u0011\u0005#\u0011\u0014\u0005\b\u0005K\u001bB\u0011\tBT\u0011\u001d\u0011\tl\u0005C!\u0005gCqAa1\u0014\t\u0003\u0012)\rC\u0004\u0003PN!\tB!5\t\u000f\tU7\u0003\"\u0011\u0003X\"9!1\\\n\u0005B\tu\u0007B\u0004Bs'A\u0005\u0019\u0011!A\u0005\n\t\u001d8\u0011\u0002\u0005\b\u0007\u0017\u0001A\u0011AB\u0007\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+Aqaa\b\u0001\t\u0003\u0019\t\u0003C\u0004\u0004J\u0001!\taa\u0013\t\u000f\r\u001d\u0004\u0001\"\u0001\u0004j!91Q\u000f\u0001\u0005\u0002\r]\u0004bBBA\u0001\u0011\u000511\u0011\u0005\b\u0007\u0017\u0003A\u0011ABG\u0011\u001d\u0019y\t\u0001C\u0001\u0007#Cqaa$\u0001\t\u0003\u0019\t\u000bC\u0004\u00042\u0002!\taa-\t\u000f\r\u001d\u0007\u0001\"\u0001\u0004J\"911\u001b\u0001\u0005\u0002\rU\u0007bBBq\u0001\u0011\u000511\u001d\u0005\b\u0007S\u0004A\u0011ABv\u0011\u001d\u0019)\u0010\u0001C\u0001\u0007oDq\u0001\"\u0001\u0001\t\u0003!\u0019\u0001C\u0004\u0005\n\u0001!\t\u0001b\u0003\t\u000f\u0011E\u0001\u0001\"\u0001\u0005\u0014!9Aq\u0003\u0001\u0005\u0002\u0011e\u0001b\u0002C\u0010\u0001\u0011\u0005A\u0011\u0005\u0005\b\t\u0003\u0002A\u0011\u0001C\"\u0011\u001d!i\u0005\u0001C\u0001\t\u001fBq\u0001\"\u0016\u0001\t\u0003!9\u0006C\u0004\u0005n\u0001!\t\u0001b\u001c\t\u000f\u0011\u0015\u0005\u0001\"\u0001\u0005\b\"9A1\u0013\u0001\u0005\u0002\u0011U\u0005b\u0002CN\u0001\u0011\u0005AQ\u0014\u0005\b\tO\u0003A\u0011\u0001CU\u0011\u001d!Y\u000b\u0001C\u0001\tSCq\u0001\",\u0001\t\u0003!I\u000bC\u0004\u00050\u0002!\t\u0001\"-\t\u000f\u0011\r\u0007\u0001\"\u0001\u0005F\nY!\n\u001a2d\t&\fG.Z2u\u0015\t\u0019E)\u0001\u0003kI\n\u001c'BA#G\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011\u0003\u0002\u0001O)\u0002\u0004\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA+^\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z\u0019\u00061AH]8pizJ\u0011!U\u0005\u00039B\u000bq\u0001]1dW\u0006<W-\u0003\u0002_?\na1+\u001a:jC2L'0\u00192mK*\u0011A\f\u0015\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u001a\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003K\n\u0014q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002QB\u0011\u0011\u000eA\u0007\u0002\u0005\u0006I1-\u00198IC:$G.\u001a\u000b\u0003Y>\u0004\"aT7\n\u00059\u0004&a\u0002\"p_2,\u0017M\u001c\u0005\u0006a\n\u0001\r!]\u0001\u0004kJd\u0007C\u0001:w\u001d\t\u0019H\u000f\u0005\u0002X!&\u0011Q\u000fU\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002v!\u0006yq-\u001a;DCR\fG._:u)f\u0004X\rF\u0005|\u0003\u0013\t\u0019\"a\u0006\u0002\u001cA\u0019q\n @\n\u0005u\u0004&AB(qi&|g\u000eE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA)A\u0003usB,7/\u0003\u0003\u0002\b\u0005\u0005!\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005-1\u00011\u0001\u0002\u000e\u000591/\u001d7UsB,\u0007cA(\u0002\u0010%\u0019\u0011\u0011\u0003)\u0003\u0007%sG\u000f\u0003\u0004\u0002\u0016\r\u0001\r!]\u0001\tif\u0004XMT1nK\"9\u0011\u0011D\u0002A\u0002\u00055\u0011\u0001B:ju\u0016Dq!!\b\u0004\u0001\u0004\ty\"\u0001\u0002nIB\u0019q0!\t\n\t\u0005\r\u0012\u0011\u0001\u0002\u0010\u001b\u0016$\u0018\rZ1uC\n+\u0018\u000e\u001c3fe\u0006Yq-\u001a;K\t\n\u001bE+\u001f9f)\u0011\tI#!\r\u0011\t=c\u00181\u0006\t\u0004S\u00065\u0012bAA\u0018\u0005\nA!\n\u001a2d)f\u0004X\r\u0003\u0004\u00024\u0011\u0001\rA`\u0001\u0003IR\fqdY8om\u0016\u0014HOS1wCRKW.Z:uC6\u0004Hk\u001c+j[\u0016\u001cH/Y7q)\u0011\tI$a\u0012\u0011\t\u0005m\u00121I\u0007\u0003\u0003{Q1!RA \u0015\t\t\t%\u0001\u0003kCZ\f\u0017\u0002BA#\u0003{\u0011\u0011\u0002V5nKN$\u0018-\u001c9\t\u000f\u0005%S\u00011\u0001\u0002:\u0005\tA\u000fK\u0003\u0006\u0003\u001b\nI\u0006\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019FR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003#\u0012QaU5oG\u0016\f#!a\u0017\u0002\u000bMrSG\f\u0019\u0002E\r|gN^3si*\u000bg/\u0019+j[\u0016\u001cH/Y7q)>$\u0016.\\3ti\u0006l\u0007O\u0014+[)\u0011\t\t'!\u001c\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KRA!a\u001a\u0002@\u0005!A/[7f\u0013\u0011\tY'!\u001a\u0003\u001b1{7-\u00197ECR,G+[7f\u0011\u001d\tIE\u0002a\u0001\u0003sASABA'\u00033\n!eY8om\u0016\u0014H\u000fV5nKN$\u0018-\u001c9O)j#vNS1wCRKW.Z:uC6\u0004H\u0003BA\u001d\u0003kBq!a\u001e\b\u0001\u0004\t\t'A\u0002mIRDSaBA'\u00033\nqc\u0019:fCR,7i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0015\t\u0005}\u00141\u0012\t\b\u001f\u0006\u0005\u0015QBAC\u0013\r\t\u0019\t\u0015\u0002\n\rVt7\r^5p]F\u0002B!a\u000f\u0002\b&!\u0011\u0011RA\u001f\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\b\u0003\u001bC\u0001\u0019AAH\u0003\u001dy\u0007\u000f^5p]N\u0004B!!%\u0002\u001e6\u0011\u00111\u0013\u0006\u0004\u0007\u0006U%\u0002BAL\u00033\u000b1\u0002Z1uCN|WO]2fg*\u0019\u00111\u0014#\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BAP\u0003'\u00131B\u0013#C\u0007>\u0003H/[8og\"*\u0001\"!\u0014\u0002$\u0006\u0012\u0011QU\u0001\u0006g9\u001ad\u0006M\u0001\u0010cV|G/Z%eK:$\u0018NZ5feR\u0019\u0011/a+\t\r\u00055\u0016\u00021\u0001r\u0003\u001d\u0019w\u000e\u001c(b[\u0016\f1b\u0019:fCR,G+\u00192mKRQ\u00111WA]\u0003\u0007\f9-a3\u0011\u0007=\u000b),C\u0002\u00028B\u0013A!\u00168ji\"9\u00111\u0018\u0006A\u0002\u0005u\u0016!C:uCR,W.\u001a8u!\u0011\tY$a0\n\t\u0005\u0005\u0017Q\b\u0002\n'R\fG/Z7f]RDa!!2\u000b\u0001\u0004\t\u0018!\u0003;bE2,g*Y7f\u0011\u0019\tIM\u0003a\u0001c\u0006I1\u000f\u001e:TG\",W.\u0019\u0005\b\u0003\u001bS\u0001\u0019AAg!\u0011\t\t*a4\n\t\u0005E\u00171\u0013\u0002\u0013\u0015\u0012\u00147m\u00149uS>t7/\u00138Xe&$X-A\nhKR$\u0016M\u00197f\u000bbL7\u000f^:Rk\u0016\u0014\u0018\u0010F\u0002r\u0003/Da!!7\f\u0001\u0004\t\u0018!\u0002;bE2,\u0017AD4fiN\u001b\u0007.Z7b#V,'/\u001f\u000b\u0004c\u0006}\u0007BBAm\u0019\u0001\u0007\u0011\u000fK\u0003\r\u0003\u001b\n\u0019/\t\u0002\u0002f\u0006)!GL\u0019/a\u0005\u0001r-\u001a;UeVt7-\u0019;f#V,'/\u001f\u000b\u0004c\u0006-\bBBAm\u001b\u0001\u0007\u0011\u000fK\u0003\u000e\u0003\u001b\ny/\t\u0002\u0002r\u0006)!GL\u001a/aQ)\u0011/!>\u0002x\"1\u0011\u0011\u001c\bA\u0002ED\u0011\"!?\u000f!\u0003\u0005\r!a?\u0002\u000f\r\f7oY1eKB\u0019q\n 7)\u000b9\ti%a@\"\u0005\t\u0005\u0011!\u0002\u001a/i9\u0002\u0014AG4fiR\u0013XO\\2bi\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0004U\u0011\tYP!\u0003,\u0005\t-\u0001\u0003\u0002B\u0007\u0005+i!Aa\u0004\u000b\t\tE!1C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0015Q\u0013\u0011\u00119Ba\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006cK\u001a|'/\u001a$fi\u000eDGCBAZ\u0005;\u0011\t\u0003C\u0004\u0003 A\u0001\r!!\"\u0002\u0015\r|gN\\3di&|g\u000eC\u0004\u0003$A\u0001\rA!\n\u0002\u0015A\u0014x\u000e]3si&,7\u000fE\u0003s\u0005O\t\u0018/C\u0002\u0003*a\u00141!T1q\u0003%)7oY1qKN\u000bH\u000eF\u0002r\u0005_AaA!\r\u0012\u0001\u0004\t\u0018!\u0002<bYV,\u0007&B\t\u0002N\u0005=\u0018\u0001D2p[BLG.\u001a,bYV,G\u0003\u0002B\u001d\u0005\u007f\u00012a\u0014B\u001e\u0013\r\u0011i\u0004\u0015\u0002\u0004\u0003:L\bb\u0002B\u0019%\u0001\u0007!\u0011\b\u0015\u0006%\u00055\u0013q\u001e\u0002\u000f\u0015\u0012\u00135iU)M\u0005VLG\u000eZ3s'\r\u0019\"q\t\t\u0005\u0005\u0013\u0012\u0019&\u0004\u0002\u0003L)!!Q\nB(\u0003\u0011)H/\u001b7\u000b\u0007\tEC)A\u0005d_:tWm\u0019;pe&!!Q\u000bB&\u0005Y1&'\u0012=qe\u0016\u001c8/[8o'Fc%)^5mI\u0016\u0014HC\u0001B-!\r\u0011YfE\u0007\u0002\u0001\u0005\u0001\u0012N\u001c9viR{7+\u0015'O_\n{w\u000e\u001c\u000b\u0004c\n\u0005\u0004b\u0002B2+\u0001\u0007!QM\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0005O\u0012i'\u0004\u0002\u0003j)!!1\u000eB(\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\t=$\u0011\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00059sK\u0012L7-\u0019;f)>Le\u000e^*R\u0019R\u0019\u0011O!\u001e\t\r\t\rd\u00031\u0001r\u000311\u0018n]5u\u0019&$XM]1m)\r\t(1\u0010\u0005\b\u0005{:\u0002\u0019\u0001B@\u0003\u001da\u0017\u000e^3sC2\u0004DA!!\u0003\fB1!q\rBB\u0005\u000fKAA!\"\u0003j\t9A*\u001b;fe\u0006d\u0007\u0003\u0002BE\u0005\u0017c\u0001\u0001\u0002\u0007\u0003\u000e\nm\u0014\u0011!A\u0001\u0006\u0003\u0011yIA\u0002`IE\nBA!%\u0003:A\u0019qJa%\n\u0007\tU\u0005KA\u0004O_RD\u0017N\\4\u0002'YL7/\u001b;OC6,GMU3gKJ,gnY3\u0015\u0007E\u0014Y\nC\u0004\u0003\u001eb\u0001\rAa(\u0002\u00119\fW.\u001a3SK\u001a\u0004BAa\u001a\u0003\"&!!1\u0015B5\u00059q\u0015-\\3e%\u00164WM]3oG\u0016\f\u0011B^5tSR\u001c\u0015m\u001d;\u0015\u000bE\u0014IK!,\t\r\t-\u0016\u00041\u0001r\u0003\u0005a\u0007B\u0002BX3\u0001\u0007a0\u0001\u0005eCR\fG+\u001f9f\u0003A1\u0018n]5u'Fce)\u001e8di&|g\u000eF\u0003r\u0005k\u0013I\f\u0003\u0004\u00038j\u0001\r!]\u0001\tMVt7MT1nK\"9!1\u0018\u000eA\u0002\tu\u0016AB5oaV$8\u000f\u0005\u0003P\u0005\u007f\u000b\u0018b\u0001Ba!\n)\u0011I\u001d:bs\u00061b/[:ji\u0006;wM]3hCR,g)\u001e8di&|g\u000eF\u0004r\u0005\u000f\u0014IM!4\t\r\t]6\u00041\u0001r\u0011\u0019\u0011Ym\u0007a\u0001Y\u0006Q\u0011n\u001d#jgRLgn\u0019;\t\u000f\tm6\u00041\u0001\u0003>\u0006\u0019B-[1mK\u000e$h)\u001e8di&|gNT1nKR\u0019\u0011Oa5\t\r\t]F\u00041\u0001r\u000311\u0018n]5u\u001fZ,'\u000f\\1z)\r\t(\u0011\u001c\u0005\b\u0005wk\u0002\u0019\u0001B_\u0003%1\u0018n]5u)JLW\u000eF\u0003r\u0005?\u0014\u0019\u000f\u0003\u0004\u0003bz\u0001\r!]\u0001\nI&\u0014Xm\u0019;j_:DqAa/\u001f\u0001\u0004\u0011i,\u0001\ntkB,'\u000f\n<jg&$H*\u001b;fe\u0006dG\u0003\u0002Bu\u0005g\u0004BAa;\u0003r6\u0011!Q\u001e\u0006\u0005\u0005_\fy$\u0001\u0003mC:<\u0017bA<\u0003n\"I!Q_\u0010\u0002\u0002\u0003\u0007!q_\u0001\u0004q\u0012\n\u0004\u0007\u0002B}\u0005{\u0004bAa\u001a\u0003\u0004\nm\b\u0003\u0002BE\u0005{$ABa@\u0003t\u0006\u0005\t\u0011!B\u0001\u0007\u0003\u0011!a\u0010\u0019\u0012\t\tE51\u0001\t\u0005\u0005W\u001c)!\u0003\u0003\u0004\b\t5(AB(cU\u0016\u001cG/\u0003\u0003\u0003x\tM\u0013aE5t'V\u0004\bo\u001c:uK\u00124UO\\2uS>tGc\u00017\u0004\u0010!1!q\u0017\u0011A\u0002EDS\u0001IA'\u0003G\u000b\u0011cY8na&dW-\u0012=qe\u0016\u001c8/[8o)\u0011\u00199b!\u0007\u0011\u0007=c\u0018\u000fC\u0004\u0004\u001c\u0005\u0002\rA!\u001a\u0002\t\u0015D\bO\u001d\u0015\u0006C\u00055\u00131U\u0001\u0011G>l\u0007/\u001b7f\u0003\u001e<'/Z4bi\u0016$Baa\u0006\u0004$!91Q\u0005\u0012A\u0002\r\u001d\u0012aC1hO\u001a+hn\u0019;j_:\u0004Ba!\u000b\u000405\u001111\u0006\u0006\u0005\u0007[\u0011I'A\u0005bO\u001e\u0014XmZ1uK&!1\u0011GB\u0016\u00055\tum\u001a:fO\u0006$XMR;oG\"Z!e!\u000e\u0004<\ru2\u0011IB\"!\ry5qG\u0005\u0004\u0007s\u0001&A\u00033faJ,7-\u0019;fI\u00069Q.Z:tC\u001e,\u0017EAB \u0003\u0011+8/\u001a\u0011pe\u001et\u0013\r]1dQ\u0016t3\u000f]1sW:\u001a\u0018\u000f\u001c\u0018kI\n\u001cgF\u00133cG\u0012K\u0017\r\\3di:\u001aw.\u001c9jY\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011j]N$X-\u00193/\u0003\u0015\u0019\u0018N\\2fC\t\u0019)%A\u00034]Qr\u0003\u0007K\u0003#\u0003\u001b\n\u0019+A\u0005gk:\u001cG/[8ogV\u00111Q\n\t\u0006+\u000e=31K\u0005\u0004\u0007#z&aA*fcB1qj!\u0016r\u00073J1aa\u0016Q\u0005\u0019!V\u000f\u001d7feA!11LB2\u001b\t\u0019iF\u0003\u0003\u0004J\r}#\u0002BB1\u0005\u001f\nqaY1uC2|w-\u0003\u0003\u0004f\ru#aD+oE>,h\u000e\u001a$v]\u000e$\u0018n\u001c8\u0002\u0019\r\u0014X-\u0019;f'\u000eDW-\\1\u0015\u0011\u0005M61NB7\u0007cBq!a/%\u0001\u0004\ti\f\u0003\u0004\u0004p\u0011\u0002\r!]\u0001\u0007g\u000eDW-\\1\t\r\rMD\u00051\u0001r\u0003\u001d\u0019w.\\7f]R\fQb]2iK6\f7/\u0012=jgR\u001cHc\u00027\u0004z\ru4q\u0010\u0005\b\u0007w*\u0003\u0019AAC\u0003\u0011\u0019wN\u001c8\t\u000f\u00055U\u00051\u0001\u0002\u0010\"11qN\u0013A\u0002E\f1\u0002\\5tiN\u001b\u0007.Z7bgR11QQBD\u0007\u0013\u0003Ra\u0014B`\u0005{Cqaa\u001f'\u0001\u0004\t)\tC\u0004\u0002\u000e\u001a\u0002\r!a$\u00021%\u001c8)Y:dC\u0012Lgn\u001a+sk:\u001c\u0017\r^3UC\ndW\r\u0006\u0002\u0002|\u0006Y!/\u001a8b[\u0016$\u0016M\u00197f)\u0015\t81SBL\u0011\u0019\u0019)\n\u000ba\u0001c\u0006Aq\u000e\u001c3UC\ndW\r\u0003\u0004\u0004\u001a\"\u0002\r!]\u0001\t]\u0016<H+\u00192mK\"Z\u0001f!\u000e\u0004<\ru5\u0011IA-C\t\u0019y*A\u001aQY\u0016\f7/\u001a\u0011pm\u0016\u0014(/\u001b3fAI,g.Y7f)\u0006\u0014G.\u001a\u0011nKRDw\u000e\u001a\u0011xSRD\u0007%\u001b3f]RLg-[3sgR)\u0011oa)\u0004.\"91QS\u0015A\u0002\r\u0015\u0006\u0003BBT\u0007Sk!aa\u0018\n\t\r-6q\f\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBBMS\u0001\u00071Q\u0015\u0015\u0006S\u00055\u0013\u0011L\u0001\u000bC2$XM\u001d+bE2,G\u0003\u0003B_\u0007k\u001b9la1\t\r\u0005\u0015'\u00061\u0001r\u0011\u001d\u0019IL\u000ba\u0001\u0007w\u000bqa\u00195b]\u001e,7\u000fE\u0003V\u0007\u001f\u001ai\f\u0005\u0003\u0004(\u000e}\u0016\u0002BBa\u0007?\u00121\u0002V1cY\u0016\u001c\u0005.\u00198hK\"91Q\u0019\u0016A\u0002\u00055\u0011A\u00043c\u001b\u0006TwN\u001d,feNLwN\\\u0001\u0012O\u0016$\u0018\t\u001a3D_2,XN\\)vKJLHcB9\u0004L\u000e57\u0011\u001b\u0005\u0007\u0003\u000b\\\u0003\u0019A9\t\r\r=7\u00061\u0001r\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u0005_[\u0003\u0019A9\u0002)\u001d,GOU3oC6,7i\u001c7v[:\fV/\u001a:z)%\t8q[Bm\u00077\u001cy\u000e\u0003\u0004\u0002F2\u0002\r!\u001d\u0005\u0007\u0007\u001fd\u0003\u0019A9\t\r\ruG\u00061\u0001r\u0003\u001dqWm\u001e(b[\u0016Dqa!2-\u0001\u0004\ti!\u0001\u000bhKR$U\r\\3uK\u000e{G.^7o#V,'/\u001f\u000b\u0006c\u000e\u00158q\u001d\u0005\u0007\u0003\u000bl\u0003\u0019A9\t\r\r=W\u00061\u0001r\u0003a9W\r^+qI\u0006$XmQ8mk6tG+\u001f9f#V,'/\u001f\u000b\bc\u000e58q^By\u0011\u0019\t)M\fa\u0001c\"11q\u001a\u0018A\u0002EDaaa=/\u0001\u0004\t\u0018a\u00038fo\u0012\u000bG/\u0019+za\u0016\fqdZ3u+B$\u0017\r^3D_2,XN\u001c(vY2\f'-\u001b7jif\fV/\u001a:z)\u001d\t8\u0011`B~\u0007{Da!!20\u0001\u0004\t\bBBBh_\u0001\u0007\u0011\u000f\u0003\u0004\u0004\u0000>\u0002\r\u0001\\\u0001\u000bSNtU\u000f\u001c7bE2,\u0017\u0001F4fiR\u000b'\r\\3D_6lWM\u001c;Rk\u0016\u0014\u0018\u0010F\u0003r\t\u000b!9\u0001\u0003\u0004\u0002ZB\u0002\r!\u001d\u0005\u0007\u0007g\u0002\u0004\u0019A9\u0002+\u001d,GoU2iK6\f7i\\7nK:$\u0018+^3ssR)\u0011\u000f\"\u0004\u0005\u0010!11qN\u0019A\u0002EDaaa\u001d2\u0001\u0004\t\u0018\u0001\u0007:f[>4XmU2iK6\f7i\\7nK:$\u0018+^3ssR\u0019\u0011\u000f\"\u0006\t\r\r=$\u00071\u0001r\u0003)!'o\u001c9TG\",W.\u0019\u000b\u0006c\u0012mAQ\u0004\u0005\u0007\u0007_\u001a\u0004\u0019A9\t\r\u0005e8\u00071\u0001m\u0003-\u0019'/Z1uK&sG-\u001a=\u0015\u0017E$\u0019\u0003b\n\u0005,\u0011EBq\b\u0005\u0007\tK!\u0004\u0019A9\u0002\u0013%tG-\u001a=OC6,\u0007b\u0002C\u0015i\u0001\u00071QU\u0001\u000bi\u0006\u0014G.Z%eK:$\bb\u0002C\u0017i\u0001\u0007AqF\u0001\bG>dW/\u001c8t!\u0015y%q\u0018BP\u0011\u001d!\u0019\u0004\u000ea\u0001\tk\t\u0011cY8mk6t7\u000f\u0015:pa\u0016\u0014H/[3t!!!9\u0004b\u000f\u0003 \u0012uRB\u0001C\u001d\u0015\u0011\u0011i%a\u0010\n\t\t%B\u0011\b\t\u0007\to!Y$]9\t\u000f\t\rB\u00071\u0001\u0005>\u0005Y\u0011N\u001c3fq\u0016C\u0018n\u001d;t)%aGQ\tC$\t\u0013\"Y\u0005C\u0004\u0004|U\u0002\r!!\"\t\r\u0011\u0015R\u00071\u0001r\u0011\u001d!I#\u000ea\u0001\u0007KCq!!$6\u0001\u0004\ty)A\u0005ee>\u0004\u0018J\u001c3fqR)\u0011\u000f\"\u0015\u0005T!1AQ\u0005\u001cA\u0002EDq\u0001\"\u000b7\u0001\u0004\u0019)+A\u0006mSN$\u0018J\u001c3fq\u0016\u001cH\u0003\u0003C-\tO\"I\u0007b\u001b\u0011\u000b=\u0013y\fb\u0017\u0011\t\u0011uC1M\u0007\u0003\t?RA\u0001\"\u0019\u0004`\u0005)\u0011N\u001c3fq&!AQ\rC0\u0005)!\u0016M\u00197f\u0013:$W\r\u001f\u0005\b\u0007w:\u0004\u0019AAC\u0011\u001d!Ic\u000ea\u0001\u0007KCq!!$8\u0001\u0004\ty)A\tdY\u0006\u001c8/\u001b4z\u000bb\u001cW\r\u001d;j_:$b\u0001\"\u001d\u0005z\u0011m\u0004\u0003\u0002C:\tkj\u0011\u0001R\u0005\u0004\to\"%!E!oC2L8/[:Fq\u000e,\u0007\u000f^5p]\"111\b\u001dA\u0002EDq\u0001\" 9\u0001\u0004!y(A\u0001f!\r)F\u0011Q\u0005\u0004\t\u0007{&!\u0003+ie><\u0018M\u00197f\u000399W\r\u001e'j[&$8\t\\1vg\u0016$2!\u001dCE\u0011\u001d!Y)\u000fa\u0001\t\u001b\u000bQ\u0001\\5nSR\u0004BAa;\u0005\u0010&!A\u0011\u0013Bw\u0005\u001dIe\u000e^3hKJ\fqbZ3u\u001f\u001a47/\u001a;DY\u0006,8/\u001a\u000b\u0004c\u0012]\u0005b\u0002CMu\u0001\u0007AQR\u0001\u0007_\u001a47/\u001a;\u0002-\u001d,GO\u00133cGN\u000bF*U;fef\u0014U/\u001b7eKJ$B\u0001b(\u0005&B\u0019\u0011\u000e\")\n\u0007\u0011\r&IA\nKI\n\u001c7+\u0015'Rk\u0016\u0014\u0018PQ;jY\u0012,'\u000fC\u0004\u0002\u000en\u0002\r!a$\u0002\u001bM,\b\u000f]8siNd\u0015.\\5u+\u0005a\u0017AD:vaB|'\u000f^:PM\u001a\u001cX\r^\u0001\u0014gV\u0004\bo\u001c:ugR\u000b'\r\\3TC6\u0004H.Z\u0001\u000fO\u0016$H+\u00192mKN\u000bW\u000e\u001d7f)\r\tH1\u0017\u0005\b\tk{\u0004\u0019\u0001C\\\u0003\u0019\u0019\u0018-\u001c9mKB!A\u0011\u0018C`\u001b\t!YL\u0003\u0003\u0005>\u0006U\u0015A\u0001<3\u0013\u0011!\t\rb/\u0003\u001fQ\u000b'\r\\3TC6\u0004H.Z%oM>\f\u0001eZ3u\rVdG._)vC2Lg-[3e#V|G/\u001a3UC\ndWMT1nKR\u0019\u0011\u000fb2\t\u000f\u0011%\u0007\t1\u0001\u0004&\u0006)\u0011\u000eZ3oi\"*\u0001)!\u0014\u0002Z!\u001a\u0001\u0001b4\u0011\t\u0005=C\u0011[\u0005\u0005\t'\f\tF\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public abstract class JdbcDialect
implements Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        return t;
    }

    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.fromJavaTimestampNoRebase(t));
    }

    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        long micros = DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt);
        return DateTimeUtils$.MODULE$.toJavaTimestampNoRebase(micros);
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public void createTable(Statement statement, String tableName, String strSchema, JdbcOptionsInWrite options) {
        String createTableOptions = options.createTableOptions();
        statement.executeUpdate(new StringBuilder(17).append("CREATE TABLE ").append(tableName).append(" (").append(strSchema).append(") ").append(createTableOptions).toString());
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT 1 FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        return value == null ? null : StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        } else if (object2 instanceof Instant) {
            Instant instant = (Instant)object2;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            object = new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(2).append("'").append(date).append("'").toString();
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        } else {
            object = value2;
        }
        return object;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return this.compileExpression((Expression)aggFunction);
    }

    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return package$.MODULE$.Nil();
    }

    public void createSchema(Statement statement, String schema, String comment) {
        block0: {
            String schemaCommentQuery = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment)) ? this.getSchemaCommentQuery(schema, comment) : comment;
            statement.executeUpdate(new StringBuilder(14).append("CREATE SCHEMA ").append(this.quoteIdentifier(schema)).toString());
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(comment))) break block0;
            statement.executeUpdate(schemaCommentQuery);
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String renameTable(Identifier oldTable, Identifier newTable) {
        return new StringBuilder(0).append(new StringBuilder(23).append("ALTER TABLE ").append(this.getFullyQualifiedQuotedTableName(oldTable)).append(" RENAME TO ").toString()).append(String.valueOf(this.getFullyQualifiedQuotedTableName(newTable))).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            ArrayBuilder arrayBuilder;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            } else if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            } else if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            } else if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                arrayBuilder = (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            } else {
                throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
            }
            return arrayBuilder;
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(0).append(new StringBuilder(30).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").toString()).append(new StringBuilder(1).append(" ").append(this.quoteIdentifier(newName)).toString()).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public String dropSchema(String schema, boolean cascade) {
        return cascade ? new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString() : new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, Identifier tableIdent) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$5();
        scala.collection.immutable.Map x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        QueryContext[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, (Option)x$2, x$5, x$6, x$7);
    }

    public String getLimitClause(Integer limit) {
        return Predef$.MODULE$.Integer2int(limit) > 0 ? new StringBuilder(6).append("LIMIT ").append(limit).toString() : "";
    }

    public String getOffsetClause(Integer offset) {
        return Predef$.MODULE$.Integer2int(offset) > 0 ? new StringBuilder(7).append("OFFSET ").append(offset).toString() : "";
    }

    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new JdbcSQLQueryBuilder(this, options);
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsOffset() {
        return false;
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public String getFullyQualifiedQuotedTableName(Identifier ident) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Object)ident.name(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> this.quoteIdentifier((String)colName), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable)() -> new StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options$1.url()).toString());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        private /* synthetic */ String super$visitLiteral(Literal x$1) {
            return super.visitLiteral(x$1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String inputToSQLNoBool(Expression input) {
            boolean bl = false;
            Predicate predicate = null;
            Expression expression = input;
            if (expression instanceof Predicate) {
                bl = true;
                predicate = (Predicate)expression;
                String string = predicate.name();
                String string2 = "ALWAYS_TRUE";
                if (string == null) {
                    if (string2 == null) return "1";
                } else if (string.equals(string2)) {
                    return "1";
                }
            }
            if (bl) {
                String string = predicate.name();
                String string3 = "ALWAYS_FALSE";
                if (string == null) {
                    if (string3 == null) return "0";
                } else if (string.equals(string3)) {
                    return "0";
                }
            }
            if (!bl) return super.inputToSQL(input);
            return this.predicateToIntSQL(this.inputToSQL((Expression)predicate));
        }

        public String predicateToIntSQL(String input) {
            return new StringBuilder(28).append("CASE WHEN ").append(input).append(" THEN 1 ELSE 0 END").toString();
        }

        public String visitLiteral(Literal<?> literal) {
            return (String)Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable)v -> this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(v, literal.dataType())).toString()).getOrElse((Function0 & Serializable)() -> this.super$visitLiteral(literal));
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())));
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable)x$1 -> x$1.databaseTypeDefinition()).getOrElse((Function0 & Serializable)() -> dataType.typeName());
            return new StringBuilder(10).append("CAST(").append(l).append(" AS ").append(databaseTypeDefinition).append(")").toString();
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                throw new UnsupportedOperationException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(" does not support function: ").append(funcName).toString());
            }
            return new StringBuilder(2).append(this.dialectFunctionName(funcName)).append("(").append(Predef$.MODULE$.wrapRefArray((Object[])inputs).mkString(", ")).append(")").toString();
        }

        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                throw new UnsupportedOperationException(new StringBuilder(38).append(this.getClass().getSimpleName()).append(" does not support aggregate function: ").append(funcName).toString());
            }
            return super.visitAggregateFunction(this.dialectFunctionName(funcName), isDistinct, inputs);
        }

        public String dialectFunctionName(String funcName) {
            return funcName;
        }

        public String visitOverlay(String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("OVERLAY")) {
                throw new UnsupportedOperationException(new StringBuilder(35).append(this.getClass().getSimpleName()).append(" does not support function: OVERLAY").toString());
            }
            return super.visitOverlay(inputs);
        }

        public String visitTrim(String direction, String[] inputs) {
            if (!this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("TRIM")) {
                throw new UnsupportedOperationException(new StringBuilder(32).append(this.getClass().getSimpleName()).append(" does not support function: TRIM").toString());
            }
            return super.visitTrim(direction, inputs);
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

