/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummaryImpl;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseMatrix$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BinaryLogisticBlockAggregator;
import org.apache.spark.ml.optim.aggregator.MultinomialLogisticBlockAggregator;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\rEc\u0001B\u0016-\u0001]B\u0001\"\u0016\u0001\u0003\u0006\u0004%\tE\u0016\u0005\t[\u0002\u0011\t\u0011)A\u0005/\")q\u000e\u0001C\u0001a\")q\u000e\u0001C\u0001m\")\u0001\u0010\u0001C\u0001s\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t\t\b\u0001C!\u0003gBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\t)\f\u0001C\u0005\u0003oC\u0011\"a2\u0001\u0001\u0004%I!!3\t\u0013\u0005E\u0007\u00011A\u0005\n\u0005M\u0007\u0002CAm\u0001\u0001\u0006K!a3\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\"A\u0011\u0011\u001e\u0001\u0005\u0012A\nY\u000fC\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!1\b\u0001\u0005\n\tu\u0002b\u0002B'\u0001\u0011%!q\n\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005GCqAa;\u0001\t\u0003\u0012ioB\u0004\u0004\u00041B\ta!\u0002\u0007\r-b\u0003\u0012AB\u0004\u0011\u0019yW\u0005\"\u0001\u0004&!91qE\u0013\u0005B\r%\u0002BCB\u0019K\t\u0007I\u0011\u0001\u0017\u00044!A1\u0011I\u0013!\u0002\u0013\u0019)\u0004C\u0005\u0004D\u0015\n\t\u0011\"\u0003\u0004F\t\u0011Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u0015\tic&\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005=\u0002\u0014AA7m\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7\u0001A\n\u0006\u0001a2\u0015j\u0014\t\u0006sib$iQ\u0007\u0002Y%\u00111\b\f\u0002\u0018!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jKJ\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u0018\u0002\r1Lg.\u00197h\u0013\t\teH\u0001\u0004WK\u000e$xN\u001d\t\u0003s\u0001\u0001\"!\u000f#\n\u0005\u0015c#a\u0006'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tIt)\u0003\u0002IY\tABj\\4jgRL7MU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0005)kU\"A&\u000b\u00051s\u0013\u0001B;uS2L!AT&\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mKB\u0011\u0001kU\u0007\u0002#*\u0011!\u000bM\u0001\tS:$XM\u001d8bY&\u0011A+\u0015\u0002\b\u0019><w-\u001b8h\u0003\r)\u0018\u000eZ\u000b\u0002/B\u0011\u0001,\u0019\b\u00033~\u0003\"AW/\u000e\u0003mS!\u0001\u0018\u001c\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0016!B:dC2\f\u0017B\u00011^\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001l\u0006fA\u0001fWB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eM\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00016h\u0005\u0015\u0019\u0016N\\2fC\u0005a\u0017!B\u0019/i9\u0002\u0014\u0001B;jI\u0002B3AA3l\u0003\u0019a\u0014N\\5u}Q\u0011!)\u001d\u0005\u0006+\u000e\u0001\ra\u0016\u0015\u0004c\u0016\\\u0007fA\u0002fi\u0006\nQ/A\u00032]Ir\u0003\u0007F\u0001CQ\r!Qm[\u0001\fg\u0016$(+Z4QCJ\fW\u000e\u0006\u0002{w6\t\u0001\u0001C\u0003}\u000b\u0001\u0007Q0A\u0003wC2,X\r\u0005\u0002\u007f\u007f6\tQ,C\u0002\u0002\u0002u\u0013a\u0001R8vE2,\u0007fA\u0003fi\u0006\u00112/\u001a;FY\u0006\u001cH/[2OKR\u0004\u0016M]1n)\rQ\u0018\u0011\u0002\u0005\u0006y\u001a\u0001\r! \u0015\u0004\r\u0015\\\u0017AC:fi6\u000b\u00070\u0013;feR\u0019!0!\u0005\t\rq<\u0001\u0019AA\n!\rq\u0018QC\u0005\u0004\u0003/i&aA%oi\"\u001aq!\u001a;\u0002\rM,G\u000fV8m)\rQ\u0018q\u0004\u0005\u0006y\"\u0001\r! \u0015\u0004\u0011\u0015\\\u0017aD:fi\u001aKG/\u00138uKJ\u001cW\r\u001d;\u0015\u0007i\f9\u0003\u0003\u0004}\u0013\u0001\u0007\u0011\u0011\u0006\t\u0004}\u0006-\u0012bAA\u0017;\n9!i\\8mK\u0006t\u0007fA\u0005fW\u0006I1/\u001a;GC6LG.\u001f\u000b\u0004u\u0006U\u0002\"\u0002?\u000b\u0001\u00049\u0006\u0006\u0002\u0006f\u0003s\t#!a\u000f\u0002\u000bIr\u0013G\f\u0019\u0002%M,Go\u0015;b]\u0012\f'\u000fZ5{CRLwN\u001c\u000b\u0004u\u0006\u0005\u0003B\u0002?\f\u0001\u0004\tI\u0003\u000b\u0003\fK\u0006\u0015\u0013EAA$\u0003\u0015\td&\u000e\u00181\u00031\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7e)\rQ\u0018Q\n\u0005\u0006y2\u0001\r! \u0015\u0005\u0019\u0015\f)%\u0001\u0007hKR$\u0006N]3tQ>dG-F\u0001~Q\u0011iQ-!\u0012\u0002\u0019M,GoV3jO\"$8i\u001c7\u0015\u0007i\fY\u0006C\u0003}\u001d\u0001\u0007q\u000b\u000b\u0003\u000fK\u0006}\u0013EAA1\u0003\u0015\tdF\u000e\u00181\u00035\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7egR\u0019!0a\u001a\t\rq|\u0001\u0019AA5!\u0011q\u00181N?\n\u0007\u00055TLA\u0003BeJ\f\u0017\u0010\u000b\u0003\u0010K\u0006\u0015\u0013!D4fiRC'/Z:i_2$7/\u0006\u0002\u0002j!\"\u0001#ZA#\u0003M\u0019X\r^!hOJ,w-\u0019;j_:$U\r\u001d;i)\rQ\u00181\u0010\u0005\u0007yF\u0001\r!a\u0005)\tE)\u0017\u0011H\u0001\u001dg\u0016$Hj\\<fe\n{WO\u001c3t\u001f:\u001cu.\u001a4gS\u000eLWM\u001c;t)\rQ\u00181\u0011\u0005\u0007yJ\u0001\r!!\"\u0011\u0007u\n9)C\u0002\u0002\nz\u0012a!T1ue&D\b\u0006\u0002\nf\u0003\u001b\u000b#!a$\u0002\u000bIr#G\f\u0019\u00029M,G/\u00169qKJ\u0014u.\u001e8eg>s7i\\3gM&\u001c\u0017.\u001a8ugR\u0019!0!&\t\rq\u001c\u0002\u0019AACQ\u0011\u0019R-!$\u00025M,G\u000fT8xKJ\u0014u.\u001e8eg>s\u0017J\u001c;fe\u000e,\u0007\u000f^:\u0015\u0007i\fi\nC\u0003})\u0001\u0007A\b\u000b\u0003\u0015K\u00065\u0015AG:fiV\u0003\b/\u001a:C_VtGm](o\u0013:$XM]2faR\u001cHc\u0001>\u0002&\")A0\u0006a\u0001y!\"Q#ZAG\u0003M\u0019X\r^'bq\ncwnY6TSj,\u0017J\\'C)\rQ\u0018Q\u0016\u0005\u0006yZ\u0001\r! \u0015\u0005-\u0015\f\t,\t\u0002\u00024\u0006)1GL\u0019/a\u0005i\u0013m]:feR\u0014u.\u001e8e\u0007>t7\u000f\u001e:bS:,Gm\u00149uS6L'0\u0019;j_:\u0004\u0016M]1ngZ\u000bG.\u001b3\u0015\r\u0005e\u0016qXAb!\rq\u00181X\u0005\u0004\u0003{k&\u0001B+oSRDq!!1\u0018\u0001\u0004\t\u0019\"\u0001\nok6\u001cu.\u001a4gS\u000eLWM\u001c;TKR\u001c\bbBAc/\u0001\u0007\u00111C\u0001\f]Vlg)Z1ukJ,7/A\bpaRLe.\u001b;jC2lu\u000eZ3m+\t\tY\r\u0005\u0003\u007f\u0003\u001b\u001c\u0015bAAh;\n1q\n\u001d;j_:\f1c\u001c9u\u0013:LG/[1m\u001b>$W\r\\0%KF$B!!/\u0002V\"I\u0011q[\r\u0002\u0002\u0003\u0007\u00111Z\u0001\u0004q\u0012\n\u0014\u0001E8qi&s\u0017\u000e^5bY6{G-\u001a7!\u0003=\u0019X\r^%oSRL\u0017\r\\'pI\u0016dGc\u0001>\u0002`\"1\u0011\u0011]\u000eA\u0002\r\u000bQ!\\8eK2DCaG3\u0002f\u0006\u0012\u0011q]\u0001\u0006g9\u001ad\u0006M\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004\u0007\u00065\bbBAx9\u0001\u0007\u0011\u0011_\u0001\bI\u0006$\u0018m]3ua\u0011\t\u0019Pa\u0001\u0011\r\u0005U\u00181`A\u0000\u001b\t\t9PC\u0002\u0002zB\n1a]9m\u0013\u0011\ti0a>\u0003\u000f\u0011\u000bG/Y:fiB!!\u0011\u0001B\u0002\u0019\u0001!AB!\u0002\u0002n\u0006\u0005\t\u0011!B\u0001\u0005\u000f\u00111a\u0018\u00132#\u0011\u0011IAa\u0004\u0011\u0007y\u0014Y!C\u0002\u0003\u000eu\u0013qAT8uQ&tw\rE\u0002\u007f\u0005#I1Aa\u0005^\u0005\r\te._\u0001\u0011G\",7m['vYRLgn\\7jC2$B!!\u000b\u0003\u001a!9!1D\u000fA\u0002\u0005M\u0011A\u00038v[\u000ec\u0017m]:fg\u0006Y1M]3bi\u0016lu\u000eZ3m)-\u0019%\u0011\u0005B\u0017\u0005_\u0011\u0019Da\u000e\t\u000f\u0005=h\u00041\u0001\u0003$A\"!Q\u0005B\u0015!\u0019\t)0a?\u0003(A!!\u0011\u0001B\u0015\t1\u0011YC!\t\u0002\u0002\u0003\u0005)\u0011\u0001B\u0004\u0005\ryFE\r\u0005\b\u00057q\u0002\u0019AA\n\u0011\u001d\u0011\tD\ba\u0001\u0003\u000b\u000b\u0011cY8fM\u001aL7-[3oi6\u000bGO]5y\u0011\u0019\u0011)D\ba\u0001y\u0005y\u0011N\u001c;fe\u000e,\u0007\u000f\u001e,fGR|'\u000fC\u0004\u0003:y\u0001\r!!\u001b\u0002!=\u0014'.Z2uSZ,\u0007*[:u_JL\u0018\u0001D2sK\u0006$XMQ8v]\u0012\u001cH\u0003\u0003B \u0005\u000b\u00129E!\u0013\u0011\u000fy\u0014\t%!\u001b\u0002j%\u0019!1I/\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011Yb\ba\u0001\u0003'Aq!!2 \u0001\u0004\t\u0019\u0002C\u0004\u0003L}\u0001\r!!\u001b\u0002\u0017\u0019,\u0017\r^;sKN\u001cF\u000fZ\u0001\u0010GJ,\u0017\r^3PaRLW.\u001b>feRa!\u0011\u000bB9\u0005g\u0012)Ha\u001e\u0003|AA!1\u000bB/\u0005C\u0012Y'\u0004\u0002\u0003V)!!q\u000bB-\u0003!y\u0007\u000f^5nSj,'B\u0001B.\u0003\u0019\u0011'/Z3{K&!!q\fB+\u0005M1\u0015N]:u\u001fJ$WM]'j]&l\u0017N_3s!\u0015\u0011\u0019Ga\u001a~\u001b\t\u0011)GC\u0002@\u00053JAA!\u001b\u0003f\tYA)\u001a8tKZ+7\r^8s!\u0019\u0011\u0019F!\u001c\u0003b%!!q\u000eB+\u00051!\u0015N\u001a4Gk:\u001cG/[8o\u0011\u001d\u0011Y\u0002\ta\u0001\u0003'Aq!!2!\u0001\u0004\t\u0019\u0002C\u0004\u0003L\u0001\u0002\r!!\u001b\t\u000f\te\u0004\u00051\u0001\u0002j\u0005YAn\\<fe\n{WO\u001c3t\u0011\u001d\u0011i\b\ta\u0001\u0003S\n1\"\u001e9qKJ\u0014u.\u001e8eg\u0006)2M]3bi\u0016Le.\u001b;jC2\u001cv\u000e\\;uS>tG\u0003\u0005BB\u0005\u0013\u0013YI!$\u0003\u0012\nM%Q\u0013BL!\ri$QQ\u0005\u0004\u0005\u000fs$a\u0003#f]N,W*\u0019;sSbDqAa\u0007\"\u0001\u0004\t\u0019\u0002C\u0004\u0002F\u0006\u0002\r!a\u0005\t\u000f\t=\u0015\u00051\u0001\u0002j\u0005I\u0001.[:u_\u001e\u0014\u0018-\u001c\u0005\b\u0005\u0017\n\u0003\u0019AA5\u0011\u001d\u0011I(\ta\u0001\u0003SBqA! \"\u0001\u0004\tI\u0007C\u0004\u0003\u001a\u0006\u0002\rAa'\u0002\u000b%t7\u000f\u001e:\u0011\u0007)\u0013i*C\u0002\u0003 .\u0013q\"\u00138tiJ,X.\u001a8uCRLwN\\\u0001\niJ\f\u0017N\\%na2$\"Ca\u0010\u0003&\n\u0005'Q\u0019Bd\u0005\u0017\u0014iM!5\u0003h\"9!q\u0015\u0012A\u0002\t%\u0016!C5ogR\fgnY3t!\u0019\u0011YK!-\u000366\u0011!Q\u0016\u0006\u0004\u0005_\u0003\u0014a\u0001:eI&!!1\u0017BW\u0005\r\u0011F\t\u0012\t\u0005\u0005o\u0013i,\u0004\u0002\u0003:*\u0019!1\u0018\u0018\u0002\u000f\u0019,\u0017\r^;sK&!!q\u0018B]\u0005!Ien\u001d;b]\u000e,\u0007B\u0002BbE\u0001\u0007Q0A\nbGR,\u0018\r\u001c\"m_\u000e\\7+\u001b>f\u0013:l%\tC\u0004\u0003L\t\u0002\r!!\u001b\t\u000f\t%'\u00051\u0001\u0002j\u0005aa-Z1ukJ,7/T3b]\"9!1\u0004\u0012A\u0002\u0005M\u0001b\u0002BhE\u0001\u0007\u0011\u0011N\u0001\u0010S:LG/[1m'>dW\u000f^5p]\"9!1\u001b\u0012A\u0002\tU\u0017A\u0004:fOVd\u0017M]5{CRLwN\u001c\t\u0006}\u00065'q\u001b\t\u0005\u00053\u0014\u0019/\u0004\u0002\u0003\\*!!Q\u001cBp\u0003\u0011awn]:\u000b\u0007\t\u0005h&A\u0003paRLW.\u0003\u0003\u0003f\nm'\u0001\u0005'3%\u0016<W\u000f\\1sSj\fG/[8o\u0011\u001d\u0011IO\ta\u0001\u0005#\n\u0011b\u001c9uS6L'0\u001a:\u0002\t\r|\u0007/\u001f\u000b\u0004\u0005\n=\bb\u0002ByG\u0001\u0007!1_\u0001\u0006Kb$(/\u0019\t\u0005\u0005k\u0014Y0\u0004\u0002\u0003x*\u0019!\u0011 \u0018\u0002\u000bA\f'/Y7\n\t\tu(q\u001f\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001a1%Z6)\u0007\u0001)G/\u0001\nM_\u001eL7\u000f^5d%\u0016<'/Z:tS>t\u0007CA\u001d&'\u001d)3\u0011BB\b\u0007+\u00012A`B\u0006\u0013\r\u0019i!\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\t)\u001b\tBQ\u0005\u0004\u0007'Y%!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0005\u0007/\u0019\t#\u0004\u0002\u0004\u001a)!11DB\u000f\u0003\tIwN\u0003\u0002\u0004 \u0005!!.\u0019<b\u0013\u0011\u0019\u0019c!\u0007\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\r\u0015\u0011\u0001\u00027pC\u0012$2AQB\u0016\u0011\u0019\u0019ic\na\u0001/\u0006!\u0001/\u0019;iQ\u00119S-a\u0018\u0002)M,\b\u000f]8si\u0016$g)Y7jYft\u0015-\\3t+\t\u0019)\u0004E\u0003\u007f\u0003W\u001a9\u0004\u0005\u0003\u0004:\r}RBAB\u001e\u0015\u0011\u0019id!\b\u0002\t1\fgnZ\u0005\u0004E\u000em\u0012!F:vaB|'\u000f^3e\r\u0006l\u0017\u000e\\=OC6,7\u000fI\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007\u000f\u0002Ba!\u000f\u0004J%!11JB\u001e\u0005\u0019y%M[3di\"\"Q%ZA0Q\u0011!S-a\u0018")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Option<LogisticRegressionModel> optInitialModel;
    private Param<String> family;
    private Param<Matrix> lowerBoundsOnCoefficients;
    private Param<Matrix> upperBoundsOnCoefficients;
    private Param<Vector> lowerBoundsOnIntercepts;
    private Param<Vector> upperBoundsOnIntercepts;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private DoubleParam threshold;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam elasticNetParam;
    private DoubleParam regParam;

    public static LogisticRegression load(String path) {
        return LogisticRegression$.MODULE$.load(path);
    }

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setFamily(String value) {
        return (LogisticRegression)this.set(this.family(), value);
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    public LogisticRegression setAggregationDepth(int value) {
        return (LogisticRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setLowerBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnCoefficients(), value);
    }

    public LogisticRegression setUpperBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.upperBoundsOnCoefficients(), value);
    }

    public LogisticRegression setLowerBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnIntercepts(), value);
    }

    public LogisticRegression setUpperBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.upperBoundsOnIntercepts(), value);
    }

    public LogisticRegression setMaxBlockSizeInMB(double value) {
        return (LogisticRegression)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    private void assertBoundConstrainedOptimizationParamsValid(int numCoefficientSets, int numFeatures) {
        block5: {
            if (this.isSet(this.lowerBoundsOnCoefficients())) {
                Predef$.MODULE$.require(this.$(this.lowerBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.lowerBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable)() -> new StringBuilder(194).append("The shape of LowerBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append(new StringBuilder(5).append("(").append(this.getLowerBoundsOnCoefficients().numRows()).append(", ").append(this.getLowerBoundsOnCoefficients().numCols()).append(").").toString()).toString());
            }
            if (this.isSet(this.upperBoundsOnCoefficients())) {
                Predef$.MODULE$.require(this.$(this.upperBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.upperBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable)() -> new StringBuilder(194).append("The shape of upperBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append(new StringBuilder(5).append("(").append(this.getUpperBoundsOnCoefficients().numRows()).append(", ").append(this.getUpperBoundsOnCoefficients().numCols()).append(").").toString()).toString());
            }
            if (this.isSet(this.lowerBoundsOnIntercepts())) {
                Predef$.MODULE$.require(this.$(this.lowerBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable)() -> new StringBuilder(97).append("The size of lowerBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of ").append(new StringBuilder(48).append("classes for multinomial regression, but found: ").append(this.getLowerBoundsOnIntercepts().size()).append(".").toString()).toString());
            }
            if (this.isSet(this.upperBoundsOnIntercepts())) {
                Predef$.MODULE$.require(this.$(this.upperBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable)() -> new StringBuilder(97).append("The size of upperBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of ").append(new StringBuilder(48).append("classes for multinomial regression, but found: ").append(this.getUpperBoundsOnIntercepts().size()).append(".").toString()).toString());
            }
            if (this.isSet(this.lowerBoundsOnCoefficients()) && this.isSet(this.upperBoundsOnCoefficients())) {
                Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnCoefficients()).toArray()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnCoefficients()).toArray()))), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$5(x))), (Function0 & Serializable)() -> new StringBuilder(103).append("LowerBoundsOnCoefficients should always be less than or equal to upperBoundsOnCoefficients, but found: ").append(new StringBuilder(30).append("lowerBoundsOnCoefficients = ").append(this.getLowerBoundsOnCoefficients()).append(", ").toString()).append(new StringBuilder(29).append("upperBoundsOnCoefficients = ").append(this.getUpperBoundsOnCoefficients()).append(".").toString()).toString());
            }
            if (!this.isSet(this.lowerBoundsOnIntercepts()) || !this.isSet(this.upperBoundsOnIntercepts())) break block5;
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnIntercepts()).toArray()))), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$7(x))), (Function0 & Serializable)() -> new StringBuilder(99).append("LowerBoundsOnIntercepts should always be less than or equal to upperBoundsOnIntercepts, but found: ").append(new StringBuilder(28).append("lowerBoundsOnIntercepts = ").append(this.getLowerBoundsOnIntercepts()).append(", ").toString()).append(new StringBuilder(27).append("upperBoundsOnIntercepts = ").append(this.getUpperBoundsOnIntercepts()).append(".").toString()).toString());
        }
    }

    private Option<LogisticRegressionModel> optInitialModel() {
        return this.optInitialModel;
    }

    private void optInitialModel_$eq(Option<LogisticRegressionModel> x$1) {
        this.optInitialModel = x$1;
    }

    public LogisticRegression setInitialModel(LogisticRegressionModel model) {
        this.optInitialModel_$eq((Option<LogisticRegressionModel>)new Some((Object)model));
        return this;
    }

    @Override
    public LogisticRegressionModel train(Dataset<?> dataset) {
        LogisticRegressionModel logisticRegressionModel;
        Object object = new Object();
        try {
            logisticRegressionModel = (LogisticRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
                None$ none$;
                double regParamL2;
                boolean isConstantLabel;
                boolean isMultinomial;
                int numCoefficientSets;
                int n;
                instr.logPipelineStage(this);
                instr.logDataset(dataset);
                instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.weightCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.probabilityCol(), this.regParam(), this.elasticNetParam(), this.standardization(), this.threshold(), this.thresholds(), this.maxIter(), this.tol(), this.fitIntercept(), this.maxBlockSizeInMB()}));
                StorageLevel storageLevel = dataset.storageLevel();
                StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Input instances will be standardized, blockified to blocks, and ").append("then cached during training. Be careful of double caching!").toString());
                }
                RDD instances = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkClassificationLabels(this.$(this.labelCol()), (Option<Object>)None$.MODULE$), DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol())), DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
                    double d;
                    double d2;
                    Object v;
                    block3: {
                        Row row;
                        block2: {
                            Some some;
                            row = x0$1;
                            if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(3) != 0) break block2;
                            Object l = ((SeqOps)some.get()).apply(0);
                            Object w = ((SeqOps)some.get()).apply(1);
                            v = ((SeqOps)some.get()).apply(2);
                            if (!(l instanceof Double)) break block2;
                            d2 = BoxesRunTime.unboxToDouble((Object)l);
                            if (!(w instanceof Double)) break block2;
                            d = BoxesRunTime.unboxToDouble((Object)w);
                            if (v instanceof Vector) break block3;
                        }
                        throw new MatchError((Object)row);
                    }
                    Vector vector = (Vector)v;
                    Instance instance = new Instance(d2, d, vector);
                    return instance;
                }, ClassTag$.MODULE$.apply(Instance.class)).setName("training instances");
                Tuple2<SummarizerBuffer, MultiClassSummarizer> tuple2 = Summarizer$.MODULE$.getClassificationSummarizers((RDD<Instance>)instances, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), (Seq<String>)((Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std", "count"}))));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
                MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
                Tuple2 tuple23 = tuple22;
                SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple23._1();
                MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
                int numFeatures = summarizer2.mean().size();
                double[] histogram = labelSummarizer2.histogram();
                long numInvalid = labelSummarizer2.countInvalid();
                int numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
                Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                    int n3 = n2;
                    Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(33).append("Specified number of classes ").append(n3).append(" was ").toString()).append(new StringBuilder(39).append("less than the number of unique labels ").append(histogram.length).append(".").toString()).toString());
                    n = n3;
                } else {
                    if (!None$.MODULE$.equals(option)) {
                        throw new MatchError(option);
                    }
                    n = histogram.length;
                }
                int numClasses = n;
                if (numInvalid != 0L) {
                    String msg = new StringBuilder(0).append(new StringBuilder(44).append("Classification labels should be in [0 to ").append(numClasses - 1).append("]. ").toString()).append(new StringBuilder(22).append("Found ").append(numInvalid).append(" invalid labels.").toString()).toString();
                    instr.logError((Function0<String>)(Function0 & Serializable)() -> msg);
                    throw new SparkException(msg);
                }
                instr.logNumClasses(numClasses);
                instr.logNumFeatures(numFeatures);
                instr.logNumExamples(summarizer2.count());
                instr.logNamedValue("lowestLabelWeight", Predef$.MODULE$.wrapDoubleArray(labelSummarizer2.histogram()).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toString());
                instr.logNamedValue("highestLabelWeight", Predef$.MODULE$.wrapDoubleArray(labelSummarizer2.histogram()).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toString());
                instr.logSumOfWeights(summarizer2.weightSum());
                double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
                if (actualBlockSizeInMB == 0.0) {
                    actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                    Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                    instr.logNamedValue("actualBlockSizeInMB", Double.toString(actualBlockSizeInMB));
                }
                int n4 = numCoefficientSets = (isMultinomial = this.checkMultinomial(numClasses)) ? numClasses : 1;
                if (this.usingBoundConstrainedOptimization()) {
                    this.assertBoundConstrainedOptimizationParamsValid(numCoefficientSets, numFeatures);
                }
                if (this.isDefined(this.thresholds())) {
                    Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable)() -> new StringBuilder(67).append(this.getClass().getSimpleName()).append(".train() called with non-matching numClasses and thresholds.length.").append(new StringBuilder(40).append(" numClasses=").append(numClasses).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString()).toString());
                }
                boolean bl = isConstantLabel = ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.doubleArrayOps(histogram), (Function1)(JFunction1.mcZD.sp & Serializable)x$2 -> x$2 != 0.0) == 1;
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel && !this.usingBoundConstrainedOptimization()) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("All labels are the same value and fitIntercept=true, so the ").append("coefficients will be zeros. Training is not needed.").toString());
                    int constantLabelIndex = Vectors$.MODULE$.dense(histogram).argmax();
                    Matrix coefMatrix = new SparseMatrix(numCoefficientSets, numFeatures, new int[numCoefficientSets + 1], Array$.MODULE$.emptyIntArray(), Array$.MODULE$.emptyDoubleArray(), true).compressed();
                    Vector interceptVec = isMultinomial ? Vectors$.MODULE$.sparse(numClasses, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(constantLabelIndex, Double.POSITIVE_INFINITY)}))) : Vectors$.MODULE$.dense(numClasses == 2 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY, (Seq)Nil$.MODULE$);
                    throw new NonLocalReturnControl(object, (Object)this.createModel(dataset, numClasses, coefMatrix, interceptVec, new double[]{0.0}));
                }
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("All labels belong to a single class and fitIntercept=false. It's a ").append("dangerous ground, so the algorithm may not converge.").toString());
                }
                double[] featuresMean = summarizer2.mean().toArray();
                double[] featuresStd = summarizer2.std().toArray();
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable)i -> featuresStd[i] == 0.0 && featuresMean[i] != 0.0)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Fitting LogisticRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.");
                }
                if ((regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()))) != 0.0) {
                    JFunction1.mcDI.sp & Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable)j -> j >= 0 && j < numCoefficientSets * numFeatures ? featuresStd[j / numCoefficientSets] : 0.0;
                    JFunction1.mcZI.sp & Serializable shouldApply = (JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < numFeatures * numCoefficientSets;
                    none$ = new Some((Object)new L2Regularization(regParamL2, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ regularization = none$;
                Tuple2<double[], double[]> tuple24 = this.createBounds(numClasses, numFeatures, featuresStd);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                double[] lowerBounds = (double[])tuple24._1();
                double[] upperBounds = (double[])tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                Tuple2 tuple26 = tuple25;
                double[] lowerBounds2 = (double[])tuple26._1();
                double[] upperBounds2 = (double[])tuple26._2();
                FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer = this.createOptimizer(numClasses, numFeatures, featuresStd, lowerBounds2, upperBounds2);
                DenseMatrix initialSolution = this.createInitialSolution(numClasses, numFeatures, histogram, featuresStd, lowerBounds2, upperBounds2, (Instrumentation)instr);
                Tuple2<double[], double[]> tuple27 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, featuresStd, featuresMean, numClasses, initialSolution.toArray(), (Option<L2Regularization>)regularization, optimizer);
                if (tuple27 == null) {
                    throw new MatchError(tuple27);
                }
                double[] allCoefficients = (double[])tuple27._1();
                double[] objectiveHistory = (double[])tuple27._2();
                Tuple2 tuple28 = new Tuple2((Object)allCoefficients, (Object)objectiveHistory);
                Tuple2 tuple29 = tuple28;
                double[] allCoefficients2 = (double[])tuple29._1();
                double[] objectiveHistory2 = (double[])tuple29._2();
                if (allCoefficients2 == null) {
                    String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                    instr.logError((Function0<String>)(Function0 & Serializable)() -> msg);
                    throw new SparkException(msg);
                }
                DenseMatrix allCoefMatrix = new DenseMatrix(numCoefficientSets, numFeaturesPlusIntercept, allCoefficients2);
                DenseMatrix denseCoefficientMatrix = new DenseMatrix(numCoefficientSets, numFeatures, new double[numCoefficientSets * numFeatures], true);
                Vector interceptVec = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || !isMultinomial ? Vectors$.MODULE$.zeros(numCoefficientSets) : Vectors$.MODULE$.sparse(numCoefficientSets, (Seq)scala.package$.MODULE$.Seq().empty());
                allCoefMatrix.foreachActive((Function3 & Serializable)(classIndex, featureIndex, value) -> {
                    LogisticRegression.$anonfun$train$16(this, numFeatures, featuresStd, denseCoefficientMatrix, interceptVec, BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value));
                    return BoxedUnit.UNIT;
                });
                if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] centers = (double[])Array$.MODULE$.ofDim(numFeatures, (ClassTag)ClassTag$.MODULE$.Double());
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable)(x0$2, x1$1, x2$1) -> {
                        LogisticRegression.$anonfun$train$17(centers, BoxesRunTime.unboxToInt((Object)x0$2), BoxesRunTime.unboxToInt((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1));
                        return BoxedUnit.UNIT;
                    });
                    Predef$.MODULE$.wrapDoubleArray(centers).transform((Function1)(JFunction1.mcDD.sp & Serializable)x$5 -> x$5 / (double)numCoefficientSets);
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable)(x0$3, x1$2, x2$2) -> {
                        LogisticRegression.$anonfun$train$19(denseCoefficientMatrix, centers, BoxesRunTime.unboxToInt((Object)x0$3), BoxesRunTime.unboxToInt((Object)x1$2), BoxesRunTime.unboxToDouble((Object)x2$2));
                        return BoxedUnit.UNIT;
                    });
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] interceptArray = interceptVec.toArray();
                    double interceptMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(interceptArray).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)interceptArray.length;
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), interceptVec.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                        interceptArray$1[i] = interceptArray[i] - interceptMean;
                    });
                }
                throw new NonLocalReturnControl(object, (Object)this.createModel(dataset, numClasses, denseCoefficientMatrix.compressed(), interceptVec.compressed(), objectiveHistory2));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                logisticRegressionModel = (LogisticRegressionModel)ex.value();
            }
            throw ex;
        }
        return logisticRegressionModel;
    }

    private boolean checkMultinomial(int numClasses) {
        boolean bl;
        block5: {
            String string = this.$(this.family()).toLowerCase(Locale.ROOT);
            switch (string == null ? 0 : string.hashCode()) {
                case 3005871: {
                    if (!"auto".equals(string)) break;
                    bl = numClasses > 2;
                    break block5;
                }
                case 508210817: {
                    if (!"multinomial".equals(string)) break;
                    bl = true;
                    break block5;
                }
                case 950395663: {
                    if (!"binomial".equals(string)) break;
                    Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0 & Serializable)() -> new StringBuilder(0).append("Binomial family only supports 1 or 2 ").append(new StringBuilder(27).append("outcome classes but found ").append(numClasses).append(".").toString()).toString());
                    bl = false;
                    break block5;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(20).append("Unsupported family: ").append(string).toString());
        }
        return bl;
    }

    private LogisticRegressionModel createModel(Dataset<?> dataset, int numClasses, Matrix coefficientMatrix, Vector interceptVector, double[] objectiveHistory) {
        LogisticRegressionModel model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficientMatrix, interceptVector, numClasses, this.checkMultinomial(numClasses)), this.copyValues$default$2());
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = model.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        LogisticRegressionSummaryImpl logRegSummary = numClasses <= 2 ? new BinaryLogisticRegressionTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName, objectiveHistory) : new LogisticRegressionTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName, objectiveHistory);
        return (LogisticRegressionModel)model.setSummary((Option<LogisticRegressionTrainingSummary>)new Some((Object)logRegSummary));
    }

    private Tuple2<double[], double[]> createBounds(int numClasses, int numFeatures, double[] featuresStd) {
        Tuple2 tuple2;
        boolean isMultinomial = this.checkMultinomial(numClasses);
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        int numCoefficientSets = isMultinomial ? numClasses : 1;
        int numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
        if (this.usingBoundConstrainedOptimization()) {
            double[] lowerBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.NEGATIVE_INFINITY, (ClassTag)ClassTag$.MODULE$.Double());
            double[] upperBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable)() -> Double.POSITIVE_INFINITY, (ClassTag)ClassTag$.MODULE$.Double());
            boolean isSetLowerBoundsOnCoefficients = this.isSet(this.lowerBoundsOnCoefficients());
            boolean isSetUpperBoundsOnCoefficients = this.isSet(this.upperBoundsOnCoefficients());
            boolean isSetLowerBoundsOnIntercepts = this.isSet(this.lowerBoundsOnIntercepts());
            boolean isSetUpperBoundsOnIntercepts = this.isSet(this.upperBoundsOnIntercepts());
            for (int i = 0; i < numCoeffsPlusIntercepts; ++i) {
                int coefficientSetIndex = i % numCoefficientSets;
                int featureIndex = i / numCoefficientSets;
                if (featureIndex < numFeatures) {
                    if (isSetLowerBoundsOnCoefficients) {
                        lowerBounds[i] = this.$(this.lowerBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex) * featuresStd[featureIndex];
                    }
                    if (!isSetUpperBoundsOnCoefficients) continue;
                    upperBounds[i] = this.$(this.upperBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex) * featuresStd[featureIndex];
                    continue;
                }
                if (isSetLowerBoundsOnIntercepts) {
                    lowerBounds[i] = this.$(this.lowerBoundsOnIntercepts()).apply(coefficientSetIndex);
                }
                if (!isSetUpperBoundsOnIntercepts) continue;
                upperBounds[i] = this.$(this.upperBoundsOnIntercepts()).apply(coefficientSetIndex);
            }
            tuple2 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
        } else {
            tuple2 = new Tuple2(null, null);
        }
        return tuple2;
    }

    private FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> createOptimizer(int numClasses, int numFeatures, double[] featuresStd, double[] lowerBounds, double[] upperBounds) {
        Object object;
        int numCoefficientSets;
        boolean isMultinomial = this.checkMultinomial(numClasses);
        double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
        int n = numCoefficientSets = isMultinomial ? numClasses : 1;
        if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0) {
            object = lowerBounds != null && upperBounds != null ? new LBFGSB(DenseVector$.MODULE$.apply((Object)lowerBounds), DenseVector$.MODULE$.apply((Object)upperBounds), BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7()) : new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
        } else {
            boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
            object = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, numCoefficientSets, standardizationParam, regParamL1, featuresStd), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
        }
        return object;
    }

    private DenseMatrix createInitialSolution(int numClasses, int numFeatures, double[] histogram, double[] featuresStd, double[] lowerBounds, double[] upperBounds, Instrumentation instr) {
        boolean bl;
        boolean isMultinomial = this.checkMultinomial(numClasses);
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        int numCoefficientSets = isMultinomial ? numClasses : 1;
        int numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
        DenseMatrix initialCoefWithInterceptMatrix = DenseMatrix$.MODULE$.zeros(numCoefficientSets, numFeaturesPlusIntercept);
        Option<LogisticRegressionModel> option = this.optInitialModel();
        if (option instanceof Some) {
            boolean modelIsValid;
            Some some = (Some)option;
            LogisticRegressionModel _initialModel = (LogisticRegressionModel)some.value();
            Matrix providedCoefs = _initialModel.coefficientMatrix();
            boolean bl2 = modelIsValid = providedCoefs.numRows() == numCoefficientSets && providedCoefs.numCols() == numFeatures && _initialModel.interceptVector().size() == numCoefficientSets && _initialModel.getFitIntercept() == BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()));
            if (!modelIsValid) {
                instr.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append("Initial coefficients will be ignored! Its dimensions ").append(new StringBuilder(23).append("(").append(providedCoefs.numRows()).append(", ").append(providedCoefs.numCols()).append(") did not match the ").toString()).append(new StringBuilder(18).append("expected size (").append(numCoefficientSets).append(", ").append(numFeatures).append(")").toString()).toString());
            }
            bl = modelIsValid;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        boolean initialModelIsValid = bl;
        if (initialModelIsValid) {
            Matrix providedCoef = ((LogisticRegressionModel)this.optInitialModel().get()).coefficientMatrix();
            providedCoef.foreachActive((Function3 & Serializable)(classIndex, featureIndex, value) -> {
                initialCoefWithInterceptMatrix.update(BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value) * featuresStd[BoxesRunTime.unboxToInt((Object)featureIndex)]);
                return BoxedUnit.UNIT;
            });
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                ((LogisticRegressionModel)this.optInitialModel().get()).interceptVector().foreachNonZero((Function2)(JFunction2.mcVID.sp & Serializable)(classIndex, value) -> initialCoefWithInterceptMatrix.update(classIndex, numFeatures, value));
            }
        } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial) {
            double[] rawIntercepts = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(histogram), (Function1)(JFunction1.mcDD.sp & Serializable)x -> package$.MODULE$.log1p(x), (ClassTag)ClassTag$.MODULE$.Double());
            double rawMean = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(rawIntercepts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rawIntercepts.length;
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.doubleArrayOps(rawIntercepts)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> initialCoefWithInterceptMatrix.update(i, numFeatures, rawIntercepts[i] - rawMean));
        } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            initialCoefWithInterceptMatrix.update(0, numFeatures, package$.MODULE$.log(histogram[1] / histogram[0]));
        }
        if (this.usingBoundConstrainedOptimization()) {
            for (int i2 = 0; i2 < numCoeffsPlusIntercepts; ++i2) {
                int coefficientSetIndex = i2 % numCoefficientSets;
                int featureIndex2 = i2 / numCoefficientSets;
                if (initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex2) < lowerBounds[i2]) {
                    initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex2, lowerBounds[i2]);
                    continue;
                }
                if (!(initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex2) > upperBounds[i2])) continue;
                initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex2, upperBounds[i2]);
            }
        }
        return initialCoefWithInterceptMatrix;
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double[] featuresStd, double[] featuresMean, int numClasses, double[] initialSolution, Option<L2Regularization> regularization, FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> optimizer) {
        double[] solution;
        RDDLossFunction costFun;
        RDDLossFunction rDDLossFunction;
        boolean multinomial = this.checkMultinomial(numClasses);
        boolean fitWithMean = !(!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || this.isSet(this.lowerBoundsOnIntercepts()) && !ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray()), (Function1)(JFunction1.mcZD.sp & Serializable)x$7 -> RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(x$7))) || this.isSet(this.upperBoundsOnIntercepts()) && !ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.upperBoundsOnIntercepts()).toArray()), (Function1)(JFunction1.mcZD.sp & Serializable)x$8 -> RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(x$8))));
        int numFeatures = featuresStd.length;
        double[] inverseStd = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(featuresStd), (Function1)(JFunction1.mcDD.sp & Serializable)std -> std != 0.0 ? 1.0 / std : 0.0, (ClassTag)ClassTag$.MODULE$.Double());
        double[] scaledMean = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> inverseStd[i] * featuresMean[i], (ClassTag)ClassTag$.MODULE$.Double());
        Broadcast bcInverseStd = instances.context().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = instances.context().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD scaled = instances.mapPartitions((Function1 & Serializable)iter -> {
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()), (double[])bcInverseStd.value(), false, true);
            return iter.map((Function1 & Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance == null) {
                    throw new MatchError((Object)instance);
                }
                double label = instance.label();
                double weight = instance.weight();
                Vector vec = instance.features();
                Instance instance2 = new Instance(label, weight, (Vector)func.apply((Object)vec));
                return instance2;
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)scaled, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(new StringBuilder(34).append(this.uid()).append(": training blocks (blockSizeInMB=").append(actualBlockSizeInMB).append(")").toString());
        if (multinomial) {
            Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$9 -> new MultinomialLogisticBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), fitWithMean, (Broadcast<Vector>)x$9);
            rDDLossFunction = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(MultinomialLogisticBlockAggregator.class));
        } else {
            Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$10 -> new BinaryLogisticBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), fitWithMean, (Broadcast<Vector>)x$10);
            rDDLossFunction = costFun = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(BinaryLogisticBlockAggregator.class));
        }
        if (fitWithMean) {
            if (multinomial) {
                double[] adapt = (double[])Array$.MODULE$.ofDim(numClasses, (ClassTag)ClassTag$.MODULE$.Double());
                BLAS$.MODULE$.javaBLAS().dgemv("N", numClasses, numFeatures, 1.0, initialSolution, numClasses, scaledMean, 1, 0.0, adapt, 1);
                BLAS$.MODULE$.javaBLAS().daxpy(numClasses, 1.0, adapt, 0, 1, initialSolution, numClasses * numFeatures, 1);
            } else {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, initialSolution, 1, scaledMean, 1);
                initialSolution[numFeatures] = initialSolution[numFeatures] + adapt;
            }
        }
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector((ClassTag)ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialSolution));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcInverseStd.destroy();
        bcScaledMean.destroy();
        double[] dArray = solution = state == null ? null : ((DenseVector)state.x()).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
        if (fitWithMean && solution != null) {
            if (multinomial) {
                double[] adapt = (double[])Array$.MODULE$.ofDim(numClasses, (ClassTag)ClassTag$.MODULE$.Double());
                BLAS$.MODULE$.javaBLAS().dgemv("N", numClasses, numFeatures, 1.0, solution, numClasses, scaledMean, 1, 0.0, adapt, 1);
                BLAS$.MODULE$.javaBLAS().daxpy(numClasses, -1.0, adapt, 0, 1, solution, numClasses * numFeatures, 1);
            } else {
                double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, solution, 1, scaledMean, 1);
                solution[numFeatures] = solution[numFeatures] - adapt;
            }
        }
        return new Tuple2((Object)solution, arrayBuilder.result());
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$5(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$7(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    public static final /* synthetic */ void $anonfun$train$16(LogisticRegression $this, int numFeatures$1, double[] featuresStd$1, DenseMatrix denseCoefficientMatrix$1, Vector interceptVec$1, int classIndex, int featureIndex, double value) {
        block1: {
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)$this.$($this.fitIntercept())) && featureIndex == numFeatures$1;
            if (!isIntercept && featuresStd$1[featureIndex] != 0.0) {
                denseCoefficientMatrix$1.update(classIndex, featureIndex, value / featuresStd$1[featureIndex]);
            }
            if (!isIntercept) break block1;
            interceptVec$1.toArray()[classIndex] = value;
        }
    }

    public static final /* synthetic */ void $anonfun$train$17(double[] centers$1, int x0$2, int x1$1, double x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        centers$1[j] = centers$1[j] + v;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$train$19(DenseMatrix denseCoefficientMatrix$1, double[] centers$1, int x0$3, int x1$2, double x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)BoxesRunTime.boxToInteger((int)x1$2), (Object)BoxesRunTime.boxToDouble((double)x2$2));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        denseCoefficientMatrix$1.update(i, j, v - centers$1[j]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final Function1 regParamL1Fun$1(int numFeatures$2, int numCoefficientSets$2, boolean standardizationParam$1, double regParamL1$1, double[] featuresStd$2) {
        return (JFunction1.mcDI.sp & Serializable)index -> {
            int featureIndex;
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && index >= numFeatures$2 * numCoefficientSets$2;
            return isIntercept ? 0.0 : (standardizationParam$1 ? regParamL1$1 : (featuresStd$2[featureIndex = index / numCoefficientSets$2] != 0.0 ? regParamL1$1 / featuresStd$2[featureIndex] : 0.0));
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LogisticRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.optInitialModel = None$.MODULE$;
        Statics.releaseFence();
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

