/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001B\u0013'\u0001EB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tE\u0014\u0005\tK\u0002\u0011\t\u0011)A\u0005\u001f\")q\r\u0001C\u0001Q\")q\r\u0001C\u0001[\"9q\u000e\u0001b\u0001\n\u0003\u0001\bB\u0002<\u0001A\u0003%\u0011\u000fC\u0003y\u0001\u0011\u0005a\nC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\n\u0003K\u0001!\u0019!C\u0003\u0003OA\u0001\"!\r\u0001A\u00035\u0011\u0011\u0006\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bB\u0011\"a\u0013\u0001\u0005\u0004%)!a\n\t\u0011\u0005=\u0003\u0001)A\u0007\u0003SAq!a\u0015\u0001\t\u0003\t9\u0004C\u0004\u0002X\u0001!\t!!\u0017\t\u0013\u0005}\u0003A1A\u0005\u0006\u0005\u001d\u0002\u0002CA2\u0001\u0001\u0006i!!\u000b\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u00028!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\tI\r\u0001C!\u0003\u0017Dq!!6\u0001\t\u0003\n9\u000eC\u0004\u0002f\u0002!\t%a:\b\u000f\u00055h\u0005#\u0001\u0002p\u001a1QE\nE\u0001\u0003cDaaZ\u0010\u0005\u0002\t=\u0001\"\u0003B\t?\t\u0007I\u0011\u0002B\n\u0011!\u0011)c\bQ\u0001\n\tU\u0001b\u0002B\u0014?\u0011\u0005#\u0011\u0006\u0005\n\u0005ky\u0012\u0011!C\u0005\u0005o\u0011\u0011%T;mi&\u001cG.Y:t\u00072\f7o]5gS\u000e\fG/[8o\u000bZ\fG.^1u_JT!a\n\u0015\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002*U\u0005\u0011Q\u000e\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u00011c\u0002\u00013my\nEi\u0012\t\u0003gQj\u0011AJ\u0005\u0003k\u0019\u0012\u0011\"\u0012<bYV\fGo\u001c:\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014AB:iCJ,GM\u0003\u0002<Q\u0005)\u0001/\u0019:b[&\u0011Q\b\u000f\u0002\u0011\u0011\u0006\u001c\bK]3eS\u000e$\u0018n\u001c8D_2\u0004\"aN \n\u0005\u0001C$a\u0003%bg2\u000b'-\u001a7D_2\u0004\"a\u000e\"\n\u0005\rC$\u0001\u0004%bg^+\u0017n\u001a5u\u0007>d\u0007CA\u001cF\u0013\t1\u0005HA\tICN\u0004&o\u001c2bE&d\u0017\u000e^=D_2\u0004\"\u0001S&\u000e\u0003%S!A\u0013\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003\u0019&\u0013Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-A\u0002vS\u0012,\u0012a\u0014\t\u0003!fs!!U,\u0011\u0005I+V\"A*\u000b\u0005Q\u0003\u0014A\u0002\u001fs_>$hHC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAV+\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-VQ\r\tQl\u0019\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A*\n!\"\u00198o_R\fG/[8o\u0013\t\u0011wLA\u0003TS:\u001cW-I\u0001e\u0003\u0015\td&\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\ti6-\u0001\u0004=S:LGO\u0010\u000b\u0003S*\u0004\"a\r\u0001\t\u000b5\u001b\u0001\u0019A()\u0007)l6\rK\u0002\u0004;\u000e$\u0012!\u001b\u0015\u0004\tu\u001b\u0017AC7fiJL7MT1nKV\t\u0011\u000fE\u0002sg>k\u0011AO\u0005\u0003ij\u0012Q\u0001U1sC6D3!B/d\u0003-iW\r\u001e:jG:\u000bW.\u001a\u0011)\u0007\u0019i6-A\u0007hKRlU\r\u001e:jG:\u000bW.\u001a\u0015\u0004\u000fu\u001b\u0017!D:fi6+GO]5d\u001d\u0006lW\r\u0006\u0002}{6\t\u0001\u0001C\u0003\u007f\u0011\u0001\u0007q*A\u0003wC2,X\rK\u0002\t;\u000e\f\u0001c]3u!J,G-[2uS>t7i\u001c7\u0015\u0007q\f)\u0001C\u0003\u007f\u0013\u0001\u0007q\nK\u0002\n;\u000e\f1b]3u\u0019\u0006\u0014W\r\\\"pYR\u0019A0!\u0004\t\u000byT\u0001\u0019A()\u0007)i6-\u0001\u0007tKR<V-[4ii\u000e{G\u000eF\u0002}\u0003+AQA`\u0006A\u0002=CCaC/\u0002\u001a\u0005\u0012\u00111D\u0001\u0006g9\u0002d\u0006M\u0001\u0012g\u0016$\bK]8cC\nLG.\u001b;z\u0007>dGc\u0001?\u0002\"!)a\u0010\u0004a\u0001\u001f\"\"A\"XA\r\u0003-iW\r\u001e:jG2\u000b'-\u001a7\u0016\u0005\u0005%\u0002c\u0001:\u0002,%\u0019\u0011Q\u0006\u001e\u0003\u0017\u0011{WO\u00197f!\u0006\u0014\u0018-\u001c\u0015\u0005\u001bu\u000bI\"\u0001\u0007nKR\u0014\u0018n\u0019'bE\u0016d\u0007\u0005\u000b\u0003\u000f;\u0006e\u0011AD4fi6+GO]5d\u0019\u0006\u0014W\r\\\u000b\u0003\u0003s\u0001B!a\u000f\u0002>5\tQ+C\u0002\u0002@U\u0013a\u0001R8vE2,\u0007\u0006B\b^\u00033\tab]3u\u001b\u0016$(/[2MC\n,G\u000eF\u0002}\u0003\u000fBaA \tA\u0002\u0005e\u0002\u0006\u0002\t^\u00033\tAAY3uC\"\"\u0011#XA\r\u0003\u0015\u0011W\r^1!Q\u0011\u0011R,!\u0007\u0002\u000f\u001d,GOQ3uC\"\"1#XA\r\u0003\u001d\u0019X\r\u001e\"fi\u0006$2\u0001`A.\u0011\u0019qH\u00031\u0001\u0002:!\"A#XA\r\u0003\r)\u0007o\u001d\u0015\u0005+u\u000bI\"\u0001\u0003faN\u0004\u0003\u0006\u0002\f^\u00033\taaZ3u\u000bB\u001c\b\u0006B\f^\u00033\taa]3u\u000bB\u001cHc\u0001?\u0002p!1a\u0010\u0007a\u0001\u0003sAC\u0001G/\u0002\u001a\u0005AQM^1mk\u0006$X\r\u0006\u0003\u0002:\u0005]\u0004bBA=3\u0001\u0007\u00111P\u0001\bI\u0006$\u0018m]3ua\u0011\ti(!$\u0011\r\u0005}\u0014QQAE\u001b\t\t\tIC\u0002\u0002\u0004*\n1a]9m\u0013\u0011\t9)!!\u0003\u000f\u0011\u000bG/Y:fiB!\u00111RAG\u0019\u0001!A\"a$\u0002x\u0005\u0005\t\u0011!B\u0001\u0003#\u00131a\u0018\u00132#\u0011\t\u0019*!'\u0011\t\u0005m\u0012QS\u0005\u0004\u0003/+&a\u0002(pi\"Lgn\u001a\t\u0005\u0003w\tY*C\u0002\u0002\u001eV\u00131!\u00118zQ\u0011IR,!)\"\u0005\u0005\r\u0016!\u0002\u001a/a9\u0002\u0014AC4fi6+GO]5dgR!\u0011\u0011VA\\!\u0011\tY+a-\u000e\u0005\u00055&bA\u0014\u00020*\u0019\u0011\u0011\u0017\u0016\u0002\u000b5dG.\u001b2\n\t\u0005U\u0016Q\u0016\u0002\u0012\u001bVdG/[2mCN\u001cX*\u001a;sS\u000e\u001c\bbBA=5\u0001\u0007\u0011\u0011\u0018\u0019\u0005\u0003w\u000by\f\u0005\u0004\u0002\u0000\u0005\u0015\u0015Q\u0018\t\u0005\u0003\u0017\u000by\f\u0002\u0007\u0002B\u0006]\u0016\u0011!A\u0001\u0006\u0003\t\tJA\u0002`IIBCAG/\u0002F\u0006\u0012\u0011qY\u0001\u0006g9\nd\u0006M\u0001\u000fSNd\u0015M]4fe\n+G\u000f^3s+\t\ti\r\u0005\u0003\u0002<\u0005=\u0017bAAi+\n9!i\\8mK\u0006t\u0007fA\u000e^G\u0006!1m\u001c9z)\rI\u0017\u0011\u001c\u0005\b\u00037d\u0002\u0019AAo\u0003\u0015)\u0007\u0010\u001e:b!\r\u0011\u0018q\\\u0005\u0004\u0003CT$\u0001\u0003)be\u0006lW*\u00199)\u0007qi6-\u0001\u0005u_N#(/\u001b8h)\u0005y\u0005\u0006B\u000f^\u00033A3\u0001A/d\u0003\u0005jU\u000f\u001c;jG2\f7o]\"mCN\u001c\u0018NZ5dCRLwN\\#wC2,\u0018\r^8s!\t\u0019tdE\u0004 \u0003g\fI0a@\u0011\t\u0005m\u0012Q_\u0005\u0004\u0003o,&AB!osJ+g\r\u0005\u0003I\u0003wL\u0017bAA\u007f\u0013\n)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007\u0003\u0002B\u0001\u0005\u0017i!Aa\u0001\u000b\t\t\u0015!qA\u0001\u0003S>T!A!\u0003\u0002\t)\fg/Y\u0005\u0005\u0005\u001b\u0011\u0019A\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002p\u0006!2/\u001e9q_J$X\rZ'fiJL7MT1nKN,\"A!\u0006\u0011\r\u0005m\"q\u0003B\u000e\u0013\r\u0011I\"\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )!!\u0011\u0005B\u0004\u0003\u0011a\u0017M\\4\n\u0007i\u0013y\"A\u000btkB\u0004xN\u001d;fI6+GO]5d\u001d\u0006lWm\u001d\u0011\u0002\t1|\u0017\r\u001a\u000b\u0004S\n-\u0002B\u0002B\u0017G\u0001\u0007q*\u0001\u0003qCRD\u0007\u0006B\u0012^\u0005c\t#Aa\r\u0002\u000bErcG\f\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\te\u0002\u0003\u0002B\u000f\u0005wIAA!\u0010\u0003 \t1qJ\u00196fGRDCaH/\u00032!\"a$\u0018B\u0019\u0001")
public class MulticlassClassificationEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
HasWeightCol,
HasProbabilityCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final DoubleParam metricLabel;
    private final DoubleParam beta;
    private final DoubleParam eps;
    private Param<String> probabilityCol;
    private Param<String> weightCol;
    private Param<String> labelCol;
    private Param<String> predictionCol;

    public static MulticlassClassificationEvaluator load(String path) {
        return MulticlassClassificationEvaluator$.MODULE$.load(path);
    }

    public static MLReader<MulticlassClassificationEvaluator> read() {
        return MulticlassClassificationEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public MulticlassClassificationEvaluator setMetricName(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.metricName(), value);
    }

    public MulticlassClassificationEvaluator setPredictionCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.predictionCol(), value);
    }

    public MulticlassClassificationEvaluator setLabelCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.labelCol(), value);
    }

    public MulticlassClassificationEvaluator setWeightCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.weightCol(), value);
    }

    public MulticlassClassificationEvaluator setProbabilityCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.probabilityCol(), value);
    }

    public final DoubleParam metricLabel() {
        return this.metricLabel;
    }

    public double getMetricLabel() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel()));
    }

    public MulticlassClassificationEvaluator setMetricLabel(double value) {
        return (MulticlassClassificationEvaluator)this.set(this.metricLabel(), BoxesRunTime.boxToDouble((double)value));
    }

    public final DoubleParam beta() {
        return this.beta;
    }

    public double getBeta() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.beta()));
    }

    public MulticlassClassificationEvaluator setBeta(double value) {
        return (MulticlassClassificationEvaluator)this.set(this.beta(), BoxesRunTime.boxToDouble((double)value));
    }

    public final DoubleParam eps() {
        return this.eps;
    }

    public double getEps() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.eps()));
    }

    public MulticlassClassificationEvaluator setEps(double value) {
        return (MulticlassClassificationEvaluator)this.set(this.eps(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        block16: {
            MulticlassMetrics metrics = this.getMetrics(dataset);
            String string = this.$(this.metricName());
            switch (string == null ? 0 : string.hashCode()) {
                case -2131707655: {
                    if (!"accuracy".equals(string)) break;
                    d = metrics.accuracy();
                    break block16;
                }
                case -2067421467: {
                    if (!"weightedFalsePositiveRate".equals(string)) break;
                    d = metrics.weightedFalsePositiveRate();
                    break block16;
                }
                case -1408591233: {
                    if (!"precisionByLabel".equals(string)) break;
                    d = metrics.precision(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
                    break block16;
                }
                case -1041068123: {
                    if (!"fMeasureByLabel".equals(string)) break;
                    d = metrics.fMeasure(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())), BoxesRunTime.unboxToDouble((Object)this.$(this.beta())));
                    break block16;
                }
                case -905554431: {
                    if (!"falsePositiveRateByLabel".equals(string)) break;
                    d = metrics.falsePositiveRate(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
                    break block16;
                }
                case -873183480: {
                    if (!"weightedRecall".equals(string)) break;
                    d = metrics.weightedRecall();
                    break block16;
                }
                case -817361841: {
                    if (!"weightedFMeasure".equals(string)) break;
                    d = metrics.weightedFMeasure(BoxesRunTime.unboxToDouble((Object)this.$(this.beta())));
                    break block16;
                }
                case -592254036: {
                    if (!"hammingLoss".equals(string)) break;
                    d = metrics.hammingLoss();
                    break block16;
                }
                case -355660505: {
                    if (!"weightedPrecision".equals(string)) break;
                    d = metrics.weightedPrecision();
                    break block16;
                }
                case 3211: {
                    if (!"f1".equals(string)) break;
                    d = metrics.weightedFMeasure();
                    break block16;
                }
                case 341482631: {
                    if (!"logLoss".equals(string)) break;
                    d = metrics.logLoss(BoxesRunTime.unboxToDouble((Object)this.$(this.eps())));
                    break block16;
                }
                case 594154422: {
                    if (!"truePositiveRateByLabel".equals(string)) break;
                    d = metrics.truePositiveRate(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
                    break block16;
                }
                case 969153676: {
                    if (!"recallByLabel".equals(string)) break;
                    d = metrics.recall(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
                    break block16;
                }
                case 1987142238: {
                    if (!"weightedTruePositiveRate".equals(string)) break;
                    d = metrics.weightedTruePositiveRate();
                    break block16;
                }
            }
            throw new MatchError((Object)string);
        }
        return d;
    }

    public MulticlassMetrics getMetrics(Dataset<?> dataset) {
        RDD rDD;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.predictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        String string = this.$(this.metricName());
        String string2 = "logLoss";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.require(ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Object)this.$(this.probabilityCol())), (Function0 & Serializable)() -> "probabilityCol is needed to compute logloss");
        }
        Column w = DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol()));
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()), (Object)this.$(this.probabilityCol()))) {
            Column p = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.probabilityCol()));
            rDD = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), w, p})).rdd().map((Function1 & Serializable)x0$1 -> {
                double d;
                double d2;
                double d3;
                Object probability;
                block3: {
                    Row row;
                    block2: {
                        Some some;
                        row = x0$1;
                        if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(4) != 0) break block2;
                        Object prediction = ((SeqOps)some.get()).apply(0);
                        Object label = ((SeqOps)some.get()).apply(1);
                        Object weight = ((SeqOps)some.get()).apply(2);
                        probability = ((SeqOps)some.get()).apply(3);
                        if (!(prediction instanceof Double)) break block2;
                        d3 = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (!(label instanceof Double)) break block2;
                        d2 = BoxesRunTime.unboxToDouble((Object)label);
                        if (!(weight instanceof Double)) break block2;
                        d = BoxesRunTime.unboxToDouble((Object)weight);
                        if (probability instanceof Vector) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                Vector vector = (Vector)probability;
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)d3), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector.toArray());
                return tuple4;
            }, ClassTag$.MODULE$.apply(Tuple4.class));
        } else {
            rDD = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), w})).rdd().map((Function1 & Serializable)x0$2 -> {
                double d;
                double d2;
                Object weight;
                block3: {
                    Row row;
                    block2: {
                        Some some;
                        row = x0$2;
                        if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(3) != 0) break block2;
                        Object prediction = ((SeqOps)some.get()).apply(0);
                        Object label = ((SeqOps)some.get()).apply(1);
                        weight = ((SeqOps)some.get()).apply(2);
                        if (!(prediction instanceof Double)) break block2;
                        d2 = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (!(label instanceof Double)) break block2;
                        d = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d3));
                return tuple3;
            }, ClassTag$.MODULE$.apply(Tuple3.class));
        }
        RDD rdd = rDD;
        return new MulticlassMetrics((RDD<? extends Product>)rdd);
    }

    @Override
    public boolean isLargerBetter() {
        boolean bl;
        block11: {
            block10: {
                String string = this.$(this.metricName());
                switch (string == null ? 0 : string.hashCode()) {
                    case -2067421467: {
                        if ("weightedFalsePositiveRate".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    case -905554431: {
                        if ("falsePositiveRateByLabel".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    case -592254036: {
                        if ("hammingLoss".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    case 341482631: {
                        if ("logLoss".equals(string)) {
                            break;
                        }
                        break block10;
                    }
                    default: {
                        break block10;
                    }
                }
                bl = false;
                break block11;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public MulticlassClassificationEvaluator copy(ParamMap extra) {
        return (MulticlassClassificationEvaluator)this.defaultCopy(extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(0).append(new StringBuilder(54).append("MulticlassClassificationEvaluator: uid=").append(this.uid()).append(", metricName=").append((Object)this.$(this.metricName())).append(", ").toString()).append(new StringBuilder(25).append("metricLabel=").append(this.$(this.metricLabel())).append(", beta=").append(this.$(this.beta())).append(", eps=").append(this.$(this.eps())).toString()).toString();
    }

    public MulticlassClassificationEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        HasWeightCol.$init$(this);
        HasProbabilityCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.metricName = new Param(this, "metricName", new StringBuilder(26).append("metric name in evaluation ").append(Predef$.MODULE$.wrapRefArray((Object[])MulticlassClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MulticlassClassificationEvaluator$$supportedMetricNames()).mkString("(", "|", ")")).toString(), ParamValidators$.MODULE$.inArray(MulticlassClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MulticlassClassificationEvaluator$$supportedMetricNames()));
        this.metricLabel = new DoubleParam((Identifiable)this, "metricLabel", new StringBuilder(80).append("The class whose metric will be computed in ").append(new StringBuilder(2).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])MulticlassClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MulticlassClassificationEvaluator$$supportedMetricNames()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.endsWith("ByLabel")))).mkString("(", "|", ")")).append(". ").toString()).append("Must be >= 0. The default value is 0.").toString(), (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0));
        this.beta = new DoubleParam((Identifiable)this, "beta", "The beta value, which controls precision vs recall weighting, used in (weightedFMeasure|fMeasureByLabel). Must be > 0. The default value is 1.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0));
        this.eps = new DoubleParam((Identifiable)this, "eps", "log-loss is undefined for p=0 or p=1, so probabilities are clipped to max(eps, min(1 - eps, p)).", (Function1<Object, Object>)ParamValidators$.MODULE$.inRange(0.0, 0.5, false, false));
        this.setDefault((Seq<ParamPair<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("f1"), this.eps().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-15)), this.metricLabel().$minus$greater(BoxesRunTime.boxToDouble((double)0.0)), this.beta().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
        Statics.releaseFence();
    }

    public MulticlassClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("mcEval"));
    }
}

