/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.jwt.JsonUtil;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtPublicKeyVerifyInternal;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.crypto.tink.proto.JwtEcdsaAlgorithm;
import com.google.crypto.tink.proto.JwtEcdsaPublicKey;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.EcdsaVerifyJce;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.Validators;
import com.google.gson.JsonObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;
import java.util.Optional;

class JwtEcdsaVerifyKeyManager
extends KeyTypeManager<JwtEcdsaPublicKey> {
    static final EllipticCurves.CurveType getCurve(JwtEcdsaAlgorithm algorithm) throws GeneralSecurityException {
        switch (algorithm) {
            case ES256: {
                return EllipticCurves.CurveType.NIST_P256;
            }
            case ES384: {
                return EllipticCurves.CurveType.NIST_P384;
            }
            case ES512: {
                return EllipticCurves.CurveType.NIST_P521;
            }
        }
        throw new GeneralSecurityException("unknown algorithm " + algorithm.name());
    }

    public static Enums.HashType hashForEcdsaAlgorithm(JwtEcdsaAlgorithm algorithm) throws GeneralSecurityException {
        switch (algorithm) {
            case ES256: {
                return Enums.HashType.SHA256;
            }
            case ES384: {
                return Enums.HashType.SHA384;
            }
            case ES512: {
                return Enums.HashType.SHA512;
            }
        }
        throw new GeneralSecurityException("unknown algorithm " + algorithm.name());
    }

    static final void validateEcdsaAlgorithm(JwtEcdsaAlgorithm algorithm) throws GeneralSecurityException {
        Enums.HashType unused = JwtEcdsaVerifyKeyManager.hashForEcdsaAlgorithm(algorithm);
    }

    public JwtEcdsaVerifyKeyManager() {
        super(JwtEcdsaPublicKey.class, new JwtPublicKeyVerifyFactory());
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.JwtEcdsaPublicKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.ASYMMETRIC_PUBLIC;
    }

    @Override
    public JwtEcdsaPublicKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return JwtEcdsaPublicKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public void validateKey(JwtEcdsaPublicKey pubKey) throws GeneralSecurityException {
        Validators.validateVersion(pubKey.getVersion(), this.getVersion());
        JwtEcdsaVerifyKeyManager.validateEcdsaAlgorithm(pubKey.getAlgorithm());
    }

    private static class JwtPublicKeyVerifyFactory
    extends PrimitiveFactory<JwtPublicKeyVerifyInternal, JwtEcdsaPublicKey> {
        public JwtPublicKeyVerifyFactory() {
            super(JwtPublicKeyVerifyInternal.class);
        }

        @Override
        public JwtPublicKeyVerifyInternal getPrimitive(JwtEcdsaPublicKey keyProto) throws GeneralSecurityException {
            EllipticCurves.CurveType curve = JwtEcdsaVerifyKeyManager.getCurve(keyProto.getAlgorithm());
            ECPublicKey publicKey = EllipticCurves.getEcPublicKey(curve, keyProto.getX().toByteArray(), keyProto.getY().toByteArray());
            Enums.HashType hash = JwtEcdsaVerifyKeyManager.hashForEcdsaAlgorithm(keyProto.getAlgorithm());
            final EcdsaVerifyJce verifier = new EcdsaVerifyJce(publicKey, hash, EllipticCurves.EcdsaEncoding.IEEE_P1363);
            final String algorithmName = keyProto.getAlgorithm().name();
            final Optional customKidFromEcdsaPublicKey = keyProto.hasCustomKid() ? Optional.of(keyProto.getCustomKid().getValue()) : Optional.empty();
            return new JwtPublicKeyVerifyInternal(){

                @Override
                public VerifiedJwt verifyAndDecodeWithKid(String compact, JwtValidator validator, Optional<String> kid) throws GeneralSecurityException {
                    JwtFormat.Parts parts = JwtFormat.splitSignedCompact(compact);
                    verifier.verify(parts.signatureOrMac, parts.unsignedCompact.getBytes(StandardCharsets.US_ASCII));
                    JsonObject parsedHeader = JsonUtil.parseJson(parts.header);
                    JwtFormat.validateHeader(algorithmName, kid, customKidFromEcdsaPublicKey, parsedHeader);
                    RawJwt token = RawJwt.fromJsonPayload(JwtFormat.getTypeHeader(parsedHeader), parts.payload);
                    return validator.validate(token);
                }
            };
        }
    }
}

