/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="min", value="_FUNC_(expr) - Returns the minimum value of expr (vectorized, type: decimal)")
public class VectorUDAFMinDecimal
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private transient VectorExpressionWriter resultWriter;

    @Override
    public VectorExpression inputExpression() {
        return this.inputExpression;
    }

    public VectorUDAFMinDecimal(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFMinDecimal() {
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
        this.resultWriter = VectorExpressionWriterFactory.genVectorExpressionWritable(desc.getParameters().get(0));
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregrateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        DecimalColumnVector inputVector = (DecimalColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        HiveDecimalWritable[] vector = inputVector.vector;
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector[0], inputVector.scale, batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector, inputVector.scale, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector, inputVector.scale, batchSize);
            }
        } else if (inputVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector[0], inputVector.scale, batchSize, batch.selected, inputVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector[0], inputVector.scale, batchSize, inputVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector, inputVector.scale, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregrateIndex, vector, inputVector.scale, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, HiveDecimalWritable value, short scale, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(value, scale);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, HiveDecimalWritable[] values, short scale, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(values[selection[i]], scale);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, HiveDecimalWritable[] values, short scale, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(values[i], scale);
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, HiveDecimalWritable value, short scale, int batchSize, int[] selection, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[selection[i]]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(value, scale);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, HiveDecimalWritable value, short scale, int batchSize, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(value, scale);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, HiveDecimalWritable[] values, short scale, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, j);
            myagg.checkValue(values[i], scale);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, HiveDecimalWritable[] values, short scale, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            myagg.checkValue(values[i], scale);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DecimalColumnVector inputVector = (DecimalColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        HiveDecimalWritable[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls && (myagg.isNull || myagg.value.compareTo(vector[0]) > 0)) {
                myagg.isNull = false;
                myagg.value.set(vector[0]);
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, inputVector.scale, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, inputVector.scale, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, inputVector.scale, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, inputVector.scale, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            HiveDecimalWritable writable = vector[i];
            if (myagg.isNull) {
                myagg.isNull = false;
                myagg.value.set(writable);
                continue;
            }
            if (myagg.value.compareTo(writable) <= 0) continue;
            myagg.value.set(writable);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.value.set(vector[selected[0]]);
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            HiveDecimalWritable writable = vector[selected[i]];
            if (myagg.value.compareTo(writable) <= 0) continue;
            myagg.value.set(writable);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            HiveDecimalWritable writable = vector[i];
            if (myagg.isNull) {
                myagg.value.set(writable);
                myagg.isNull = false;
                continue;
            }
            if (myagg.value.compareTo(writable) <= 0) continue;
            myagg.value.set(writable);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize) {
        if (myagg.isNull) {
            myagg.value.set(vector[0]);
            myagg.isNull = false;
        }
        for (int i = 0; i < batchSize; ++i) {
            HiveDecimalWritable writable = vector[i];
            if (myagg.value.compareTo(writable) <= 0) continue;
            myagg.value.set(writable);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            return null;
        }
        return this.resultWriter.writeValue(myagg.value);
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return this.resultWriter.getObjectInspector();
    }

    @Override
    public int getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((int)(model.object() + model.primitive2()), (int)model.memoryAlign());
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(VectorExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private final transient HiveDecimalWritable value = new HiveDecimalWritable();
        private transient boolean isNull = true;

        public void checkValue(HiveDecimalWritable writable, short scale) {
            if (this.isNull) {
                this.isNull = false;
                this.value.set(writable);
            } else if (this.value.compareTo(writable) > 0) {
                this.value.set(writable);
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.value.set(HiveDecimal.ZERO);
        }
    }
}

