/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$BooleanConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$ByteConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$DateConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$DoubleConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$FloatConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$InstantConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$IntConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$LocalDateConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$LongConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$ShortConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$StringConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$TimestampConverter$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$TimestampNTZConverter$;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CatalystTypeConverters$ {
    public static final CatalystTypeConverters$ MODULE$ = new CatalystTypeConverters$();

    public boolean isPrimitive(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = BooleanType$.MODULE$.equals(dataType2) ? true : (ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : (LongType$.MODULE$.equals(dataType2) ? true : (FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2))))));
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(DataType dataType) {
        block29: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    block28: {
                                        var4_2 = false;
                                        var5_3 = null;
                                        var6_4 = false;
                                        var7_5 = null;
                                        var8_6 = dataType;
                                        if (!(var8_6 instanceof UserDefinedType)) break block28;
                                        var9_7 = (UserDefinedType)var8_6;
                                        var2_8 /* !! */  = new CatalystTypeConverters.UDTConverter<A>(var9_7);
                                        break block29;
                                    }
                                    if (!(var8_6 instanceof ArrayType)) break block30;
                                    var10_9 = (ArrayType)var8_6;
                                    var2_8 /* !! */  = new CatalystTypeConverters.ArrayConverter(var10_9.elementType());
                                    break block29;
                                }
                                if (!(var8_6 instanceof MapType)) break block31;
                                var11_10 = (MapType)var8_6;
                                var2_8 /* !! */  = new CatalystTypeConverters.MapConverter(var11_10.keyType(), var11_10.valueType());
                                break block29;
                            }
                            if (!(var8_6 instanceof StructType)) break block32;
                            var12_11 = (StructType)var8_6;
                            var2_8 /* !! */  = new CatalystTypeConverters.StructConverter(var12_11);
                            break block29;
                        }
                        if (!StringType$.MODULE$.equals(var8_6)) break block33;
                        var2_8 /* !! */  = CatalystTypeConverters$StringConverter$.MODULE$;
                        break block29;
                    }
                    if (!DateType$.MODULE$.equals(var8_6)) break block34;
                    var4_2 = true;
                    var5_3 = var8_6;
                    if (!SQLConf$.MODULE$.get().datetimeJava8ApiEnabled()) break block34;
                    var2_8 /* !! */  = CatalystTypeConverters$LocalDateConverter$.MODULE$;
                    break block29;
                }
                if (!var4_2) break block35;
                var2_8 /* !! */  = CatalystTypeConverters$DateConverter$.MODULE$;
                break block29;
            }
            if (!TimestampType$.MODULE$.equals(var8_6)) ** GOTO lbl-1000
            var6_4 = true;
            var7_5 = var8_6;
            if (SQLConf$.MODULE$.get().datetimeJava8ApiEnabled()) {
                var2_8 /* !! */  = CatalystTypeConverters$InstantConverter$.MODULE$;
            } else if (var6_4) {
                var2_8 /* !! */  = CatalystTypeConverters$TimestampConverter$.MODULE$;
            } else if (TimestampNTZType$.MODULE$.equals(var8_6)) {
                var2_8 /* !! */  = CatalystTypeConverters$TimestampNTZConverter$.MODULE$;
            } else if (var8_6 instanceof DecimalType) {
                var13_12 = (DecimalType)var8_6;
                var2_8 /* !! */  = new CatalystTypeConverters.DecimalConverter(var13_12);
            } else if (BooleanType$.MODULE$.equals(var8_6)) {
                var2_8 /* !! */  = CatalystTypeConverters$BooleanConverter$.MODULE$;
            } else if (ByteType$.MODULE$.equals(var8_6)) {
                var2_8 /* !! */  = CatalystTypeConverters$ByteConverter$.MODULE$;
            } else if (ShortType$.MODULE$.equals(var8_6)) {
                var2_8 /* !! */  = CatalystTypeConverters$ShortConverter$.MODULE$;
            } else if (IntegerType$.MODULE$.equals(var8_6)) {
                var2_8 /* !! */  = CatalystTypeConverters$IntConverter$.MODULE$;
            } else if (LongType$.MODULE$.equals(var8_6)) {
                var2_8 /* !! */  = CatalystTypeConverters$LongConverter$.MODULE$;
            } else if (FloatType$.MODULE$.equals(var8_6)) {
                var2_8 /* !! */  = CatalystTypeConverters$FloatConverter$.MODULE$;
            } else if (DoubleType$.MODULE$.equals(var8_6)) {
                var2_8 /* !! */  = CatalystTypeConverters$DoubleConverter$.MODULE$;
            } else if (var8_6 instanceof DayTimeIntervalType) {
                var14_13 = (DayTimeIntervalType)var8_6;
                endField = var14_13.endField();
                var2_8 /* !! */  = new CatalystTypeConverters.DurationConverter(endField);
            } else if (var8_6 instanceof YearMonthIntervalType) {
                var16_15 = (YearMonthIntervalType)var8_6;
                endField = var16_15.endField();
                var2_8 /* !! */  = new CatalystTypeConverters.PeriodConverter(endField);
            } else if (var8_6 != null) {
                var18_17 = var8_6;
                var2_8 /* !! */  = new CatalystTypeConverters.IdentityConverter(var18_17);
            } else {
                throw new MatchError((Object)var8_6);
            }
        }
        converter = var2_8 /* !! */ ;
        return var3_18;
    }

    public Function1<Object, Object> createToCatalystConverter(DataType dataType) {
        Function1 & Serializable intersect;
        if (this.isPrimitive(dataType)) {
            intersect = (Function1 & Serializable)maybeScalaValue -> CatalystTypeConverters$.convert$1(maybeScalaValue);
        } else {
            CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> catalystTypeConverter = this.org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(dataType);
            intersect = (Function1 & Serializable)maybeScalaValue -> catalystTypeConverter.toCatalyst(maybeScalaValue);
        }
        return intersect;
    }

    public Function1<Object, Object> createToScalaConverter(DataType dataType) {
        Function1 & Serializable intersect;
        if (this.isPrimitive(dataType)) {
            intersect = (Function1 & Serializable)x -> Predef$.MODULE$.identity(x);
        } else {
            CatalystTypeConverters.CatalystTypeConverter<Object, Object, Object> catalystTypeConverter = this.org$apache$spark$sql$catalyst$CatalystTypeConverters$$getConverterForType(dataType);
            intersect = (Function1 & Serializable)catalystValue -> catalystTypeConverter.toScala(catalystValue);
        }
        return intersect;
    }

    public Object convertToCatalyst(Object a2) {
        Object object;
        Object object2 = a2;
        if (object2 instanceof String) {
            String string = (String)object2;
            object = CatalystTypeConverters$StringConverter$.MODULE$.toCatalyst(string);
        } else if (object2 instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object2);
            object = CatalystTypeConverters$StringConverter$.MODULE$.toCatalyst(Character.toString(c));
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = CatalystTypeConverters$DateConverter$.MODULE$.toCatalyst(date);
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = CatalystTypeConverters$LocalDateConverter$.MODULE$.toCatalyst(localDate);
        } else if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            object = CatalystTypeConverters$TimestampConverter$.MODULE$.toCatalyst(timestamp);
        } else if (object2 instanceof Instant) {
            Instant instant = (Instant)object2;
            object = CatalystTypeConverters$InstantConverter$.MODULE$.toCatalyst(instant);
        } else if (object2 instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object2;
            object = CatalystTypeConverters$TimestampNTZConverter$.MODULE$.toCatalyst(localDateTime);
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object2;
            object = new CatalystTypeConverters.DecimalConverter(new DecimalType(Math.max(bigDecimal.precision(), bigDecimal.scale()), bigDecimal.scale())).toCatalyst(bigDecimal);
        } else if (object2 instanceof java.math.BigDecimal) {
            java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object2;
            object = new CatalystTypeConverters.DecimalConverter(new DecimalType(Math.max(bigDecimal.precision(), bigDecimal.scale()), bigDecimal.scale())).toCatalyst(bigDecimal);
        } else if (object2 instanceof Seq) {
            Seq seq = (Seq)object2;
            object = new GenericArrayData((Object[])((IterableOnceOps)seq.map((Function1 & Serializable)a -> MODULE$.convertToCatalyst(a))).toArray(ClassTag$.MODULE$.Any()));
        } else if (object2 instanceof Row) {
            Row row = (Row)object2;
            object = InternalRow$.MODULE$.apply((Seq<Object>)((Seq)row.toSeq().map((Function1 & Serializable)a -> MODULE$.convertToCatalyst(a))));
        } else if (object2 instanceof byte[]) {
            byte[] byArray = (byte[])object2;
            object = byArray;
        } else if (object2 instanceof char[]) {
            char[] cArray = (char[])object2;
            object = CatalystTypeConverters$StringConverter$.MODULE$.toCatalyst(cArray);
        } else if (ScalaRunTime$.MODULE$.isArray(object2, 1)) {
            Object object3 = object2;
            object = new GenericArrayData((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(object3), (Function1 & Serializable)a -> MODULE$.convertToCatalyst(a), ClassTag$.MODULE$.Any()));
        } else if (object2 instanceof Map) {
            Map map = (Map)object2;
            object = ArrayBasedMapData$.MODULE$.apply(map, (Function1<Object, Object>)(Function1 & Serializable)key -> MODULE$.convertToCatalyst(key), (Function1<Object, Object>)(Function1 & Serializable)value -> MODULE$.convertToCatalyst(value));
        } else if (object2 instanceof Duration) {
            Duration duration = (Duration)object2;
            object = new CatalystTypeConverters.DurationConverter(DayTimeIntervalType$.MODULE$.SECOND()).toCatalyst(duration);
        } else if (object2 instanceof Period) {
            Period period = (Period)object2;
            object = new CatalystTypeConverters.PeriodConverter(YearMonthIntervalType$.MODULE$.MONTH()).toCatalyst(period);
        } else {
            object = object2;
        }
        return object;
    }

    public Object convertToScala(Object catalystValue, DataType dataType) {
        return this.createToScalaConverter(dataType).apply(catalystValue);
    }

    private static final Object convert$1(Object maybeScalaValue) {
        Object object;
        Object object2 = maybeScalaValue;
        if (object2 instanceof Option) {
            Option option = (Option)object2;
            object = option.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else {
            object = maybeScalaValue;
        }
        return object;
    }

    private CatalystTypeConverters$() {
    }
}

