/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.sql.catalyst.analysis.TempTableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.TemporaryViewRelation;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001B\u0007\u000f\u0001mA\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\t_\u0001\u0011\t\u0011)A\u0005I!)\u0001\u0007\u0001C\u0001c!9Q\u0007\u0001b\u0001\n\u00131\u0004B\u0002\"\u0001A\u0003%q\u0007C\u0003R\u0001\u0011\u0005!\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003f\u0001\u0011\u0005a\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0003s\u0001\u0011\u00051\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0002\u0016\u000f2|'-\u00197UK6\u0004h+[3x\u001b\u0006t\u0017mZ3s\u0015\ty\u0001#A\u0004dCR\fGn\\4\u000b\u0005E\u0011\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005M!\u0012aA:rY*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"AB!osJ+g-\u0001\u0005eCR\f'-Y:f+\u0005!\u0003CA\u0013-\u001d\t1#\u0006\u0005\u0002(=5\t\u0001F\u0003\u0002*5\u00051AH]8pizJ!a\u000b\u0010\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003Wy\t\u0011\u0002Z1uC\n\f7/\u001a\u0011\u0002\rqJg.\u001b;?)\t\u0011D\u0007\u0005\u00024\u00015\ta\u0002C\u0003#\u0007\u0001\u0007A%A\bwS\u0016<H)\u001a4j]&$\u0018n\u001c8t+\u00059\u0004\u0003\u0002\u001d>I}j\u0011!\u000f\u0006\u0003um\nq!\\;uC\ndWM\u0003\u0002==\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005yJ$a\u0002%bg\"l\u0015\r\u001d\t\u0003g\u0001K!!\u0011\b\u0003+Q+W\u000e]8sCJLh+[3x%\u0016d\u0017\r^5p]\u0006\u0001b/[3x\t\u00164\u0017N\\5uS>t7\u000f\t\u0015\u0005\u000b\u0011su\n\u0005\u0002F\u00196\taI\u0003\u0002H\u0011\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005%S\u0015AC1o]>$\u0018\r^5p]*\t1*A\u0003kCZ\f\u00070\u0003\u0002N\r\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u0002!\u0006!A\u000f[5t\u0003\r9W\r\u001e\u000b\u0003'Z\u00032!\b+@\u0013\t)fD\u0001\u0004PaRLwN\u001c\u0005\u0006/\u001a\u0001\r\u0001J\u0001\u0005]\u0006lW-\u0001\u0004de\u0016\fG/\u001a\u000b\u00055vs\u0006\r\u0005\u0002\u001e7&\u0011AL\b\u0002\u0005+:LG\u000fC\u0003X\u000f\u0001\u0007A\u0005C\u0003`\u000f\u0001\u0007q(\u0001\bwS\u0016<H)\u001a4j]&$\u0018n\u001c8\t\u000b\u0005<\u0001\u0019\u00012\u0002!=4XM\u001d:jI\u0016Le-\u0012=jgR\u001c\bCA\u000fd\u0013\t!gDA\u0004C_>dW-\u00198\u0002\rU\u0004H-\u0019;f)\r\u0011w\r\u001b\u0005\u0006/\"\u0001\r\u0001\n\u0005\u0006?\"\u0001\raP\u0001\u0007e\u0016lwN^3\u0015\u0005\t\\\u0007\"B,\n\u0001\u0004!\u0013A\u0002:f]\u0006lW\rF\u0002c]BDQa\u001c\u0006A\u0002\u0011\nqa\u001c7e\u001d\u0006lW\rC\u0003r\u0015\u0001\u0007A%A\u0004oK^t\u0015-\\3\u0002\u001b1L7\u000f\u001e,jK^t\u0015-\\3t)\t!X\u0010E\u0002vu\u0012r!A\u001e=\u000f\u0005\u001d:\u0018\"A\u0010\n\u0005et\u0012a\u00029bG.\fw-Z\u0005\u0003wr\u00141aU3r\u0015\tIh\u0004C\u0003\u007f\u0017\u0001\u0007A%A\u0004qCR$XM\u001d8\u0002\u000b\rdW-\u0019:\u0015\u0003i\u0003")
public class GlobalTempViewManager {
    private final String database;
    @GuardedBy(value="this")
    private final HashMap<String, TemporaryViewRelation> viewDefinitions;

    public String database() {
        return this.database;
    }

    private HashMap<String, TemporaryViewRelation> viewDefinitions() {
        return this.viewDefinitions;
    }

    public synchronized Option<TemporaryViewRelation> get(String name) {
        return this.viewDefinitions().get((Object)name);
    }

    public void create(String name, TemporaryViewRelation viewDefinition, boolean overrideIfExists) {
        GlobalTempViewManager globalTempViewManager = this;
        synchronized (globalTempViewManager) {
            if (!overrideIfExists && this.viewDefinitions().contains((Object)name)) {
                throw new TempTableAlreadyExistsException(name);
            }
            this.viewDefinitions().put((Object)name, (Object)viewDefinition);
        }
    }

    public synchronized boolean update(String name, TemporaryViewRelation viewDefinition) {
        boolean bl;
        if (this.viewDefinitions().contains((Object)name)) {
            this.viewDefinitions().put((Object)name, (Object)viewDefinition);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean remove(String name) {
        return this.viewDefinitions().remove((Object)name).isDefined();
    }

    public synchronized boolean rename(String oldName, String newName) {
        boolean bl;
        if (this.viewDefinitions().contains((Object)oldName)) {
            if (this.viewDefinitions().contains((Object)newName)) {
                throw QueryCompilationErrors$.MODULE$.renameTempViewToExistingViewError(newName);
            }
            TemporaryViewRelation viewDefinition = (TemporaryViewRelation)this.viewDefinitions().apply((Object)oldName);
            this.viewDefinitions().remove((Object)oldName);
            this.viewDefinitions().put((Object)newName, (Object)viewDefinition);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized Seq<String> listViewNames(String pattern) {
        return StringUtils$.MODULE$.filterPattern((Seq<String>)this.viewDefinitions().keys().toSeq(), pattern);
    }

    public synchronized void clear() {
        this.viewDefinitions().clear();
    }

    public GlobalTempViewManager(String database) {
        this.database = database;
        this.viewDefinitions = new HashMap();
    }
}

