/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MiniReadWriteTest$ {
    public static final MiniReadWriteTest$ MODULE$ = new MiniReadWriteTest$();
    private static final int NPARAMS = 1;

    private int NPARAMS() {
        return NPARAMS;
    }

    private List<String> readFile(String filename) {
        return (List)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> Source$.MODULE$.fromFile(filename, Codec$.MODULE$.fallbackSystemCodec()), (Function1 & Serializable)x$1 -> x$1.getLines().toList());
    }

    private void printUsage() {
        String usage = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Mini Read-Write Test\n    |Usage: localFile\n    |localFile - (string) location of local file to distribute to executors."));
        Predef$.MODULE$.println((Object)usage);
    }

    /*
     * WARNING - void declaration
     */
    private File parseArgs(String[] args) {
        void var3_3;
        block2: {
            String filePath;
            File localFilePath;
            if (args.length != this.NPARAMS()) {
                this.printUsage();
                System.exit(1);
            }
            if (!(localFilePath = new File(filePath = args[0])).exists()) {
                System.err.println(new StringBuilder(28).append("Given path (").append(filePath).append(") does not exist").toString());
                this.printUsage();
                System.exit(1);
            }
            if (localFilePath.isFile()) break block2;
            System.err.println(new StringBuilder(27).append("Given path (").append(filePath).append(") is not a file").toString());
            this.printUsage();
            System.exit(1);
        }
        return var3_3;
    }

    public int runLocalWordCount(List<String> fileContents) {
        return BoxesRunTime.unboxToInt((Object)fileContents.flatMap((Function1 & Serializable)x$2 -> Predef$.MODULE$.wrapRefArray((Object[])x$2.split(" "))).flatMap((Function1 & Serializable)x$3 -> Predef$.MODULE$.wrapRefArray((Object[])x$3.split("\t"))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4)))).groupBy((Function1 & Serializable)w -> w).mapValues((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size())).values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void main(String[] args) {
        File localFilePath = this.parseArgs(args);
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("Performing local word count from ").append(localFilePath).toString());
        List<String> fileContents = this.readFile(localFilePath.toString());
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("File contents are ").append(fileContents).toString());
        int localWordCount = this.runLocalWordCount(fileContents);
        Predef$.MODULE$.println((Object)"Creating SparkSession");
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Mini Read Write Test").getOrCreate();
        Predef$.MODULE$.println((Object)"Writing local file to executors");
        RDD misc = spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10), spark.sparkContext().parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Int());
        misc.foreachPartition((Function1 & Serializable)x -> {
            MiniReadWriteTest$.$anonfun$main$1(localFilePath, fileContents, x);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)"Reading file from execs and running Word Count");
        RDD readFileRDD = spark.sparkContext().textFile(localFilePath.toString(), spark.sparkContext().textFile$default$2());
        long dWordCount = BoxesRunTime.unboxToLong((Object)RDD$.MODULE$.rddToPairRDDFunctions(readFileRDD.flatMap((Function1 & Serializable)x$6 -> Predef$.MODULE$.wrapRefArray((Object[])x$6.split(" ")), ClassTag$.MODULE$.apply(String.class)).flatMap((Function1 & Serializable)x$7 -> Predef$.MODULE$.wrapRefArray((Object[])x$7.split("\t")), ClassTag$.MODULE$.apply(String.class)).filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$8)))).map((Function1 & Serializable)w -> new Tuple2(w, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).countByKey().values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        spark.stop();
        if ((long)localWordCount == dWordCount) {
            Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(31).append("Success! Local Word Count ").append(localWordCount).append(" and ").toString()).append(new StringBuilder(20).append("D Word Count ").append(dWordCount).append(" agree.").toString()).toString());
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(27).append("Failure! Local Word Count ").append(localWordCount).append(" ").toString()).append(new StringBuilder(27).append("and D Word Count ").append(dWordCount).append(" disagree.").toString()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$main$1(File localFilePath$1, List fileContents$1, Iterator x) {
        new PrintWriter(localFilePath$1, fileContents$1){
            {
                try {
                    this.write(fileContents$1.mkString("\n"));
                }
                finally {
                    this.close();
                }
            }
        };
    }

    private MiniReadWriteTest$() {
    }
}

