/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.spark.network.shuffledb.StoreVersion;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Status;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class RocksDBProvider {
    private static final Logger logger;

    public static RocksDB initRockDB(File dbFile, StoreVersion version, ObjectMapper mapper) throws IOException {
        RocksDB tmpDb = null;
        if (dbFile != null) {
            BloomFilter fullFilter = new BloomFilter(10.0, false);
            BlockBasedTableConfig tableFormatConfig = new BlockBasedTableConfig().setFilterPolicy((Filter)fullFilter).setEnableIndexCompression(false).setIndexBlockRestartInterval(8).setFormatVersion(5);
            Options dbOptions = new Options();
            RocksDBLogger rocksDBLogger = new RocksDBLogger(dbOptions);
            dbOptions.setCreateIfMissing(false);
            dbOptions.setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION);
            dbOptions.setCompressionType(CompressionType.LZ4_COMPRESSION);
            dbOptions.setTableFormatConfig((TableFormatConfig)tableFormatConfig);
            dbOptions.setLogger((org.rocksdb.Logger)rocksDBLogger);
            try {
                tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
            }
            catch (RocksDBException e) {
                if (e.getStatus().getCode() == Status.Code.NotFound) {
                    logger.info("Creating state database at " + dbFile);
                    dbOptions.setCreateIfMissing(true);
                    try {
                        tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
                    }
                    catch (RocksDBException dbExc) {
                        throw new IOException("Unable to create state store", dbExc);
                    }
                }
                logger.error("error opening rocksdb file {}. Creating new file, will not be able to recover state for existing applications", (Object)dbFile, (Object)e);
                if (dbFile.isDirectory()) {
                    for (File f : Objects.requireNonNull(dbFile.listFiles())) {
                        if (f.delete()) continue;
                        logger.warn("error deleting {}", (Object)f.getPath());
                    }
                }
                if (!dbFile.delete()) {
                    logger.warn("error deleting {}", (Object)dbFile.getPath());
                }
                dbOptions.setCreateIfMissing(true);
                try {
                    tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
                }
                catch (RocksDBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            try {
                RocksDBProvider.checkVersion(tmpDb, version, mapper);
            }
            catch (RocksDBException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return tmpDb;
    }

    @VisibleForTesting
    static RocksDB initRocksDB(File file) throws IOException {
        BloomFilter fullFilter = new BloomFilter(10.0, false);
        BlockBasedTableConfig tableFormatConfig = new BlockBasedTableConfig().setFilterPolicy((Filter)fullFilter).setEnableIndexCompression(false).setIndexBlockRestartInterval(8).setFormatVersion(5);
        Options dbOptions = new Options();
        dbOptions.setCreateIfMissing(true);
        dbOptions.setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION);
        dbOptions.setCompressionType(CompressionType.LZ4_COMPRESSION);
        dbOptions.setTableFormatConfig((TableFormatConfig)tableFormatConfig);
        try {
            return RocksDB.open((Options)dbOptions, (String)file.toString());
        }
        catch (RocksDBException e) {
            throw new IOException("Unable to open state store", e);
        }
    }

    public static void checkVersion(RocksDB db, StoreVersion newversion, ObjectMapper mapper) throws IOException, RocksDBException {
        byte[] bytes = db.get(StoreVersion.KEY);
        if (bytes == null) {
            RocksDBProvider.storeVersion(db, newversion, mapper);
        } else {
            StoreVersion version = (StoreVersion)mapper.readValue(bytes, StoreVersion.class);
            if (version.major != newversion.major) {
                throw new IOException("cannot read state DB with version " + version + ", incompatible with current version " + newversion);
            }
            RocksDBProvider.storeVersion(db, newversion, mapper);
        }
    }

    public static void storeVersion(RocksDB db, StoreVersion version, ObjectMapper mapper) throws IOException, RocksDBException {
        db.put(StoreVersion.KEY, mapper.writeValueAsBytes((Object)version));
    }

    static {
        RocksDB.loadLibrary();
        logger = LoggerFactory.getLogger(RocksDBProvider.class);
    }

    private static class RocksDBLogger
    extends org.rocksdb.Logger {
        private static final Logger LOG = LoggerFactory.getLogger(RocksDBLogger.class);

        RocksDBLogger(Options options) {
            super(options);
        }

        protected void log(InfoLogLevel infoLogLevel, String message) {
            if (infoLogLevel == InfoLogLevel.INFO_LEVEL) {
                LOG.info(message);
            }
        }
    }
}

