/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.repl.Signaling$;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.Settings;

public final class Main$
implements Logging {
    public static Main$ MODULE$;
    private final SparkConf conf;
    private final String rootDir;
    private final File outputDir;
    private SparkContext sparkContext;
    private SparkSession sparkSession;
    private SparkILoop interp;
    private boolean hasErrors;
    private boolean isShellSession;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Main$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public String rootDir() {
        return this.rootDir;
    }

    public File outputDir() {
        return this.outputDir;
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public void sparkSession_$eq(SparkSession x$1) {
        this.sparkSession = x$1;
    }

    public SparkILoop interp() {
        return this.interp;
    }

    public void interp_$eq(SparkILoop x$1) {
        this.interp = x$1;
    }

    private boolean hasErrors() {
        return this.hasErrors;
    }

    private void hasErrors_$eq(boolean x$1) {
        this.hasErrors = x$1;
    }

    private boolean isShellSession() {
        return this.isShellSession;
    }

    private void isShellSession_$eq(boolean x$1) {
        this.isShellSession = x$1;
    }

    private void scalaOptionError(String msg) {
        this.hasErrors_$eq(true);
        Console$.MODULE$.err().println(msg);
    }

    public void main(String[] args) {
        this.isShellSession_$eq(true);
        this.doMain(args, new SparkILoop());
    }

    public void doMain(String[] args, SparkILoop _interp) {
        this.interp_$eq(_interp);
        String jars = ((TraversableOnce)Utils$.MODULE$.getLocalUserJarsForShell(this.conf()).map((Function1 & Serializable & scala.Serializable)x -> {
            if (x.startsWith("file:")) {
                return new File(new URI((String)x)).getPath();
            }
            return x;
        }, Seq$.MODULE$.canBuildFrom())).mkString(File.pathSeparator);
        List interpArguments = (List)new .colon.colon((Object)"-Yrepl-class-based", (List)new .colon.colon((Object)"-Yrepl-outdir", (List)new .colon.colon((Object)String.valueOf(this.outputDir().getAbsolutePath()), (List)new .colon.colon((Object)"-classpath", (List)new .colon.colon((Object)jars, (List)Nil$.MODULE$))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList(), List$.MODULE$.canBuildFrom());
        GenericRunnerSettings settings = new GenericRunnerSettings((Function1 & Serializable & scala.Serializable)msg -> {
            Main$.MODULE$.scalaOptionError(msg);
            return BoxedUnit.UNIT;
        });
        settings.processArguments(interpArguments, true);
        if (!this.hasErrors()) {
            this.interp().process((Settings)settings);
            Option$.MODULE$.apply((Object)this.sparkContext()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.stop();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public SparkSession createSparkSession() {
        SparkSession sparkSession;
        try {
            String execUri = System.getenv("SPARK_EXECUTOR_URI");
            this.conf().setIfMissing("spark.app.name", "Spark shell");
            this.conf().set("spark.repl.class.outputDir", this.outputDir().getAbsolutePath());
            Object object = execUri != null ? this.conf().set("spark.executor.uri", execUri) : BoxedUnit.UNIT;
            Object object2 = System.getenv("SPARK_HOME") != null ? this.conf().setSparkHome(System.getenv("SPARK_HOME")) : BoxedUnit.UNIT;
            SparkSession.Builder builder = SparkSession$.MODULE$.builder().config(this.conf());
            String string = this.conf().get(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive").toLowerCase(Locale.ROOT);
            String string2 = "hive";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (SparkSession$.MODULE$.hiveClassesArePresent()) {
                    this.sparkSession_$eq(builder.enableHiveSupport().getOrCreate());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Created Spark session with Hive support");
                } else {
                    builder.config(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "in-memory");
                    this.sparkSession_$eq(builder.getOrCreate());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Created Spark session");
                }
            } else {
                this.sparkSession_$eq(builder.getOrCreate());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Created Spark session");
            }
            this.sparkContext_$eq(this.sparkSession().sparkContext());
            sparkSession = this.sparkSession();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassNotFoundException) {
                ClassNotFoundException classNotFoundException = (ClassNotFoundException)throwable2;
                if (this.isShellSession() && classNotFoundException.getMessage().contains("org.apache.spark.sql.connect.SparkConnectPlugin")) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to load spark connect plugin.");
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "You need to build Spark with -Pconnect.");
                    throw package$.MODULE$.exit(1);
                }
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                if (this.isShellSession()) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to initialize Spark session.", exception);
                    throw package$.MODULE$.exit(1);
                }
            }
            throw throwable;
        }
        return sparkSession;
    }

    private Main$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.initializeLogIfNecessary(true);
        Signaling$.MODULE$.cancelOnInterrupt();
        this.conf = new SparkConf();
        this.rootDir = (String)this.conf().getOption("spark.repl.classdir").getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.getLocalDir(MODULE$.conf()));
        this.outputDir = Utils$.MODULE$.createTempDir(this.rootDir(), "repl");
        this.hasErrors = false;
        this.isShellSession = false;
    }
}

