/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnixTime;
import org.apache.spark.sql.catalyst.expressions.UnixTimestamp$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([timeExp[, fmt]]) - Returns the UNIX timestamp of current or specified time.", arguments="\n    Arguments:\n      * timeExp - A date/timestamp or string. If not provided, this defaults to current time.\n      * fmt - Date/time format pattern to follow. Ignored if `timeExp` is not a string.\n              Default value is \"yyyy-MM-dd HH:mm:ss\". See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\"> Datetime Patterns</a>\n              for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       1476884637\n      > SELECT _FUNC_('2016-04-08', 'yyyy-MM-dd');\n       1460041200\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0015*\u0001ZB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003G\u0011!a\u0005A!f\u0001\n\u0003i\u0005\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u0011u\u0003!Q3A\u0005\u0002yC\u0001B\u0019\u0001\u0003\u0012\u0003\u0006Ia\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006G\u0002!\tA\u001b\u0005\u0006[\u0002!\t%\u0012\u0005\u0006]\u0002!\t%\u0012\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006G\u0002!\t!\u001e\u0005\u0006G\u0002!\t\u0001\u001f\u0005\u0006s\u0002!\tE\u001f\u0005\u0006w\u0002!\t\u0006 \u0005\n\u0003\u0007\u0001\u0011\u0011!C\u0001\u0003\u000bA\u0011\"a\u0004\u0001#\u0003%\t!!\u0005\t\u0013\u0005\u001d\u0002!%A\u0005\u0002\u0005E\u0001\"CA\u0015\u0001E\u0005I\u0011AA\u0016\u0011%\ty\u0003AI\u0001\n\u0003\t\t\u0004C\u0005\u00026\u0001\t\t\u0011\"\u0011\u00028!I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003#\u0002\u0011\u0011!C\u0001\u0003'B\u0011\"a\u0018\u0001\u0003\u0003%\t%!\u0019\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0004\"CA;\u0001\u0005\u0005I\u0011IA<\u000f%\t\t+KA\u0001\u0012\u0003\t\u0019K\u0002\u0005)S\u0005\u0005\t\u0012AAS\u0011\u0019\u0019g\u0004\"\u0001\u00024\"I\u0011Q\u0017\u0010\u0002\u0002\u0013\u0015\u0013q\u0017\u0005\n\u0003ss\u0012\u0011!CA\u0003wC\u0011\"!2\u001f#\u0003%\t!a\u000b\t\u0013\u0005\u001dg$%A\u0005\u0002\u0005E\u0002\"CAe=\u0005\u0005I\u0011QAf\u0011%\tINHI\u0001\n\u0003\tY\u0003C\u0005\u0002\\z\t\n\u0011\"\u0001\u00022!I\u0011Q\u001c\u0010\u0002\u0002\u0013%\u0011q\u001c\u0002\u000e+:L\u0007\u0010V5nKN$\u0018-\u001c9\u000b\u0005)Z\u0013aC3yaJ,7o]5p]NT!\u0001L\u0017\u0002\u0011\r\fG/\u00197zgRT!AL\u0018\u0002\u0007M\fHN\u0003\u00021c\u0005)1\u000f]1sW*\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001c<\u0003B\u0011\u0001(O\u0007\u0002S%\u0011!(\u000b\u0002\t+:L\u0007\u0010V5nKB\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\u001fC\u0013\t\u0019UH\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004uS6,W\t\u001f9\u0016\u0003\u0019\u0003\"\u0001O$\n\u0005!K#AC#yaJ,7o]5p]\u0006AA/[7f\u000bb\u0004\b%\u0001\u0004g_Jl\u0017\r^\u0001\bM>\u0014X.\u0019;!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002\u001dB\u0019AhT)\n\u0005Ak$AB(qi&|g\u000e\u0005\u0002S3:\u00111k\u0016\t\u0003)vj\u0011!\u0016\u0006\u0003-V\na\u0001\u0010:p_Rt\u0014B\u0001->\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ak\u0014a\u0003;j[\u0016TvN\\3JI\u0002\n1BZ1jY>sWI\u001d:peV\tq\f\u0005\u0002=A&\u0011\u0011-\u0010\u0002\b\u0005>|G.Z1o\u000311\u0017-\u001b7P]\u0016\u0013(o\u001c:!\u0003\u0019a\u0014N\\5u}Q)QMZ4iSB\u0011\u0001\b\u0001\u0005\u0006\t&\u0001\rA\u0012\u0005\u0006\u0015&\u0001\rA\u0012\u0005\b\u0019&\u0001\n\u00111\u0001O\u0011\u001di\u0016\u0002%AA\u0002}#2!Z6m\u0011\u0015!%\u00021\u0001G\u0011\u0015Q%\u00021\u0001G\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0005E$\bC\u0001\u001ds\u0013\t\u0019\u0018FA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]\")A*\u0004a\u0001#R\u0011QM\u001e\u0005\u0006o:\u0001\rAR\u0001\u0005i&lW\rF\u0001f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002#\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004Kv|\b\"\u0002@\u0012\u0001\u00041\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003\u0003\t\u0002\u0019\u0001$\u0002\u00119,wOU5hQR\fAaY8qsRIQ-a\u0002\u0002\n\u0005-\u0011Q\u0002\u0005\b\tJ\u0001\n\u00111\u0001G\u0011\u001dQ%\u0003%AA\u0002\u0019Cq\u0001\u0014\n\u0011\u0002\u0003\u0007a\nC\u0004^%A\u0005\t\u0019A0\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0003\u0016\u0004\r\u0006U1FAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005R(\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u0017U\rq\u0015QC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019DK\u0002`\u0003+\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nA\u0001\\1oO*\u0011\u00111I\u0001\u0005U\u00064\u0018-C\u0002[\u0003{\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0013\u0011\u0007q\ni%C\u0002\u0002Pu\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0016\u0002\\A\u0019A(a\u0016\n\u0007\u0005eSHA\u0002B]fD\u0011\"!\u0018\u001a\u0003\u0003\u0005\r!a\u0013\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0007\u0005\u0004\u0002f\u0005-\u0014QK\u0007\u0003\u0003OR1!!\u001b>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\n9G\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA0\u0002t!I\u0011QL\u000e\u0002\u0002\u0003\u0007\u0011QK\u0001\u0007KF,\u0018\r\\:\u0015\u0007}\u000bI\bC\u0005\u0002^q\t\t\u00111\u0001\u0002V!:\u0002!! \u0002\u0004\u0006\u0015\u0015\u0011RAF\u0003\u001f\u000b\t*!&\u0002\u0018\u0006m\u0015Q\u0014\t\u0004q\u0005}\u0014bAAAS\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAD\u0003M{f)\u0016(D?\"ZF/[7f\u000bb\u00048\f\f\u0011g[RlV,\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011V\u001d&C\u0006\u0005^5nKN$\u0018-\u001c9!_\u001a\u00043-\u001e:sK:$\be\u001c:!gB,7-\u001b4jK\u0012\u0004C/[7f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u001b\u000b11\b\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.Z#ya\u0002j\u0003%\u0011\u0011eCR,w\u0006^5nKN$\u0018-\u001c9!_J\u00043\u000f\u001e:j]\u001et\u0003%\u00134!]>$\b\u0005\u001d:pm&$W\r\u001a\u0017!i\"L7\u000f\t3fM\u0006,H\u000e^:!i>\u00043-\u001e:sK:$\b\u0005^5nK:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ7uA5\u0002C)\u0019;f_QLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8!i>\u0004cm\u001c7m_^t\u0003%S4o_J,G\rI5gA\u0001$\u0018.\\3FqB\u0004\u0007%[:!]>$\b%\u0019\u0011tiJLgn\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\t\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004#%_=zs6jU*\f3eA!C%(\\7;gN\u0014c\u0006I*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.I\u0006$X\r^5nK6\u0002\u0018\r\u001e;fe:t\u0003\u000e^7mEy\u0002C)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ8sAY\fG.\u001b3!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u00111S\u0001\u0002\u0004)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112i]2\u0004\b\u000f\u001b7g]R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0003\u0007N\u00171q\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00195mA\u0002D'\r\u001a1a)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002\u001a\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAP\u0003\u0015\td&\u000e\u00181\u00035)f.\u001b=US6,7\u000f^1naB\u0011\u0001HH\n\u0005=\u0005\u001d\u0016\tE\u0005\u0002*\u0006=fI\u0012(`K6\u0011\u00111\u0016\u0006\u0004\u0003[k\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003c\u000bYKA\tBEN$(/Y2u\rVt7\r^5p]R\"\"!a)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013\u0015\fi,a0\u0002B\u0006\r\u0007\"\u0002#\"\u0001\u00041\u0005\"\u0002&\"\u0001\u00041\u0005b\u0002'\"!\u0003\u0005\rA\u0014\u0005\b;\u0006\u0002\n\u00111\u0001`\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!\u0011QZAk!\u0011at*a4\u0011\u000fq\n\tN\u0012$O?&\u0019\u00111[\u001f\u0003\rQ+\b\u000f\\35\u0011!\t9\u000eJA\u0001\u0002\u0004)\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!9\u0011\t\u0005m\u00121]\u0005\u0005\u0003K\fiD\u0001\u0004PE*,7\r\u001e")
public class UnixTimestamp
extends UnixTime
implements Serializable {
    private final Expression timeExp;
    private final Expression format;
    private final Option<String> timeZoneId;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$4() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return UnixTimestamp$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<String>, Object>> unapply(UnixTimestamp unixTimestamp) {
        return UnixTimestamp$.MODULE$.unapply(unixTimestamp);
    }

    public static boolean apply$default$4() {
        return UnixTimestamp$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return UnixTimestamp$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<String>, Object>, UnixTimestamp> tupled() {
        return UnixTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, Function1<Object, UnixTimestamp>>>> curried() {
        return UnixTimestamp$.MODULE$.curried();
    }

    public Expression timeExp() {
        return this.timeExp;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression left() {
        return this.timeExp();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public String prettyName() {
        return "unix_timestamp";
    }

    @Override
    public UnixTimestamp withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    public UnixTimestamp copy(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        return new UnixTimestamp(timeExp, format, timeZoneId, failOnError);
    }

    public Expression copy$default$1() {
        return this.timeExp();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnixTimestamp";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.timeExp();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return this.timeZoneId();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnixTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnixTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnixTimestamp unixTimestamp = (UnixTimestamp)x$1;
        Expression expression = this.timeExp();
        Expression expression2 = unixTimestamp.timeExp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = unixTimestamp.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = unixTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.failOnError() != unixTimestamp.failOnError()) return false;
        if (!unixTimestamp.canEqual(this)) return false;
        return true;
    }

    public UnixTimestamp(Expression timeExp, Expression format, Option<String> timeZoneId, boolean failOnError) {
        this.timeExp = timeExp;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
    }

    public UnixTimestamp(Expression timeExp, Expression format) {
        this(timeExp, format, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public UnixTimestamp(Expression time) {
        this(time, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }

    public UnixTimestamp() {
        this(new CurrentTimestamp());
    }
}

