/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.WriteBufferManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;

public final class RocksDBMemoryManager$
implements Logging {
    public static RocksDBMemoryManager$ MODULE$;
    private WriteBufferManager writeBufferManager;
    private Cache cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RocksDBMemoryManager$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private WriteBufferManager writeBufferManager() {
        return this.writeBufferManager;
    }

    private void writeBufferManager_$eq(WriteBufferManager x$1) {
        this.writeBufferManager = x$1;
    }

    private Cache cache() {
        return this.cache;
    }

    private void cache_$eq(Cache x$1) {
        this.cache = x$1;
    }

    public synchronized Tuple2<WriteBufferManager, Cache> getOrCreateRocksDBMemoryManagerAndCache(RocksDBConf conf) {
        if (conf.boundedMemoryUsage()) {
            if (this.writeBufferManager() == null) {
                Predef$.MODULE$.assert(this.cache() == null);
                if (conf.writeBufferCacheRatio() + conf.highPriorityPoolRatio() >= 1.0) {
                    throw new IllegalArgumentException("Sum of writeBufferCacheRatio and highPriorityPoolRatio should be less than 1.0");
                }
                if (conf.totalMemoryUsageMB() <= 0L) {
                    throw new IllegalArgumentException("Total memory usage must be a positive integer");
                }
                long totalMemoryUsageInBytes = conf.totalMemoryUsageMB() * 1024L * 1024L;
                this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(55).append("Creating RocksDB state store LRU cache with ").append("total_size=").append(totalMemoryUsageInBytes).toString());
                this.cache_$eq((Cache)new LRUCache(totalMemoryUsageInBytes, -1, true, conf.highPriorityPoolRatio()));
                this.writeBufferManager_$eq(new WriteBufferManager((long)((double)totalMemoryUsageInBytes * conf.writeBufferCacheRatio()), this.cache()));
            }
            return new Tuple2((Object)this.writeBufferManager(), (Object)this.cache());
        }
        return new Tuple2(null, (Object)new LRUCache(conf.blockCacheSizeMB() * 1024L * 1024L));
    }

    public synchronized void resetWriteBufferManagerAndCache() {
        this.writeBufferManager_$eq(null);
        this.cache_$eq(null);
    }

    private RocksDBMemoryManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.writeBufferManager = null;
        this.cache = null;
    }
}

