/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.ForwardCompatibility;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;

public abstract class CompactSketch
extends Sketch {
    private static final short defaultSeedHash = Util.computeSeedHash(9001L);

    public static CompactSketch heapify(Memory srcMem) {
        int serVer = srcMem.getByte(1L) & 0xFF;
        int familyID = srcMem.getByte(2L) & 0xFF;
        Family family = Family.idToFamily(familyID);
        if (family != Family.COMPACT) {
            throw new IllegalArgumentException("Corrupted: " + (Object)((Object)family) + " is not Compact!");
        }
        if (serVer == 3) {
            int flags = PreambleUtil.extractFlags(srcMem);
            boolean srcOrdered = (flags & 0x10) != 0;
            return CompactOperations.memoryToCompact(srcMem, srcOrdered, null);
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, defaultSeedHash);
        }
        if (serVer == 2) {
            short srcSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
            return ForwardCompatibility.heapify2to3(srcMem, srcSeedHash);
        }
        throw new SketchesArgumentException("Unknown Serialization Version: " + serVer);
    }

    public static CompactSketch heapify(Memory srcMem, long expectedSeed) {
        byte serVer = srcMem.getByte(1L);
        byte familyID = srcMem.getByte(2L);
        Family family = Family.idToFamily(familyID);
        if (family != Family.COMPACT) {
            throw new IllegalArgumentException("Corrupted: " + (Object)((Object)family) + " is not Compact!");
        }
        if (serVer == 3) {
            boolean empty;
            int flags = PreambleUtil.extractFlags(srcMem);
            boolean srcOrdered = (flags & 0x10) != 0;
            boolean bl = empty = (flags & 4) != 0;
            if (!empty) {
                PreambleUtil.checkMemorySeedHash(srcMem, expectedSeed);
            }
            return CompactOperations.memoryToCompact(srcMem, srcOrdered, null);
        }
        short seedHash = Util.computeSeedHash(expectedSeed);
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, seedHash);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(srcMem, seedHash);
        }
        throw new SketchesArgumentException("Unknown Serialization Version: " + serVer);
    }

    public static CompactSketch wrap(Memory srcMem) {
        int serVer = srcMem.getByte(1L) & 0xFF;
        int familyID = srcMem.getByte(2L) & 0xFF;
        Family family = Family.idToFamily(familyID);
        if (family != Family.COMPACT) {
            throw new IllegalArgumentException("Corrupted: " + (Object)((Object)family) + " is not Compact!");
        }
        if (serVer == 3) {
            boolean readOnly;
            boolean compactFlag;
            if (PreambleUtil.isEmptyFlag(srcMem)) {
                return EmptyCompactSketch.getHeapInstance(srcMem);
            }
            short memSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
            if (SingleItemSketch.otherCheckForSingleItem(srcMem)) {
                return SingleItemSketch.heapify(srcMem, memSeedHash);
            }
            byte flags = srcMem.getByte(5L);
            boolean bl = compactFlag = (flags & 8) > 0;
            if (!compactFlag) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have compact flag set");
            }
            boolean bl2 = readOnly = (flags & 2) > 0;
            if (!readOnly) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have Read-Only flag set");
            }
            return DirectCompactSketch.wrapInstance(srcMem, memSeedHash);
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, defaultSeedHash);
        }
        if (serVer == 2) {
            short memSeedHash = (short)PreambleUtil.extractSeedHash(srcMem);
            return ForwardCompatibility.heapify2to3(srcMem, memSeedHash);
        }
        throw new SketchesArgumentException("Corrupted: Serialization Version " + serVer + " not recognized.");
    }

    public static CompactSketch wrap(Memory srcMem, long expectedSeed) {
        int serVer = srcMem.getByte(1L) & 0xFF;
        int familyID = srcMem.getByte(2L) & 0xFF;
        Family family = Family.idToFamily(familyID);
        if (family != Family.COMPACT) {
            throw new IllegalArgumentException("Corrupted: " + (Object)((Object)family) + " is not Compact!");
        }
        short seedHash = Util.computeSeedHash(expectedSeed);
        if (serVer == 3) {
            boolean readOnly;
            boolean compactFlag;
            if (PreambleUtil.isEmptyFlag(srcMem)) {
                return EmptyCompactSketch.getHeapInstance(srcMem);
            }
            if (SingleItemSketch.otherCheckForSingleItem(srcMem)) {
                return SingleItemSketch.heapify(srcMem, seedHash);
            }
            byte flags = srcMem.getByte(5L);
            boolean bl = compactFlag = (flags & 8) > 0;
            if (!compactFlag) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have compact flag set");
            }
            boolean bl2 = readOnly = (flags & 2) > 0;
            if (!readOnly) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have Read-Only flag set");
            }
            return DirectCompactSketch.wrapInstance(srcMem, seedHash);
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, seedHash);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(srcMem, seedHash);
        }
        throw new SketchesArgumentException("Corrupted: Serialization Version " + serVer + " not recognized.");
    }

    @Override
    public abstract CompactSketch compact(boolean var1, WritableMemory var2);

    @Override
    public int getCompactBytes() {
        return this.getCurrentBytes();
    }

    @Override
    int getCurrentDataLongs() {
        return this.getRetainedEntries(true);
    }

    @Override
    public Family getFamily() {
        return Family.COMPACT;
    }

    @Override
    public boolean isCompact() {
        return true;
    }
}

